/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*
 * Copyright (C) 2004-2005 Nokia Corporation. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; version 2 of the
 * License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef __DBUS_UTILS_H__
#define __DBUS_UTILS_H__

#include <libgnomevfs/gnome-vfs.h>

#define DBUS_API_SUBJECT_TO_CHANGE
#include <dbus/dbus-glib-lowlevel.h>

/* Note: It could make sense to have DVD_TYPE_FILE_SIZE and FILE_OFFSET instead
 * of the 64 bits variants.
 */
typedef enum {
	DVD_TYPE_LAST = -1,
	DVD_TYPE_URI,
	DVD_TYPE_STRING,
	DVD_TYPE_INT32,
	DVD_TYPE_INT64,
	DVD_TYPE_UINT64,
	DVD_TYPE_FILE_INFO,
	DVD_TYPE_BOOL,
	DVD_TYPE_BYTE_ARRAY
} DvdArgumentType;


gboolean 
dbus_utils_message_iter_append_file_info       (DBusMessageIter        *iter,
						const GnomeVFSFileInfo *info);
gboolean dbus_utils_message_append_file_info   (DBusMessage            *message,
						const GnomeVFSFileInfo *info);
GnomeVFSFileInfo *
dbus_utils_message_iter_get_file_info          (DBusMessageIter        *dict);
GList *  dbus_utils_message_get_file_info_list (DBusMessage            *message);


void dbus_utils_message_append_volume_list (DBusMessage *message, GList *volumes);
void dbus_utils_message_append_drive_list  (DBusMessage *message, GList *drives);

void dbus_utils_message_append_volume      (DBusMessage *message, GnomeVFSVolume *volume);
void dbus_utils_message_append_drive       (DBusMessage *message, GnomeVFSDrive  *drive);

#endif /* __DBUS_UTILS_H__ */
