/**
    @file interface.c

    Implementation of the user interface functions.

    Copyright (c) 2004, 2005 Nokia Corporation.
	
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
    02111-1307 USA
*/

/* Include function prototypes */
#include <stdlib.h>
#include <stdio.h>
#include <libgen.h>
#include <hildon-widgets/hildon-note.h>
#include <libgnomevfs/gnome-vfs.h>
#include <osso-helplib.h>
#include "interface.h"
#include "dbus.h"

#define PLUGIN_HEIGHT           100
#define PLUGIN_WIDTH             -1

GtkWidget *play_item;
GtkWidget *restart_item;
GtkWidget *open_item;
GtkWidget *save_item       = NULL;
GtkWidget *save_as_item    = NULL;
gchar     *game_title      = NULL;

/* The following function is from INDT's games-startup code. The copyrights 
belongs to them. The INDT's games-startup was released under LGPL license. 
This function is modified under LGPL license*/

gboolean show_picture(gpointer user_data)
{
  AppUIData *app_ui_data=(AppUIData*)user_data;
  gtk_image_set_from_file (GTK_IMAGE (app_ui_data->game_image),startup_config_read_entry (startup_app_get_config (app_ui_data), "Image", NULL));
  return FALSE;
}


void on_window_realized(GtkWidget *widget,gpointer data)
{
  AppUIData *app_ui_data=(AppUIData*)data;
  app_ui_data->timeout=g_timeout_add(1, show_picture,
			  data);
  return;
}



/* Create INDT specific menu */
void 
ui_create_indt_menu (AppUIData *ui)
{

  GtkMenu   *main_menu_bar;
  GtkWidget *close_item;
  GtkWidget *game_menu;
  GtkWidget *game_item;
  GtkWidget **plugin_menu; 
  gint nmenu_items = 0, i;
  
  osso_log(LOG_DEBUG,"%s\n",__FUNCTION__);
 
  // Get application view's menu bar 
  main_menu_bar = hildon_appview_get_menu (ui->main_view);
  ui->main_menu_bar=main_menu_bar;
  game_item = gtk_menu_item_new_with_label (_("game_me_chess_main_menu_game"));
  //gtk_menu_bar_append (GTK_MENU (main_menu_bar), game_item);
  gtk_menu_append (GTK_MENU (main_menu_bar), game_item);
  

  game_menu = gtk_menu_new (); 
  gtk_menu_item_set_submenu (GTK_MENU_ITEM (game_item), game_menu);
  ui->game_game_menu=game_menu;

  /* Create the menu items */
  //FIX ME:create generic ids 
  play_item = gtk_menu_item_new_with_label (_("game_me_chess_menu_game_play"));
  gtk_menu_append (GTK_MENU (game_menu), play_item);
  g_signal_connect (G_OBJECT (play_item), "activate",
                            G_CALLBACK (startup_ui_game_play_cb),
                            (gpointer) ui);
  ui->game_play_menu=play_item;
  
  ui->game_restart_menu= gtk_menu_item_new_with_label (_("game_me_chess_menu_game_restart"));
  gtk_menu_append (GTK_MENU (game_menu), ui->game_restart_menu);
  g_signal_connect (G_OBJECT (ui->game_restart_menu), "activate",
                            G_CALLBACK (startup_ui_game_restart_cb),
                            (gpointer) ui);

  if (ui->plugin && ui->plugin->info->load_menu) {
    if(ui->plugin->menu_open_save && ui->plugin->info->plugin_cb) {
      gtk_menu_append (GTK_MENU (game_menu), gtk_menu_item_new()); 
    open_item = gtk_menu_item_new_with_label (_("game_me_chess_menu_game_open"));
		  ui->open_item=open_item;
      gtk_menu_append (GTK_MENU (game_menu), open_item);
      g_signal_connect (G_OBJECT (open_item), "activate",
                        G_CALLBACK (ui->plugin->info->plugin_cb),
                        (gpointer) ME_GAME_OPEN);      
      //save_item = gtk_menu_item_new_with_label (_("game_me_chess_menu_game_save"));
		ui->game_save_menu = gtk_menu_item_new_with_label (_("game_me_chess_menu_game_save"));
		//ui->game_save_menu=save_as_item;
      //gtk_menu_append (GTK_MENU (game_menu), save_item);
		gtk_menu_append (GTK_MENU (game_menu), ui->game_save_menu);
      //g_signal_connect (G_OBJECT (save_item), "activate",
		g_signal_connect (G_OBJECT (ui->game_save_menu), "activate",
                        G_CALLBACK (ui->plugin->info->plugin_cb),
                        (gpointer) ME_GAME_SAVE);    

      ui->game_saveas_menu= gtk_menu_item_new_with_label (_("game_me_chess_menu_game_save_as"));
		//ui->game_saveas_menu=save_as_item;
      gtk_menu_append (GTK_MENU (game_menu), ui->game_saveas_menu);
      g_signal_connect (G_OBJECT (ui->game_saveas_menu), "activate",
                        G_CALLBACK (ui->plugin->info->plugin_cb),
                        (gpointer) ME_GAME_SAVE_AS);    

          

      /*if (startup_app_get_game_state (ui->app) == GAME_UNLOADED ||
          startup_app_get_game_state (ui->app) == GAME_CLOSED) {*/
		  if (get_game_state() == gs_unloaded ||
          get_game_state() == gs_closed) {
        gtk_widget_set_sensitive(ui->game_save_menu, FALSE);
        gtk_widget_set_sensitive(ui->game_saveas_menu, FALSE);
      }
    }

    plugin_menu = ui->plugin->info->load_menu (&nmenu_items);
    // Conditional creation, by game type.
    for(i=0; i<nmenu_items; i++){
       if(GTK_IS_MENU_ITEM(plugin_menu[i])){
         //gtk_menu_bar_append (GTK_MENU_BAR (main_menu_bar), plugin_menu[i]);
         gtk_menu_append (GTK_MENU (main_menu_bar), plugin_menu[i]);
       }
    }
    if (ui->plugin->info->update_menu)
      ui->plugin->info->update_menu();
  }
  close_item = gtk_menu_item_new_with_label (_("game_me_main_menu_close"));
  //gtk_menu_bar_append (GTK_MENU_BAR (main_menu_bar), close_item);
  gtk_menu_append (GTK_MENU (main_menu_bar), close_item);
  g_signal_connect (G_OBJECT (close_item), "activate",
                            //G_CALLBACK (startup_ui_game_quit_cb),
														G_CALLBACK (game_quit_cb),
                            (gpointer) ui);
  
  /*if (startup_app_get_game_state (ui->app) == GAME_UNLOADED ||
      startup_app_get_game_state (ui->app) == GAME_CLOSED)
    gtk_widget_set_sensitive(restart_item, FALSE);*/
  if (get_game_state() == gs_unloaded || get_game_state()== gs_closed)
	  gtk_widget_set_sensitive(ui->game_restart_menu, FALSE);
  
  gtk_widget_show_all (GTK_WIDGET (main_menu_bar));
  

}


/* Create the main window */
void ui_create_main_window( AppData *app_data )
{
  AppUIData *app_ui_data;
  
  g_assert(app_data);

  app_ui_data = app_data->app_ui_data;

  /* Initialize app ui data pointer in callbacks module */
  cb_init(app_ui_data);
    
  app_ui_data->app = ui_create_main_app(app_data);
  g_assert(app_ui_data->app);

  /* The view depends on the game type */
  switch ( get_game_type() ) {
  default:
  case gt_chess:
    app_ui_data->main_view = ui_create_chess_view( app_ui_data );
    hildon_app_set_title( app_ui_data->app, _("game_ap_chess_name") );
    hildon_app_set_two_part_title( app_ui_data->app, TRUE );
    break;

  case gt_mahjong:
    app_ui_data->main_view = ui_create_mahjong_view( app_ui_data );
    hildon_app_set_title( app_ui_data->app, _("game_ap_mahjong_name") );
    break;

  case gt_lmarbles:
    app_ui_data->main_view = ui_create_lmarbles_view( app_ui_data );
    hildon_app_set_title( app_ui_data->app, _("game_ap_marbles_name") );
    break;
  case gt_indt:
    ui_create_indt_view( app_ui_data );
    if(app_ui_data->plugin->menu_open_save && app_ui_data->plugin->info->plugin_cb){
      osso_log(LOG_DEBUG,"Creating two part title");
      hildon_app_set_two_part_title( app_ui_data->app, TRUE );
    }
    break;
  }

  g_assert(app_ui_data->main_view);

  /* Connect destroy signal */
  /* g_signal_connect( G_OBJECT( app_ui_data->app ), "destroy",
        G_CALLBACK( gtk_main_quit ), (gpointer)app_ui_data); */

  /* Connect delete signal */
  g_signal_connect( G_OBJECT( app_ui_data->app ), "delete_event",
        G_CALLBACK( game_quit_cb ), (gpointer)app_ui_data);

  /* Connect topmost status lose signal */
  g_signal_connect( G_OBJECT( app_ui_data->app ), "topmost_status_lose",
        G_CALLBACK( game_untop_cb ), (gpointer)app_data);

  /* Connect topmost status acquire signal */
  g_signal_connect( G_OBJECT( app_ui_data->app ), "topmost_status_acquire",
        G_CALLBACK( game_top_cb ), (gpointer)app_data);

  hildon_app_set_appview( app_ui_data->app,
  app_ui_data->main_view );

  if (get_game_type()!=gt_indt)
  {
  ui_create_menu( app_ui_data );
  ui_show_menu( app_ui_data );
  ui_localize_menu( GTK_CONTAINER (app_ui_data->main_menu_bar) );
  }
  else
  {
	ui_create_indt_menu(app_ui_data);
  }

  //gtk_widget_show_all( GTK_WIDGET (app_ui_data->main_menu_bar) );
  if (get_game_type() == gt_chess) {
    ui_update_recent_items(app_ui_data);
  }

  gtk_widget_show_all( GTK_WIDGET (app_ui_data->app) );

  app_ui_data->skip_box_update = FALSE;
  app_ui_data->chess_saved = FALSE;

  ui_update_status( app_ui_data );
  get_settings( app_ui_data );
}

HildonApp *ui_create_main_app( AppData *app_data )
{
  HildonApp *result = NULL;

  /* Create HildonApp */
  result = HILDON_APP( hildon_app_new() );

  g_signal_connect(G_OBJECT(result), "key_press_event",
    G_CALLBACK(key_press), (gpointer)app_data);
    
  /* Catch delete event for save query */
  g_signal_connect ( G_OBJECT(result), "delete_event",
    G_CALLBACK(on_delete_event), (gpointer)(app_data->app_ui_data));
  g_signal_connect ( G_OBJECT(result), "show",
    G_CALLBACK(on_window_realized), (gpointer)(app_data->app_ui_data));
    

  hildon_app_set_killable( result, FALSE );
  hildon_app_set_autoregistration( result, TRUE );

  return result;
}

gboolean ui_update_status( AppUIData *app_ui_data )
{
  g_assert(app_ui_data);
  osso_log (LOG_DEBUG, "%s\n", __FUNCTION__);
  /* Get game state */
  GameState gs = get_game_state();

  if (app_ui_data->play_button==NULL) return FALSE;
  if (app_ui_data->continue_button==NULL) return FALSE;
  if (app_ui_data->controls_state_label==NULL) return FALSE;

  g_assert(app_ui_data->play_button);
  g_assert(app_ui_data->continue_button);
  g_assert(app_ui_data->controls_state_label);

  /* Game is unloaded */
  if (gs==gs_unloaded) {
    gtk_label_set_text( GTK_LABEL(app_ui_data->controls_state_label),
      _("game_ia_startup_not_started") );

    gtk_widget_show(app_ui_data->play_button);
    gtk_widget_hide(app_ui_data->continue_button);

    gtk_widget_set_sensitive(app_ui_data->restart_button,FALSE);

    menu_set_restart_dimmed( app_ui_data, FALSE );
    menu_set_save_dimmed( app_ui_data, FALSE );
  }
  /* Game is paused */
  else if (gs==gs_paused) {
    
    gtk_label_set_text( GTK_LABEL(app_ui_data->controls_state_label),
      _("game_ia_startup_paused") );
    gtk_widget_hide(app_ui_data->play_button);

    gtk_widget_show(app_ui_data->continue_button);

    gtk_widget_set_sensitive(app_ui_data->restart_button,TRUE);
    if (app_ui_data->window_front_needed)
    {
      gtk_window_present(GTK_WINDOW(app_ui_data->app));
      app_ui_data->window_front_needed=FALSE;
    }

    menu_set_restart_dimmed( app_ui_data, TRUE );
    menu_set_save_dimmed( app_ui_data, TRUE );
  }
  /* Game is closed */
  else if (gs==gs_closed) {
    gtk_label_set_text( GTK_LABEL(app_ui_data->controls_state_label),
      _("game_ia_startup_not_started") );

    gtk_widget_show(app_ui_data->play_button);
    gtk_widget_hide(app_ui_data->continue_button);

    gtk_widget_set_sensitive(app_ui_data->restart_button,FALSE);
    gtk_widget_set_sensitive(app_ui_data->play_button,TRUE);

    menu_set_restart_dimmed( app_ui_data, FALSE );
    menu_set_save_dimmed( app_ui_data, FALSE );
  }

  /* For show infoprint if user selects dimmed command in menu */ 
  ui_set_dimmed_menu_item_callback(app_ui_data);

  return TRUE;
}

void ui_create_games_common_view( AppUIData *app_ui_data)
{
  /* Get game state */
  GameState gs = get_game_state();
	

  /* Create a vbox for all our stuff inside main view */
  app_ui_data->main_vbox = gtk_vbox_new( FALSE, 0 );
  g_assert(app_ui_data->main_vbox);

  gtk_container_add( GTK_CONTAINER (app_ui_data->main_view),
         app_ui_data->main_vbox );

  /* Game title graph */
  app_ui_data->game_image = gtk_image_new();
  g_assert(app_ui_data->game_image);

  gtk_widget_set_size_request(app_ui_data->game_image,
  GAME_IMAGE_WIDTH, GAME_IMAGE_HEIGHT);

  gtk_container_add( GTK_CONTAINER (app_ui_data->main_vbox),
  app_ui_data->game_image );

  /* Create a vbox for common controls */
  app_ui_data->controls_vbox = gtk_vbox_new( FALSE, 0 );
  g_assert(app_ui_data->controls_vbox);

  gtk_container_add( GTK_CONTAINER (app_ui_data->main_vbox),
         app_ui_data->controls_vbox );

  /* Status label */
  app_ui_data->controls_state_label=NULL;
  if (gs==gs_unloaded) {
    app_ui_data->controls_state_label = gtk_label_new(
      _("game_ia_startup_not_started") );
  }
  else if (gs==gs_closed) {
    app_ui_data->controls_state_label = gtk_label_new(
      _("game_ia_startup_not_started") );
  }
  else {
    app_ui_data->controls_state_label = gtk_label_new(
      _("game_ia_startup_paused") );
  }

  if (app_ui_data->controls_state_label!=NULL) {
    g_assert(app_ui_data->controls_state_label);

    gtk_widget_set_size_request(app_ui_data->controls_state_label,
    LABEL_WIDTH, LABEL_HEIGHT);
    gtk_container_add( GTK_CONTAINER (app_ui_data->controls_vbox),
    app_ui_data->controls_state_label );
  }

  /* Create a hbox for common controls */
  app_ui_data->controls_hbox = gtk_hbox_new( FALSE, 0 );
  g_assert(app_ui_data->controls_hbox);

  gtk_container_add( GTK_CONTAINER (app_ui_data->controls_vbox),
  app_ui_data->controls_hbox );

  /* Create a fixed for buttons */
  app_ui_data->controls_fixed = gtk_fixed_new();
  g_assert(app_ui_data->controls_fixed);

  gtk_container_add( GTK_CONTAINER (app_ui_data->controls_hbox),
  app_ui_data->controls_fixed );
  
  /* Continue button */
  app_ui_data->continue_button = gtk_button_new_with_label(
    _("game_bv_startup_continue") );
  g_assert(app_ui_data->continue_button);
  gtk_widget_set_size_request(app_ui_data->continue_button,
  CTRL_BUTTON_WIDTH, CTRL_BUTTON_HEIGHT);

  g_signal_connect(G_OBJECT(app_ui_data->continue_button),"clicked",
  G_CALLBACK(game_continue_cb),(gpointer)app_ui_data);

  gtk_fixed_put( GTK_FIXED( app_ui_data->controls_fixed),
  app_ui_data->continue_button,
  FIRST_BUTTON_LEFT, BUTTONS_TOP );

  gtk_widget_hide(app_ui_data->continue_button);

  /* Play button */
  app_ui_data->play_button = gtk_button_new_with_label(
    _("game_bv_startup_play") );
  g_assert(app_ui_data->play_button);
  gtk_widget_set_size_request(app_ui_data->play_button,
  CTRL_BUTTON_WIDTH, CTRL_BUTTON_HEIGHT);
  

  g_signal_connect(G_OBJECT(app_ui_data->play_button),"clicked",
  G_CALLBACK(game_play_cb),(gpointer)app_ui_data);

  gtk_fixed_put( GTK_FIXED( app_ui_data->controls_fixed),
  app_ui_data->play_button,
  FIRST_BUTTON_LEFT, BUTTONS_TOP );

  

  /* Show proper buttons */
  if (gs==gs_unloaded || gs==gs_closed) {
    gtk_widget_show(app_ui_data->play_button);
    gtk_widget_hide(app_ui_data->continue_button);
  }
  else if (gs==gs_paused) {
    gtk_widget_hide(app_ui_data->play_button);
    gtk_widget_show(app_ui_data->continue_button);
  }

  /* Restart button */
  app_ui_data->restart_button = gtk_button_new_with_label(
    _("game_bv_startup_restart") );
  g_assert(app_ui_data->restart_button);
  gtk_widget_set_size_request(app_ui_data->restart_button,
  CTRL_BUTTON_WIDTH, CTRL_BUTTON_HEIGHT);

  g_signal_connect(G_OBJECT(app_ui_data->restart_button),"clicked",
    G_CALLBACK(game_restart_cb),(gpointer)app_ui_data);

  gtk_fixed_put( GTK_FIXED( app_ui_data->controls_fixed),
    app_ui_data->restart_button,
  SECOND_BUTTON_LEFT, BUTTONS_TOP );

  /* Set button dimmed if required */
  if (gs==gs_unloaded || gs==gs_closed) {
    gtk_widget_set_sensitive(app_ui_data->restart_button,FALSE);
  }
  if (gs==gs_paused) {
    gtk_widget_set_sensitive(app_ui_data->restart_button,TRUE);
  }
   

}

/* The following function is from INDT's games-startup code. The copyrights 
belongs to them. The INDT's games-startup was released under LGPL license. 
This function is modified under LGPL license*/

/* Create the INDT games view */
void ui_create_indt_view( AppUIData *app_ui_data )
{
  HildonAppView *result;
  const gchar *game_gettext_package;
  const gchar *msgid;
  GtkWidget *game_widget=NULL;
  result = HILDON_APPVIEW( hildon_appview_new( "" ) );

  g_assert(result);
  gtk_widget_show_all(result);
  app_ui_data->main_view = result;

  /* Connect destroy signal */
  /*g_signal_connect( G_OBJECT( result ), "destroy",
    G_CALLBACK( game_quit_cb ), (gpointer)app_ui_data );*/
	g_signal_connect( G_OBJECT( app_ui_data->main_view ), "destroy",
    G_CALLBACK( game_quit_cb ), (gpointer)app_ui_data );

  /* Make common view */
  ui_create_games_common_view(app_ui_data);

  /* Game title graph */
  //gtk_image_set_from_file (GTK_IMAGE (app_ui_data->game_image),startup_config_read_entry (startup_app_get_config (app_ui_data), "Image", NULL));
	
  /* Load the application specific part from the plugin*/
  app_ui_data->game_hbox = gtk_hbox_new( FALSE, 0 );
  g_assert(app_ui_data->game_hbox);

  gtk_container_add( GTK_CONTAINER (app_ui_data->main_vbox),
  app_ui_data->game_hbox );
	
  if (app_ui_data->plugin) 
    game_widget = app_ui_data->plugin->info->load ();
  else
    game_widget = gtk_vbox_new (FALSE, 0);
  g_assert (game_widget);
  
  gtk_widget_set_size_request (game_widget,
    PLUGIN_WIDTH, PLUGIN_HEIGHT);
  gtk_container_add (GTK_CONTAINER (app_ui_data->main_vbox),
      game_widget);
	
  game_gettext_package = startup_config_read_entry (startup_app_get_config (app_ui_data), "GettextPackage", NULL);
  if (app_ui_data->plugin && game_gettext_package)
    app_ui_data->plugin->gettext_package = game_gettext_package;
	
  game_gettext_package = startup_config_read_entry (startup_app_get_config (app_ui_data), "GettextPackage", NULL);
  msgid = startup_config_read_entry (startup_app_get_config (app_ui_data), "TitleId", NULL);
  
  if (game_gettext_package && msgid) {
    app_ui_data->game_title = dgettext (game_gettext_package, msgid);
  }
  
  if (!app_ui_data->game_title || app_ui_data->game_title == msgid) {
    app_ui_data->game_title = startup_config_read_entry (startup_app_get_config (app_ui_data), "Title", NULL);
  }
  g_assert (app_ui_data->game_title);

  hildon_app_set_title (app_ui_data->app, 
      app_ui_data->game_title);
  hildon_app_set_appview (app_ui_data->app, app_ui_data->main_view);

  gtk_widget_show_all (GTK_WIDGET (app_ui_data->app));
  gtk_widget_show_all (GTK_WIDGET (app_ui_data->main_view));
  return;
}


HildonAppView *ui_create_chess_view( AppUIData *app_ui_data )
{
  HildonAppView *result;

  result = HILDON_APPVIEW( hildon_appview_new( "" ) );

  g_assert(result);
  app_ui_data->main_view = result;

  /* Connect destroy signal */
  g_signal_connect( G_OBJECT( result ), "destroy",
    G_CALLBACK( game_quit_cb ), (gpointer)app_ui_data );

  /* Make common view */
  ui_create_games_common_view(app_ui_data);

  /* Game title graph */
  gtk_image_set_from_file( GTK_IMAGE( app_ui_data->game_image ),
    PIXMAPSDIR"/osso-games-startup-chess.png");

  /* Chess specific settings */

  /* Create a hbox for game specific settings */
  app_ui_data->game_hbox = gtk_hbox_new( FALSE, 0 );
  g_assert(app_ui_data->game_hbox);

  gtk_container_add( GTK_CONTAINER (app_ui_data->main_vbox),
  app_ui_data->game_hbox );

  /* Create a vbox for labels */
  app_ui_data->chess_labels_vbox = gtk_vbox_new( FALSE, 0 );
  g_assert(app_ui_data->chess_labels_vbox);

  gtk_container_add( GTK_CONTAINER (app_ui_data->game_hbox ),
  app_ui_data->chess_labels_vbox );

  /* Human label */
  app_ui_data->chess_human_label = gtk_label_new(
    _("game_fi_chess_settings_human") );
  g_assert(app_ui_data->chess_human_label);

  gtk_container_add( GTK_CONTAINER (app_ui_data->chess_labels_vbox),
  app_ui_data->chess_human_label );

  /* Opponent label */
  app_ui_data->chess_opponent_label = gtk_label_new(
    _("game_fi_chess_settings_opponent") );
  g_assert(app_ui_data->chess_opponent_label);

  gtk_container_add( GTK_CONTAINER (app_ui_data->chess_labels_vbox),
  app_ui_data->chess_opponent_label );


  /* Create a vbox for player selections */
  app_ui_data->chess_players_vbox = gtk_vbox_new( FALSE, 0 );
  g_assert(app_ui_data->chess_players_vbox);

  gtk_container_add( GTK_CONTAINER (app_ui_data->game_hbox ),
  app_ui_data->chess_players_vbox );

  /* Human selection */
  app_ui_data->chess_human_choice = gtk_combo_box_new_text();
  g_assert(app_ui_data->chess_human_choice);

  gtk_combo_box_append_text( GTK_COMBO_BOX( app_ui_data->chess_human_choice ),
    _("game_va_chess_settings_human_white"));
  gtk_combo_box_append_text( GTK_COMBO_BOX( app_ui_data->chess_human_choice ),
    _("game_va_chess_settings_human_black"));
  gtk_combo_box_set_active( GTK_COMBO_BOX ( app_ui_data->chess_human_choice ),
    0);

  gtk_widget_set_size_request(app_ui_data->chess_human_choice,
    COMBOBOX_WIDTH, COMBOBOX_HEIGHT);
  gtk_container_add( GTK_CONTAINER (app_ui_data->chess_players_vbox),
    app_ui_data->chess_human_choice );
  g_signal_connect(G_OBJECT(app_ui_data->chess_human_choice), "changed",
    G_CALLBACK(chess_human_cb),(gpointer)app_ui_data);

  /* Opponent selection */
  app_ui_data->chess_opponent_choice = gtk_combo_box_new_text();
  g_assert(app_ui_data->chess_opponent_choice);

  gtk_combo_box_append_text(
    GTK_COMBO_BOX( app_ui_data->chess_opponent_choice ),
    _("game_va_chess_settings_opponent_easy"));
  gtk_combo_box_append_text(
    GTK_COMBO_BOX( app_ui_data->chess_opponent_choice ),
    _("game_va_chess_settings_opponent_medium"));
  gtk_combo_box_append_text(
    GTK_COMBO_BOX( app_ui_data->chess_opponent_choice ),
    _("game_va_chess_settings_opponent_hard"));
  gtk_combo_box_append_text(
    GTK_COMBO_BOX( app_ui_data->chess_opponent_choice ),
    _("game_va_chess_settings_opponent_expert"));
  gtk_combo_box_append_text(
    GTK_COMBO_BOX( app_ui_data->chess_opponent_choice ),
    _("game_va_chess_settings_opponent_human"));
  gtk_combo_box_set_active(
    GTK_COMBO_BOX( app_ui_data->chess_opponent_choice ), 4);

  gtk_widget_set_size_request(app_ui_data->chess_opponent_choice,
    COMBOBOX_WIDTH, COMBOBOX_HEIGHT);
  gtk_container_add( GTK_CONTAINER (app_ui_data->chess_players_vbox ),
    app_ui_data->chess_opponent_choice );
  g_signal_connect(G_OBJECT(app_ui_data->chess_opponent_choice), "changed",
    G_CALLBACK(chess_opponent_cb),(gpointer)app_ui_data);

  app_ui_data->chess_checklabels_vbox = gtk_vbox_new( FALSE, 0 );
  g_assert(app_ui_data->chess_checklabels_vbox);

  /* Sound effects */
  app_ui_data->chess_sound_label = gtk_label_new(
    _("game_fi_chess_settings_sound") );
  g_assert(app_ui_data->chess_sound_label);

  gtk_widget_set_size_request(app_ui_data->chess_sound_label,
    LABEL_WIDTH, LABEL_HEIGHT);

  gtk_container_add( GTK_CONTAINER (app_ui_data->chess_checklabels_vbox ),
    app_ui_data->chess_sound_label );

  app_ui_data->chess_moves_label = gtk_label_new(
    _("game_fi_chess_settings_legal_moves") );
  g_assert(app_ui_data->chess_moves_label);

  gtk_widget_set_size_request(app_ui_data->chess_moves_label,
    LABEL_WIDTH, LABEL_HEIGHT);

  gtk_container_add( GTK_CONTAINER (app_ui_data->chess_checklabels_vbox ),
    app_ui_data->chess_moves_label );

  gtk_container_add( GTK_CONTAINER (app_ui_data->game_hbox ),
  app_ui_data->chess_checklabels_vbox );

  app_ui_data->chess_checks_vbox = gtk_vbox_new( FALSE, 0 );
  g_assert(app_ui_data->chess_checks_vbox);

  app_ui_data->chess_sound_check = gtk_check_button_new();
  g_assert(app_ui_data->chess_sound_check);

  gtk_widget_set_size_request(app_ui_data->chess_sound_check,
    LABEL_WIDTH, LABEL_HEIGHT);
  gtk_container_add( GTK_CONTAINER (app_ui_data->chess_checks_vbox ),
    app_ui_data->chess_sound_check );
  g_signal_connect(G_OBJECT(app_ui_data->chess_sound_check), "clicked",
    G_CALLBACK(game_sound_cb),(gpointer)app_ui_data);

  app_ui_data->chess_moves_check = gtk_check_button_new();
  g_assert(app_ui_data->chess_moves_check);

  gtk_widget_set_size_request(app_ui_data->chess_moves_check,
    LABEL_WIDTH, LABEL_HEIGHT);
  gtk_container_add( GTK_CONTAINER (app_ui_data->chess_checks_vbox ),
    app_ui_data->chess_moves_check );
  g_signal_connect(G_OBJECT(app_ui_data->chess_moves_check), "clicked",
    G_CALLBACK(game_moves_cb),(gpointer)app_ui_data);

  gtk_container_add( GTK_CONTAINER (app_ui_data->game_hbox ),
    app_ui_data->chess_checks_vbox );

  app_ui_data->chess_recent_items =
    settings_get_list_string(SETTINGS_CHESS_RECENT_ITEMS);

  app_ui_data->chess_saved = FALSE;

  return result;
}

HildonAppView *ui_create_mahjong_view( AppUIData *app_ui_data )
{
  HildonAppView *result;

  result = HILDON_APPVIEW( hildon_appview_new( "mahjong_view" ) );

  g_assert(result);
  app_ui_data->main_view = result;

  /* Connect destroy signal */
  g_signal_connect( G_OBJECT( result ), "destroy",
    G_CALLBACK( game_quit_cb ), (gpointer)app_ui_data );

  /* Make common view */
  ui_create_games_common_view(app_ui_data);

  /* Game title graph */
  gtk_image_set_from_file( GTK_IMAGE( app_ui_data->game_image ),
    PIXMAPSDIR"/osso-games-startup-mahjong.png");

  /* Chess specific settings */

  /* Create a hbox for game specific settings */
  app_ui_data->game_hbox = gtk_hbox_new( FALSE, 0 );
  g_assert(app_ui_data->game_hbox);

  gtk_container_add( GTK_CONTAINER (app_ui_data->main_vbox),
    app_ui_data->game_hbox );

  /* Create a vbox for labels */
  app_ui_data->mahjong_labels_vbox = gtk_vbox_new( FALSE, 0 );
  g_assert(app_ui_data->mahjong_labels_vbox);

  gtk_container_add( GTK_CONTAINER (app_ui_data->game_hbox ),
    app_ui_data->mahjong_labels_vbox );

  /* Board label */
  app_ui_data->mahjong_board_label = gtk_label_new(
    _("game_fi_mahjong_settings_board") );
  g_assert(app_ui_data->mahjong_board_label);

  gtk_container_add( GTK_CONTAINER (app_ui_data->mahjong_labels_vbox),
    app_ui_data->mahjong_board_label );

  /* Sound effects label */
  app_ui_data->mahjong_sound_label = gtk_label_new(
    _("game_fi_mahjong_settings_sound") );
  g_assert(app_ui_data->mahjong_sound_label);

  gtk_container_add( GTK_CONTAINER (app_ui_data->mahjong_labels_vbox),
    app_ui_data->mahjong_sound_label );


  /* Create a vbox for selections */
  app_ui_data->mahjong_selections_vbox = gtk_vbox_new( FALSE, 0 );
  g_assert(app_ui_data->mahjong_selections_vbox);

  gtk_container_add( GTK_CONTAINER (app_ui_data->game_hbox ),
    app_ui_data->mahjong_selections_vbox );

  /* Board selection */
  app_ui_data->mahjong_board_choice = gtk_combo_box_new_text();
  g_assert(app_ui_data->mahjong_board_choice);

  gtk_combo_box_append_text( GTK_COMBO_BOX( app_ui_data->mahjong_board_choice ),
    _("game_va_mahjong_settings_board_1"));
  gtk_combo_box_append_text( GTK_COMBO_BOX( app_ui_data->mahjong_board_choice ),
    _("game_va_mahjong_settings_board_2"));
  gtk_combo_box_append_text( GTK_COMBO_BOX( app_ui_data->mahjong_board_choice ),
    _("game_va_mahjong_settings_board_3"));
  gtk_combo_box_append_text( GTK_COMBO_BOX( app_ui_data->mahjong_board_choice ),
    _("game_va_mahjong_settings_board_4"));
  gtk_combo_box_append_text( GTK_COMBO_BOX( app_ui_data->mahjong_board_choice ),
    _("game_va_mahjong_settings_board_5"));
  gtk_combo_box_append_text( GTK_COMBO_BOX( app_ui_data->mahjong_board_choice ),
    _("game_va_mahjong_settings_board_6"));
  gtk_combo_box_append_text( GTK_COMBO_BOX( app_ui_data->mahjong_board_choice ),
    _("game_va_mahjong_settings_board_7"));
  gtk_combo_box_append_text( GTK_COMBO_BOX( app_ui_data->mahjong_board_choice ),
    _("game_va_mahjong_settings_board_8"));
  gtk_combo_box_set_active( GTK_COMBO_BOX( app_ui_data->mahjong_board_choice ), 0);

  gtk_widget_set_size_request(app_ui_data->mahjong_board_choice,
    COMBOBOX_WIDTH, COMBOBOX_HEIGHT);
  gtk_container_add( GTK_CONTAINER (app_ui_data->mahjong_selections_vbox),
    app_ui_data->mahjong_board_choice );
  g_signal_connect(G_OBJECT(app_ui_data->mahjong_board_choice), "changed",
    G_CALLBACK(mahjong_board_cb),(gpointer)app_ui_data);

  /* Sound effects */
  app_ui_data->mahjong_sound_check = gtk_check_button_new();
  g_assert(app_ui_data->mahjong_sound_check);

  gtk_widget_set_size_request(app_ui_data->mahjong_sound_check,
    LABEL_WIDTH, LABEL_HEIGHT);
  gtk_container_add( GTK_CONTAINER (app_ui_data->mahjong_selections_vbox ),
    app_ui_data->mahjong_sound_check );
  g_signal_connect(G_OBJECT(app_ui_data->mahjong_sound_check), "clicked",
    G_CALLBACK(game_sound_cb),(gpointer)app_ui_data);

  /* Create a dummy vbox, to increase space between 
  game specific settings and high scores button */
  GtkWidget *mahjong_dummy_vbox;
  mahjong_dummy_vbox = gtk_vbox_new( FALSE, 0 );
  if (mahjong_dummy_vbox != NULL)
    gtk_container_add( GTK_CONTAINER (app_ui_data->game_hbox ),
      mahjong_dummy_vbox );

  /* Create a vbox for high scores */
  app_ui_data->mahjong_high_scores_vbox = gtk_vbox_new( FALSE, 0 );
  g_assert(app_ui_data->mahjong_high_scores_vbox);

  gtk_container_add( GTK_CONTAINER (app_ui_data->game_hbox ),
    app_ui_data->mahjong_high_scores_vbox );
  
  /* Create a dummy label, to restrict span high scores button */
  GtkWidget *mahjong_dummy_label;
  mahjong_dummy_label = gtk_label_new("");
  if (mahjong_dummy_label != NULL)
    gtk_container_add( GTK_CONTAINER (app_ui_data->mahjong_high_scores_vbox ),
      mahjong_dummy_label );
  
  /* High scores button */
  app_ui_data->mahjong_scores_button = gtk_button_new_with_label(
    _("game_bu_mahjong_settings_high_scores") );
  g_assert(app_ui_data->mahjong_scores_button);
  
  g_signal_connect(G_OBJECT(app_ui_data->mahjong_scores_button),"clicked",
    G_CALLBACK(mahjongg_scores_cb),(gpointer)app_ui_data);

  gtk_container_add( GTK_CONTAINER (app_ui_data->mahjong_high_scores_vbox),
    app_ui_data->mahjong_scores_button );

  /*  
  gtk_box_pack_start( GTK_BOX(app_ui_data->game_hbox),
    app_ui_data->mahjong_scores_button, FALSE, FALSE, 0);
  */

  gchar *temp = settings_get_string(SETTINGS_MAHJONG_HIGH_SCORES);
  if (!temp)
  {
    gchar *path = g_build_filename(g_get_home_dir(),
        SETTINGS_MAHJONG_HIGH_SCORE_DEFAULT, NULL);
    settings_set_string(SETTINGS_MAHJONG_HIGH_SCORES, path);
    g_free(path);
  }
  else
    g_free(temp);

  return result;
}

HildonAppView *ui_create_lmarbles_view( AppUIData *app_ui_data )
{
  HildonAppView *result;

  result = HILDON_APPVIEW( hildon_appview_new( "lmarbles_view" ) );

  g_assert(result);
  app_ui_data->main_view = result;

  /* Connect destroy signal */
  g_signal_connect( G_OBJECT( result ), "destroy",
    G_CALLBACK( game_quit_cb ), (gpointer)app_ui_data);

  /* Make common view */
  ui_create_games_common_view(app_ui_data);

  /* Game title graph */
  gtk_image_set_from_file( GTK_IMAGE( app_ui_data->game_image ),
    PIXMAPSDIR"/osso-games-startup-lmarbles.png");

  /* Chess specific settings */

  /* Create a hbox for game specific settings */
  app_ui_data->game_hbox = gtk_hbox_new( FALSE, 0 );
  g_assert(app_ui_data->game_hbox);

  gtk_container_add( GTK_CONTAINER (app_ui_data->main_vbox),
    app_ui_data->game_hbox );

  /* Difficulty label */
  app_ui_data->lmarbles_difficulty_label = gtk_label_new(
    _("game_fi_lmarbles_settings_difficulty") );
  g_assert(app_ui_data->lmarbles_difficulty_label);

  gtk_widget_set_size_request(app_ui_data->lmarbles_difficulty_label,
    LABEL_WIDTH, LABEL_HEIGHT);
  gtk_container_add( GTK_CONTAINER (app_ui_data->game_hbox),
    app_ui_data->lmarbles_difficulty_label );

  /* Difficulty selection */
  app_ui_data->lmarbles_difficulty_choice = gtk_combo_box_new_text();
  g_assert(app_ui_data->lmarbles_difficulty_choice);

  gtk_combo_box_append_text(
    GTK_COMBO_BOX( app_ui_data->lmarbles_difficulty_choice ),
    _("game_va_lmarbles_settings_difficulty_1"));
  gtk_combo_box_append_text(
    GTK_COMBO_BOX( app_ui_data->lmarbles_difficulty_choice ),
    _("game_va_lmarbles_settings_difficulty_2"));
  gtk_combo_box_append_text(
    GTK_COMBO_BOX( app_ui_data->lmarbles_difficulty_choice ),
    _("game_va_lmarbles_settings_difficulty_3"));
  gtk_combo_box_append_text(
    GTK_COMBO_BOX( app_ui_data->lmarbles_difficulty_choice ),
    _("game_va_lmarbles_settings_difficulty_4"));
  gtk_combo_box_set_active(
    GTK_COMBO_BOX( app_ui_data->lmarbles_difficulty_choice ), 0);

  gtk_widget_set_size_request(app_ui_data->lmarbles_difficulty_choice,
    COMBOBOX_WIDTH, COMBOBOX_HEIGHT);
  gtk_container_add( GTK_CONTAINER (app_ui_data->game_hbox),
    app_ui_data->lmarbles_difficulty_choice );
  g_signal_connect(G_OBJECT(app_ui_data->lmarbles_difficulty_choice), "changed",
    G_CALLBACK(lmarbles_difficulty_cb),(gpointer)app_ui_data);


  /* Sound effects label */
  app_ui_data->lmarbles_sound_label = gtk_label_new(
    _("game_fi_lmarbles_settings_sound") );
  g_assert(app_ui_data->lmarbles_sound_label);

  gtk_widget_set_size_request(app_ui_data->lmarbles_sound_label,
    LABEL_WIDTH, LABEL_HEIGHT);
  gtk_container_add( GTK_CONTAINER (app_ui_data->game_hbox),
    app_ui_data->lmarbles_sound_label );

  /* Sound effects */
  app_ui_data->lmarbles_sound_check = gtk_check_button_new();
  g_assert(app_ui_data->lmarbles_sound_check);

  g_signal_connect(G_OBJECT(app_ui_data->lmarbles_sound_check), "clicked",
    G_CALLBACK(game_sound_cb),(gpointer)app_ui_data);
  gtk_container_add( GTK_CONTAINER (app_ui_data->game_hbox ),
    app_ui_data->lmarbles_sound_check );

  return result;
}

void ui_repaint( AppData *app_data )
{
  osso_log (LOG_DEBUG, "%s\n", __FUNCTION__);
  ui_update_status( app_data->app_ui_data );
}

/* Create the menu and attach it to main_view of given appdata */
void ui_create_menu( AppUIData *app_ui_data )
{
  /* 
     These are always defined out, but are here to keep potfile updates
     working, when using "intltool-update" script.
  */
  #if 0
  _("game_me_main_menu_close");

  _("game_me_chess_main_menu_game");
  _("game_me_chess_main_menu_settings");
  _("game_me_chess_main_menu_recent");
  _("game_me_chess_main_menu_help");
  _("game_me_chess_main_menu_close");

  _("game_me_chess_menu_game_play");
  _("game_me_chess_menu_game_restart");
  _("game_me_chess_menu_game_open");
  _("game_me_chess_menu_game_save");
  _("game_me_chess_menu_game_save_as");

  _("game_me_chess_menu_settings_human");
  _("game_me_chess_menu_settings_human_white");
  _("game_me_chess_menu_settings_human_black");
  _("game_me_chess_menu_settings_opponent");
  _("game_me_chess_menu_settings_opponent_1");
  _("game_me_chess_menu_settings_opponent_2");
  _("game_me_chess_menu_settings_opponent_3");
  _("game_me_chess_menu_settings_opponent_4");
  _("game_me_chess_menu_settings_opponent_human");

  _("game_me_chess_menu_settings_sound");
  _("game_me_chess_menu_settings_legal_moves");

  _("game_me_mahjong_main_menu_game");
  _("game_me_mahjong_main_menu_board");
  _("game_me_mahjong_main_menu_settings");
  _("game_me_mahjong_main_menu_tools");
  _("game_me_mahjong_main_menu_close");

  _("game_me_mahjong_menu_game_play");
  _("game_me_mahjong_menu_game_restart");

  _("game_me_mahjong_menu_board_1");
  _("game_me_mahjong_menu_board_2");
  _("game_me_mahjong_menu_board_3");
  _("game_me_mahjong_menu_board_4");
  _("game_me_mahjong_menu_board_5");
  _("game_me_mahjong_menu_board_6");
  _("game_me_mahjong_menu_board_7");
  _("game_me_mahjong_menu_board_8");

  _("game_me_mahjong_menu_settings_sound");
  _("game_me_mahjong_menu_tools_high_scores");
  _("game_me_mahjong_menu_tools_help");

  _("game_me_lmarbles_main_menu_game");
  _("game_me_lmarbles_main_menu_settings");
  _("game_me_lmarbles_main_menu_help");
  _("game_me_lmarbles_main_menu_close");

  _("game_me_lmarbles_menu_game_play");
  _("game_me_lmarbles_menu_game_restart");

  _("game_me_lmarbles_menu_settings_easy");
  _("game_me_lmarbles_menu_settings_normal");
  _("game_me_lmarbles_menu_settings_hard");
  _("game_me_lmarbles_menu_settings_brainstorm");
  _("game_me_lmarbles_menu_settings_sound");
  _("game_me_lmarbles_menu_settings_reset");
  _("game_me_lmarbles_menu_settings_reset_progress");
  
  #endif

  /*
    Menu description for Item Factory.

    NB: When using radio buttons which are in group, the path to first
    radio button for creating the group must be written as item type
    WITHOUT underscores. This is due underscore defines accelerator
    keys for menuitems and they are omitted from the operational string.
    These are switched off later with localization, but ItemFactory doesn't
    have an option for this. --JK
  */


  static GtkItemFactoryEntry chess_menu_items[] = {
    { "/game_me_chess_main_menu_game", NULL, NULL, 0, "<Branch>" },

    /* Game menu */
    { "/game_me_chess_main_menu_game/game_me_chess_menu_game_play",
      NULL, menu_action, MA_GAME_PLAY,  "<Item>" },

    { "/game_me_chess_main_menu_game/game_me_chess_menu_game_restart",
      NULL, menu_action, MA_GAME_RESTART,  "<Item>" },

    { "/game_me_chess_main_menu_game/sep", NULL, NULL, 0, "<Separator>" },

    { "/game_me_chess_main_menu_game/game_me_chess_menu_game_open",
      NULL, menu_action, MA_GAME_OPEN,  "<Item>" },

    { "/game_me_chess_main_menu_game/game_me_chess_menu_game_save",
      NULL, menu_action, MA_GAME_SAVE,  "<Item>" },

    { "/game_me_chess_main_menu_game/game_me_chess_menu_game_save_as",
      NULL, menu_action, MA_GAME_SAVE_AS,  "<Item>" },

    /* Settings menu */
    { "/game_me_chess_main_menu_settings", NULL, NULL, 0, "<Branch>" },

    /* Human selection */
    { "/game_me_chess_main_menu_settings"
      "/game_me_chess_menu_settings_human",
      NULL, NULL, 0, "<Branch>" },

    { "/game_me_chess_main_menu_settings"
      "/game_me_chess_menu_settings_human"
      "/game_me_chess_menu_settings_human_white", NULL,
      menu_radio, MR_GAME_HUMAN_WHITE,  "<RadioItem>" },

    { "/game_me_chess_main_menu_settings"
      "/game_me_chess_menu_settings_human"
      "/game_me_chess_menu_settings_human_black", NULL,
      menu_radio, MR_GAME_HUMAN_BLACK, 
      "/gamemechessmainmenusettings"
      "/gamemechessmenusettingshuman"
      "/gamemechessmenusettingshumanwhite" },

    /* Separator */
    { "/game_me_chess_main_menu_settings/sep", NULL, NULL, 0, "<Separator>" },
    
    /* Opponent selection */
    { "/game_me_chess_main_menu_settings"
      "/game_me_chess_menu_settings_opponent",
      NULL, NULL, 0, "<Branch>" },

    { "/game_me_chess_main_menu_settings"
      "/game_me_chess_menu_settings_opponent"
      "/game_me_chess_menu_settings_opponent_1", NULL,
      menu_radio, MR_GAME_OPPONENT_1,
      "<RadioItem>" },

    { "/game_me_chess_main_menu_settings"
      "/game_me_chess_menu_settings_opponent"
      "/game_me_chess_menu_settings_opponent_2", NULL,
      menu_radio, MR_GAME_OPPONENT_2,
      "/gamemechessmainmenusettings"
      "/gamemechessmenusettingsopponent"
      "/gamemechessmenusettingsopponent1" },

    { "/game_me_chess_main_menu_settings"
      "/game_me_chess_menu_settings_opponent"
      "/game_me_chess_menu_settings_opponent_3", NULL,
      menu_radio, MR_GAME_OPPONENT_3,
      "/gamemechessmainmenusettings"
      "/gamemechessmenusettingsopponent"
      "/gamemechessmenusettingsopponent1" },

    { "/game_me_chess_main_menu_settings"
      "/game_me_chess_menu_settings_opponent"
      "/game_me_chess_menu_settings_opponent_4", NULL,
      menu_radio, MR_GAME_OPPONENT_4,
      "/gamemechessmainmenusettings"
      "/gamemechessmenusettingsopponent"
      "/gamemechessmenusettingsopponent1" },

    { "/game_me_chess_main_menu_settings"
      "/game_me_chess_menu_settings_opponent"
      "/sep", NULL, NULL, 0,  "<Separator>" },

    { "/game_me_chess_main_menu_settings"
      "/game_me_chess_menu_settings_opponent"
      "/game_me_chess_menu_settings_opponent_human", NULL,
      menu_radio, MR_GAME_OPPONENT_HUMAN,
      "/gamemechessmainmenusettings"
      "/gamemechessmenusettingsopponent"
      "/gamemechessmenusettingsopponent1" },

    /* Sound settings */
    { "/game_me_chess_main_menu_settings"
      "/game_me_chess_menu_settings_sound", NULL,
      menu_toggle, MT_GAME_SOUND,  "<CheckItem>" },

    /* Legal moves settings */
    { "/game_me_chess_main_menu_settings"
      "/game_me_chess_menu_settings_legal_moves", NULL,
      menu_toggle, MT_GAME_LEGAL_MOVES,  "<CheckItem>" },

    /* Recent games */
    { "/game_me_chess_main_menu_recent", NULL, NULL, 0, "<Branch>" },
    { "/game_me_chess_main_menu_recent/game_me_chess_menu_recent_1", NULL,
      menu_action, MA_GAME_RECENT_1,  "<Item>" },
    { "/game_me_chess_main_menu_recent/game_me_chess_menu_recent_2", NULL,
      menu_action, MA_GAME_RECENT_2,  "<Item>" },
    { "/game_me_chess_main_menu_recent/game_me_chess_menu_recent_3", NULL,
      menu_action, MA_GAME_RECENT_3,  "<Item>" },
    { "/game_me_chess_main_menu_recent/game_me_chess_menu_recent_4", NULL,
      menu_action, MA_GAME_RECENT_4,  "<Item>" },
    { "/game_me_chess_main_menu_recent/game_me_chess_menu_recent_5", NULL,
      menu_action, MA_GAME_RECENT_5,  "<Item>" },
    { "/game_me_chess_main_menu_recent/game_me_chess_menu_recent_6", NULL,
      menu_action, MA_GAME_RECENT_6,  "<Item>" },

    { "/game_me_chess_main_menu_help",
      NULL, menu_action, MA_GAME_HELP,  "<Item>" },

    /* Close game */
    { "/game_me_chess_main_menu_close", NULL, menu_action,
      MA_GAME_CLOSE, "<Item>" }
  };

  static GtkItemFactoryEntry mahjong_menu_items[] = {
    { "/game_me_mahjong_main_menu_game", NULL, NULL, 0, "<Branch>" },

    /* Game menu */
    { "/game_me_mahjong_main_menu_game/game_me_mahjong_menu_game_play",
      NULL, menu_action, MA_GAME_PLAY,  "<Item>" },

    { "/game_me_mahjong_main_menu_game/game_me_mahjong_menu_game_restart",
      NULL, menu_action, MA_GAME_RESTART,  "<Item>" },

    /* Board menu */
    { "/game_me_mahjong_main_menu_board",
      NULL, NULL, 0, "<Branch>" },

    /* Board selection */
    { "/game_me_mahjong_main_menu_board"
      "/game_me_mahjong_menu_board_1", NULL,
      menu_radio, MR_GAME_BOARD_1,  "<RadioItem>" },

    { "/game_me_mahjong_main_menu_board"
      "/game_me_mahjong_menu_board_2", NULL,
      menu_radio, MR_GAME_BOARD_2,
      "/gamememahjongmainmenuboard"
      "/gamememahjongmenuboard1" },

    { "/game_me_mahjong_main_menu_board"
      "/game_me_mahjong_menu_board_3", NULL,
      menu_radio, MR_GAME_BOARD_3,
      "/gamememahjongmainmenuboard"
      "/gamememahjongmenuboard1" },

    { "/game_me_mahjong_main_menu_board"
      "/game_me_mahjong_menu_board_4", NULL,
      menu_radio, MR_GAME_BOARD_4,
      "/gamememahjongmainmenuboard"
      "/gamememahjongmenuboard1" },

    { "/game_me_mahjong_main_menu_board"
      "/game_me_mahjong_menu_board_5", NULL,
      menu_radio, MR_GAME_BOARD_5,
      "/gamememahjongmainmenuboard"
      "/gamememahjongmenuboard1" },

    { "/game_me_mahjong_main_menu_board"
      "/game_me_mahjong_menu_board_6", NULL,
      menu_radio, MR_GAME_BOARD_6,
      "/gamememahjongmainmenuboard"
      "/gamememahjongmenuboard1" },

    { "/game_me_mahjong_main_menu_board"
      "/game_me_mahjong_menu_board_7", NULL,
      menu_radio, MR_GAME_BOARD_7,
      "/gamememahjongmainmenuboard"
      "/gamememahjongmenuboard1" },

    { "/game_me_mahjong_main_menu_board"
      "/game_me_mahjong_menu_board_8", NULL,
      menu_radio, MR_GAME_BOARD_8,
      "/gamememahjongmainmenuboard"
      "/gamememahjongmenuboard1" },

    /* Settings menu */
    { "/game_me_mahjong_main_menu_settings", NULL, NULL, 0, "<Branch>" },

    /* Sound setting */
    { "/game_me_mahjong_main_menu_settings"
      "/game_me_mahjong_menu_settings_sound", NULL,
      menu_toggle, MT_GAME_SOUND,  "<CheckItem>" },

    /* Tools menu */
    { "/game_me_mahjong_main_menu_tools", NULL, NULL, 0, "<Branch>" },

    /* High scores */
    { "/game_me_mahjong_main_menu_tools"
      "/game_me_mahjong_menu_tools_high_scores", NULL,
      menu_action, MA_GAME_HIGH_SCORES,  "<Item>" },

    /* Help */
    { "/game_me_mahjong_main_menu_tools"
      "/game_me_mahjong_menu_tools_help", NULL,
      menu_action, MA_GAME_HELP,  "<Item>" },

    /* Close game */
    { "/game_me_mahjong_main_menu_close", NULL, menu_action,
      MA_GAME_CLOSE, "<Item>" }
  };

  static GtkItemFactoryEntry lmarbles_menu_items[] = {
    { "/game_me_lmarbles_main_menu_game", NULL, NULL, 0, "<Branch>" },

    /* Game menu */
    { "/game_me_lmarbles_main_menu_game/game_me_lmarbles_menu_game_play",
      NULL, menu_action, MA_GAME_PLAY,  "<Item>" },

    { "/game_me_lmarbles_main_menu_game/game_me_lmarbles_menu_game_restart",
      NULL, menu_action, MA_GAME_RESTART,  "<Item>" },

    /* Settings menu */
    { "/game_me_lmarbles_main_menu_settings", NULL, NULL, 0, "<Branch>" },

    /* Level selection */
    { "/game_me_lmarbles_main_menu_settings"
      "/game_me_lmarbles_menu_settings_easy", NULL,
      menu_radio, MR_GAME_LMARBLES_EASY,  "<RadioItem>" },

    { "/game_me_lmarbles_main_menu_settings"
      "/game_me_lmarbles_menu_settings_normal", NULL,
      menu_radio, MR_GAME_LMARBLES_NORMAL,
      "/gamemelmarblesmainmenusettings"
      "/gamemelmarblesmenusettingseasy" },

    { "/game_me_lmarbles_main_menu_settings"
      "/game_me_lmarbles_menu_settings_hard", NULL,
      menu_radio, MR_GAME_LMARBLES_HARD,
      "/gamemelmarblesmainmenusettings"
      "/gamemelmarblesmenusettingseasy" },

    { "/game_me_lmarbles_main_menu_settings"
      "/game_me_lmarbles_menu_settings_brainstorm", NULL,
      menu_radio, MR_GAME_LMARBLES_BRAINSTORM,
      "/gamemelmarblesmainmenusettings"
      "/gamemelmarblesmenusettingseasy" },

    /* Separator */
    { "/game_me_lmarbles_main_menu_settings/sep",
      NULL, NULL, 0, "<Separator>" },

    /* Sound setting */
    { "/game_me_lmarbles_main_menu_settings"
      "/game_me_lmarbles_menu_settings_sound", NULL,
      menu_toggle, MT_GAME_SOUND,  "<CheckItem>" },

    /* Separator */
    { "/game_me_lmarbles_main_menu_settings/sep",
      NULL, NULL, 0, "<Separator>" },

    /* Reset menu */
    { "/game_me_lmarbles_main_menu_settings"
      "/game_me_lmarbles_menu_settings_reset",
      NULL, NULL, 0, "<Branch>" },

    /* Reset progress setting */
    { "/game_me_lmarbles_main_menu_settings"
      "/game_me_lmarbles_menu_settings_reset"
      "/game_me_lmarbles_menu_settings_reset_progress", NULL,
      menu_action, MA_GAME_RESET,  "<CheckItem>" },

    /* Help */
    { "/game_me_lmarbles_main_menu_help", NULL,
      menu_action, MA_GAME_HELP,  "<Item>" },

    /* Close game */
    { "/game_me_lmarbles_main_menu_close", NULL, menu_action,
      MA_GAME_CLOSE, "<Item>" }
  };

  /* Conditional creation, by game type. */
  static gint chess_nmenu_items=sizeof( chess_menu_items )
    / sizeof( chess_menu_items[0] );
  static gint mahjong_nmenu_items=sizeof( mahjong_menu_items )
    / sizeof( mahjong_menu_items[0] );
  static gint lmarbles_nmenu_items=sizeof( lmarbles_menu_items )
    / sizeof( lmarbles_menu_items[0] );

  gchar *path = NULL;

  /* Paranoia */
  g_assert( app_ui_data );
  g_assert( app_ui_data->main_view );

  /*
    We use ItemFactory to produce the full menubar, then we reparent
    submenus to our AppView's menu. 
  */

  /* Prepare item factory */
  app_ui_data->chess_item_factory = gtk_item_factory_new (GTK_TYPE_MENU_BAR,
    "<main>", NULL );
  app_ui_data->mahjong_item_factory = gtk_item_factory_new (GTK_TYPE_MENU_BAR,
    "<main>", NULL );
  app_ui_data->lmarbles_item_factory = gtk_item_factory_new (GTK_TYPE_MENU_BAR,
    "<main>", NULL );

  /* Create item factories */
  gtk_item_factory_create_items (app_ui_data->chess_item_factory,
  chess_nmenu_items, chess_menu_items, app_ui_data);

  gtk_item_factory_create_items (app_ui_data->mahjong_item_factory,
  mahjong_nmenu_items, mahjong_menu_items, app_ui_data);

  gtk_item_factory_create_items (app_ui_data->lmarbles_item_factory,
  lmarbles_nmenu_items, lmarbles_menu_items, app_ui_data);

  /* Save the created menu bar to application data */
  path = "/gamemechessmainmenusettings"
         "/gamemechessmenusettingsopponent"
         "/gamemechessmenusettingsopponenthuman";
  ui_menu_item_set_active(app_ui_data,
  path,
  TRUE);

  return;
}

void ui_show_menu( AppUIData *app_ui_data )
{
  GtkWidget *factory_menu;

  GtkMenu *menu_bar;

  /* Paranoia */
  g_assert( app_ui_data );
  g_assert( app_ui_data->main_view );

  /* Get application view's menu bar */
  menu_bar = hildon_appview_get_menu( app_ui_data->main_view );

  /* Get the parent MenuBar from factory for reparenting */
  switch (get_game_type()) {
  case gt_chess:
    factory_menu = gtk_item_factory_get_widget(
      app_ui_data->chess_item_factory, "<main>" );
    app_ui_data->chess_recent_menu = gtk_item_factory_get_item(
      app_ui_data->chess_item_factory, "/gamemechessmainmenurecent");

    app_ui_data->game_restart_menu = gtk_item_factory_get_item(
      app_ui_data->chess_item_factory,
      "/gamemechessmainmenugame/gamemechessmenugamerestart");
    app_ui_data->game_save_menu = gtk_item_factory_get_item(
      app_ui_data->chess_item_factory,
      "/gamemechessmainmenugame/gamemechessmenugamesave");
    app_ui_data->game_saveas_menu = gtk_item_factory_get_item(
      app_ui_data->chess_item_factory,
      "/gamemechessmainmenugame/gamemechessmenugamesaveas");
    break;
  case gt_mahjong:
    factory_menu = gtk_item_factory_get_widget(
      app_ui_data->mahjong_item_factory, "<main>" );

    app_ui_data->game_restart_menu = gtk_item_factory_get_item(
      app_ui_data->mahjong_item_factory,
    "/gamememahjongmainmenugame/gamememahjongmenugamerestart");
    break;
  case gt_lmarbles:
    factory_menu = gtk_item_factory_get_widget(
      app_ui_data->lmarbles_item_factory, "<main>" );

    app_ui_data->game_restart_menu = gtk_item_factory_get_item(
      app_ui_data->lmarbles_item_factory,
    "/gamemelmarblesmainmenugame/gamemelmarblesmenugamerestart");
    break;
  default:
    factory_menu = gtk_item_factory_get_widget(
      app_ui_data->item_factory, "<main>" );
    break;
  }

  /* Reparent */
  gtk_container_foreach( GTK_CONTAINER
       (factory_menu),
       (GtkCallback)gtk_widget_reparent,
       menu_bar );

  /* Save the created menu bar to application data */
  app_ui_data->main_menu_bar=menu_bar;
}

GtkWidget *ui_menu_item_get( AppUIData *app_ui_data, gchar *path )
{
  GtkWidget *item = NULL;

  switch (get_game_type()) {
    case gt_chess:
    app_ui_data->item_factory = app_ui_data->chess_item_factory;
    break;

    case gt_mahjong:
    app_ui_data->item_factory = app_ui_data->mahjong_item_factory;
    break;

    case gt_lmarbles:
    app_ui_data->item_factory = app_ui_data->lmarbles_item_factory;
    break;

    default:
    case gt_none:
    break;
  }

  if ( app_ui_data->item_factory != NULL && path != NULL ) {

    item = gtk_item_factory_get_item ( 
      app_ui_data->item_factory, path );
  }

  return item;
}

/* Set menu item sensitivity */
void ui_menu_item_set_sensitive( AppUIData *app_ui_data, gchar *path,
  gboolean sensitive )
{
  if (path || *path)
    return;
  GtkWidget *item = ui_menu_item_get(app_ui_data, path);
  if ( item != NULL) {
    gtk_widget_set_sensitive( item, sensitive );
  }
}

/* Set menu item activity */
void ui_menu_item_set_active( AppUIData *app_ui_data, gchar *path,
  gboolean active )
{
  GtkWidget *item = ui_menu_item_get(app_ui_data, path);
  if ( item != NULL) {
    gtk_check_menu_item_set_active (
      GTK_CHECK_MENU_ITEM( item ), active );
  }
}

/* Get menu item activity */
gboolean ui_menu_item_get_active( AppUIData *app_ui_data, gchar *path)
{
  GtkWidget *item = ui_menu_item_get(app_ui_data, path);
  if ( item != NULL) {
    return gtk_check_menu_item_get_active (
      GTK_CHECK_MENU_ITEM( item ) );
  }
  return 0;
}

/* Menu localization */
void ui_localize_menu( GtkContainer *menu )
{
  /*
    Here we do some type checking, so iteration through the whole
    (menu)container will happen.
  */

  /* Recurse into menu */
  if ( GTK_IS_CONTAINER (menu) ) {
    gtk_container_foreach( menu, (GtkCallback)ui_localize_menu, NULL );
    /* g_object_set(G_OBJECT(menu), "vertical-padding", 10); */
  }

  if ( GTK_IS_MENU_ITEM (menu) ) {
    /* Descend to submenus if there is any */
    if ( gtk_menu_item_get_submenu( GTK_MENU_ITEM (menu) ) != NULL ) {
      gtk_container_foreach( GTK_CONTAINER
           ( gtk_menu_item_get_submenu( GTK_MENU_ITEM
                (menu) ) ),
           (GtkCallback)ui_localize_menu, NULL );
    }
    /* Finally, translate the label's text */
    if ( GTK_IS_LABEL ( GTK_BIN (menu)->child) ) {
      /*
        Don't parse underline characters in widget labels, there is no
        keyboard in the device
      */
      gtk_label_set_use_underline( GTK_LABEL( GTK_BIN (menu)->child),
           FALSE );

      gtk_label_set_text( GTK_LABEL (GTK_BIN (menu)->child),
        _(gtk_label_get_text( GTK_LABEL 
            (GTK_BIN (menu)->child) ) ) );
    }
  }

  return;
}

/*
gboolean check_dir(gchar *filename)
{   
  if (filename==NULL) return FALSE;
  gchar *dirn = g_strdup(filename);
  if (dirn==NULL) return FALSE;

  if (chdir(dirn)<0) {
    gchar *pos = g_strrstr(dirn,"/");
    if (pos!=NULL) {
       *pos=0;
       check_dir(dirn);
       *pos='/';
    } else {
     return TRUE;
    }
    if (mkdir(dirn,0755)<0) {
      g_free(dirn);
      return FALSE; 
    }

  }   
  
  g_free(dirn);
  return TRUE;
}
*/

gboolean ui_show_file_chooser( gboolean open, AppUIData *app_ui_data )
{
  GtkWidget *fs = NULL;
  GtkFileFilter *ff = NULL;
  
  if (app_ui_data == NULL) return FALSE;
  g_assert(app_ui_data);

  /* Get & set default folder */
  if (!app_ui_data->chess_save_folder || !*app_ui_data->chess_save_folder)
  {
    if (app_ui_data->chess_save_folder)
      g_free(app_ui_data->chess_save_folder);
      app_ui_data->chess_save_folder = g_build_filename(getenv("MYDOCSDIR"),
        SETTINGS_CHESS_SAVE_FOLDER_DEFAULT, NULL);
  }
  /*
  if (!check_dir(app_ui_data->chess_save_folder))
    return FALSE;
  */

  /* Make dialog */
  fs = hildon_file_chooser_dialog_new(
    GTK_WINDOW (app_ui_data->app),
    open?
    GTK_FILE_CHOOSER_ACTION_OPEN:
    GTK_FILE_CHOOSER_ACTION_SAVE
    );

  ossohelp_dialog_help_enable(
            GTK_DIALOG(fs),
            open ? OSSO_CHESS_HELP_LOADFILE : OSSO_CHESS_HELP_SAVEFILE,
            get_app_data()->app_osso_data->osso);
  

  if (open)
    g_object_set(G_OBJECT(fs),
      "empty-text",
      _("sfil_va_select_object_no_objects_games"),
      NULL
      );

  if (fs == NULL) return FALSE;
  g_assert(fs);

  gtk_file_chooser_set_current_folder (GTK_FILE_CHOOSER (fs),
      app_ui_data->chess_save_folder);

  if (!open) {
    gchar *buf;
    buf = g_strdup_printf("%s.game", _("sfil_va_save_object_name_stub_chess"));
    gtk_file_chooser_set_current_name (GTK_FILE_CHOOSER (fs), buf);
    g_free(buf);
  }

  /* Set dialog title */
  if (open) {
    gtk_window_set_title (GTK_WINDOW (fs), _("game_ti_load_game_title"));
  } else {
    gtk_window_set_title (GTK_WINDOW (fs), _("game_ti_save_game_title"));
  }

  /* Set file filter */
  if (open) {
    ff = gtk_file_filter_new();
//    gtk_file_filter_add_mime_type(ff, CHESS_MIME_TYPE);
    gtk_file_filter_add_pattern(ff, CHESS_FILE_GLOB);
    gtk_file_chooser_add_filter(GTK_FILE_CHOOSER(fs), ff);
    gtk_file_chooser_set_filter(GTK_FILE_CHOOSER(fs), ff);
  }

  /* Run the dialog, and expect OK. Otherwise just destroy the dialog. */
  if (gtk_dialog_run (GTK_DIALOG (fs)) == GTK_RESPONSE_OK) {
    gchar *filename = NULL;
    gchar *pathname = NULL;

    gtk_widget_hide (fs);

    filename = gtk_file_chooser_get_uri(
      GTK_FILE_CHOOSER (fs));

    if (filename == NULL)
    {
      return FALSE;
    }

    if (!open)
    {
      GnomeVFSURI *test_uri = gnome_vfs_uri_new(filename);
      
      if (gnome_vfs_uri_exists(test_uri)) {
        if (ui_show_replace_file_dialog(app_ui_data, filename) == GAME_RESPONSE_CANCEL)
        {
          gnome_vfs_uri_unref(test_uri);
          g_free(filename);
          gtk_widget_destroy (fs);

          return FALSE;
        }
      }
      gnome_vfs_uri_unref(test_uri);
    }

    pathname = gtk_file_chooser_get_current_folder(
      GTK_FILE_CHOOSER (fs));
    if (pathname != NULL)
    {
      g_free(app_ui_data->chess_save_folder);
      app_ui_data->chess_save_folder = pathname;
    }

    /* Set filename */
    if ( ! settings_set_string(SETTINGS_CHESS_SAVE_FILE, filename) ) {

      /* Free */
      g_free(filename);
      gtk_widget_destroy (fs);
      return FALSE;
    }
    osso_log(LOG_DEBUG,"Opening %s\n",filename);
    
    add_recent_item(app_ui_data, filename);

    /* Free */
    g_free(filename);
    gtk_widget_destroy (fs);

    return TRUE;
  }

  gtk_widget_destroy (fs);

  return FALSE;
}

void ui_show_highscore( AppUIData *app_ui_data )
{
  GtkDialog *dialog;
  GtkTreeView *tree;
  GtkTreeViewColumn *level_col,*time_col,*date_col;
  GtkCellRenderer *renderer;

  /* Creating the dialog */
  dialog = GTK_DIALOG( gtk_dialog_new_with_buttons(
    _("game_ti_mahjong_high_scores_title"),
    GTK_WINDOW (app_ui_data->app),
    GTK_DIALOG_MODAL | GTK_DIALOG_DESTROY_WITH_PARENT,
    /*GTK_STOCK_CLOSE,*/
    _("game_bd_mahjong_high_scores_close"),
    GTK_RESPONSE_ACCEPT,
    NULL
    ) );
  
  ossohelp_dialog_help_enable(
            GTK_DIALOG(dialog),
            OSSO_MAHJONG_HELP_BESTTIMES,
            get_app_data()->app_osso_data->osso);
  
  gtk_signal_connect(GTK_OBJECT(dialog),
    "response",
    G_CALLBACK(gtk_widget_destroy),
    GTK_WIDGET( dialog )
    );

  tree = (GtkTreeView *)gtk_tree_view_new_with_model(
    GTK_TREE_MODEL(app_ui_data->mahjong_tree_model) );

  g_assert(tree);

  /* Rendering level columnn */
  renderer = gtk_cell_renderer_text_new();
  g_assert(renderer);

  level_col = gtk_tree_view_column_new_with_attributes(
    _("game_ti_mahjong_high_scores_level"),
    renderer,
    "text", HIGHSCORE_LEVEL_COLUMN,
    NULL
    );

  /* Rendering time columnn */
  renderer = gtk_cell_renderer_text_new();
  g_assert(renderer);

  time_col = gtk_tree_view_column_new_with_attributes(
    _("game_ti_mahjong_high_scores_time"),
    renderer,
    "text", HIGHSCORE_TIME_COLUMN,
    NULL
    );

  /* Rendering date columnn */
  renderer = gtk_cell_renderer_text_new();
  g_assert(renderer);

  date_col = gtk_tree_view_column_new_with_attributes(
    _("game_ti_mahjong_high_scores_date"),
    renderer,
    "text", HIGHSCORE_DATE_COLUMN,
    NULL
    );

  gtk_tree_view_insert_column(tree, level_col, -1);
  gtk_tree_view_insert_column(tree, time_col, -1);
  gtk_tree_view_insert_column(tree, date_col, -1);

  gtk_tree_view_set_headers_visible(tree, TRUE);

  gtk_container_add( GTK_CONTAINER( dialog->vbox ),
    GTK_WIDGET(tree));

  gtk_widget_show_all(GTK_WIDGET(dialog));
}

/* Clean up */
void ui_clean_up( AppUIData *app_ui_data )
{
  /* Paranoia */
  g_assert( app_ui_data );

  /* There may be other cleanup operations */
  //gtk_widget_unref( GTK_WIDGET(app_ui_data->main_view) );

  return;
}

void add_recent_item(AppUIData *app_ui_data, gchar *file)
{
  // Bit of a hack to do this here, but valid place.
  gchar *full_path = gnome_vfs_format_uri_for_display(file);
  gchar *filename = basename(full_path);
  gchar *temp = g_strrstr(filename, ".");
  if (temp)
    *temp = '\0';
  hildon_appview_set_title(app_ui_data->main_view, filename);
  g_free(full_path);
  GSList *item = g_slist_find_custom(app_ui_data->chess_recent_items,
      file,
      (GCompareFunc)strcmp);
  if (item)
  {
    app_ui_data->chess_recent_items =
      g_slist_remove_link(app_ui_data->chess_recent_items, item);
    app_ui_data->chess_recent_items =
      g_slist_prepend(app_ui_data->chess_recent_items, item->data);
    g_slist_free_1(item);
  } else {
    app_ui_data->chess_recent_items =
      g_slist_prepend(app_ui_data->chess_recent_items, g_strdup(file));
    if (g_slist_length(app_ui_data->chess_recent_items) >
        SETTINGS_CHESS_MAX_RECENT_ITEMS) {
      GSList *end = g_slist_last(app_ui_data->chess_recent_items);
      g_free(end->data);
      app_ui_data->chess_recent_items =
        g_slist_delete_link(app_ui_data->chess_recent_items, end);
    }
  }
  settings_set_list_string(SETTINGS_CHESS_RECENT_ITEMS,
      app_ui_data->chess_recent_items);
}

void remove_recent_item(AppUIData *app_ui_data, gchar *file)
{
  GSList *item = g_slist_find_custom(app_ui_data->chess_recent_items,
      		file, (GCompareFunc)strcmp);
  if (item)
  {
    app_ui_data->chess_recent_items =
      g_slist_remove_link(app_ui_data->chess_recent_items, item);
    g_slist_free_1(item);
  }
  settings_set_list_string(SETTINGS_CHESS_RECENT_ITEMS,
      app_ui_data->chess_recent_items);
}

void ui_update_recent_items(AppUIData *app_ui_data)
{ 
  GList *recentmenu = gtk_container_get_children(
      GTK_CONTAINER(gtk_menu_item_get_submenu(
      GTK_MENU_ITEM(app_ui_data->chess_recent_menu))));
  GSList *recent = app_ui_data->chess_recent_items;

  GnomeVFSResult vfs_res;

  while (recent)
  {
    GnomeVFSFileInfo *file_info = gnome_vfs_file_info_new();
    gchar *path = (gchar *)recent->data;

    vfs_res = gnome_vfs_get_file_info(path,
        file_info,
        GNOME_VFS_FILE_INFO_FOLLOW_LINKS);
    if (vfs_res != GNOME_VFS_OK ||
        file_info->type != GNOME_VFS_FILE_TYPE_REGULAR)
    {
      GSList *temp = recent;
      recent = g_slist_next(recent);
      g_free(temp->data);
      app_ui_data->chess_recent_items = 
        g_slist_delete_link(app_ui_data->chess_recent_items, temp);
    }
    else
    {
      recent = g_slist_next(recent);
    }
    gnome_vfs_file_info_unref(file_info);
  }


  recent = app_ui_data->chess_recent_items;

  gtk_widget_set_sensitive(app_ui_data->chess_recent_menu,
      recent ? TRUE : FALSE);
  
  while (recent && recentmenu)
  {
    gchar *path = (gchar *)recent->data;
      
    GtkWidget *this = GTK_WIDGET(recentmenu->data);

    gchar *full_path = gnome_vfs_format_uri_for_display(path);
    gchar *file = basename(full_path);
    gchar *temp;
    if ((temp = g_strrstr(file, ".")))
      *temp = '\0';

    if (GTK_IS_LABEL(gtk_bin_get_child(GTK_BIN(this))))
    {
      GtkWidget *label = gtk_bin_get_child(GTK_BIN(this));
      gtk_label_set_text(GTK_LABEL(label), file);
      
      gtk_label_set_max_width_chars(GTK_LABEL(label), MENU_RECENT_MENU_WIDTH);
      gtk_label_set_ellipsize(GTK_LABEL(label), PANGO_ELLIPSIZE_END);

      gtk_widget_set_sensitive(label, TRUE);

      gtk_widget_show(this);
    }
    g_free(full_path);

    recent = g_slist_next(recent);
    recentmenu = g_list_next(recentmenu);
  }
  while (recentmenu)
  {
    GtkWidget *this = GTK_WIDGET(recentmenu->data);
    if (GTK_IS_LABEL(gtk_bin_get_child(GTK_BIN(this))))
    {
      GtkWidget *label = gtk_bin_get_child(GTK_BIN(this));

      gtk_widget_set_sensitive(label, FALSE);
      gtk_widget_hide(this);
    }
    recentmenu = g_list_next(recentmenu);
  }  
  
  /* For show infoprint if user selects dimmed command in menu */ 
  ui_set_dimmed_menu_item_callback(app_ui_data);
}

gint ui_show_save_before_closing_dialog(AppUIData *app_ui_data)
{
  gint answer = 0;
  gchar *file = settings_get_string(SETTINGS_CHESS_SAVE_FILE);
  gboolean freefile = FALSE;

  if (file==NULL || strlen(file)==0) {
    file = g_strdup_printf("%s.game", _("sfil_va_save_object_name_stub_chess"));
    settings_set_string(SETTINGS_CHESS_SAVE_FILE, file);
    freefile = TRUE;
  }

  if (file!=NULL) {
		gchar *tmp = g_strdup_printf( "%s", basename(file));

    HildonNote *note = HILDON_NOTE(hildon_note_new_confirmation_add_buttons(
        GTK_WINDOW(app_ui_data->app),
        tmp,
        _("sfil_nc_save_before_closing_yes"),
        GAME_RESPONSE_YES,
        _("sfil_nc_save_before_closing_no"),
        GAME_RESPONSE_NO,
        _("sfil_nc_save_before_closing_cancel"),
        GAME_RESPONSE_CANCEL,
        NULL));
    answer = gtk_dialog_run(GTK_DIALOG(note));
    gtk_widget_destroy(GTK_WIDGET(note));

    g_free(tmp);
    if (freefile) g_free(file);
  } else {
    answer = 0;
  }
  return answer;
}

gboolean ui_show_replace_file_dialog(AppUIData *app_ui_data, gchar *file)
{
  gboolean answer = FALSE;
  gchar *full_path = gnome_vfs_format_uri_for_display(file);
#ifndef VERSION_3
  gchar *tmp = g_strdup_printf( _("docm_nc_replace_file%s"), basename(full_path)); /*NOLOC*/
#else
  gchar *tmp = g_strdup_printf( _("docm_nc_replace_file%s"), basename(full_path)); /*NOLOC*/
#endif

  HildonNote *note = HILDON_NOTE(hildon_note_new_confirmation_add_buttons(
        GTK_WINDOW(app_ui_data->app),
        tmp,
        _("docm_bd_replace_file_ok"),
        GAME_RESPONSE_OK,
        _("docm_bd_replace_file_cancel"),
        GAME_RESPONSE_CANCEL,
        NULL));
  answer = gtk_dialog_run(GTK_DIALOG(note));
  gtk_widget_destroy(GTK_WIDGET(note));

  g_free(full_path);
  g_free(tmp);
  return answer;
}

gboolean ui_show_start_game_dialog(AppUIData *app_ui_data)
{
  gboolean answer = FALSE;
  HildonNote *note = HILDON_NOTE(hildon_note_new_confirmation_add_buttons(
        GTK_WINDOW(app_ui_data->app),
        _("game_nc_start_game"), /*NOLOC*/
        _("game_bd_start_game_ok"), /*NOLOC*/
        GAME_RESPONSE_OK,
        _("game_bd_start_game_cancel"), /*NOLOC*/
        GAME_RESPONSE_CANCEL,
        NULL));
  g_signal_connect(G_OBJECT(note), "key_press_event",
    G_CALLBACK(dialog_key_press), NULL);
  answer = gtk_dialog_run(GTK_DIALOG(note));
  gtk_widget_destroy(GTK_WIDGET(note));
  return answer;
}

gboolean ui_show_restart_game_dialog(AppUIData *app_ui_data)
{
  gboolean answer = FALSE;
  HildonNote *note = HILDON_NOTE(hildon_note_new_confirmation_add_buttons(
        GTK_WINDOW(app_ui_data->app),
        _("game_nc_restart_game"),
        _("game_bd_restart_game_ok"),
        GAME_RESPONSE_OK,
        _("game_bd_restart_game_cancel"),
        GAME_RESPONSE_CANCEL,
        NULL));
  g_signal_connect(G_OBJECT(note), "key_press_event",
    G_CALLBACK(dialog_key_press), NULL);

  answer = gtk_dialog_run(GTK_DIALOG(note));
  gtk_widget_destroy(GTK_WIDGET(note));
  return answer;
}

gboolean ui_set_saving_dialog_progress(AppUIData *app_ui_data, gfloat progress)
{
  if (app_ui_data->chess_saving_dialog==NULL) return FALSE;
  hildon_file_handling_note_set_fraction(
    HILDON_FILE_HANDLING_NOTE(app_ui_data->chess_saving_dialog),
    progress);
  return TRUE;
}

void ui_hide_saving_dialog(AppUIData *app_ui_data)
{
  if (app_ui_data->chess_saving_dialog==NULL) return;

  gtk_widget_hide(app_ui_data->chess_saving_dialog);
  gtk_widget_destroy(app_ui_data->chess_saving_dialog);
  app_ui_data->chess_saving_dialog = NULL;
}

void ui_show_saving_dialog(AppUIData *app_ui_data)
{
  /*
  gchar *tmp = g_strdup_printf(_("docm_nw_saving_file%s"), basename(file));*/ /*NOLOC*/
  

  app_ui_data->chess_saving_dialog = hildon_file_handling_note_new_saving(
                                     GTK_WINDOW(app_ui_data->app));
  /* 
  app_ui_data->chess_saving_dialog=hildon_file_handling_note_new_saving(
  				GTK_WINDOW(app_ui_data->main_view));
  */

  /*
  hildon_file_handling_note_set_name(
    HILDON_FILE_HANDLING_NOTE(app_ui_data->chess_saving_dialog),
    tmp
    );

  g_free(tmp);
  */


  g_signal_connect(G_OBJECT(app_ui_data->chess_saving_dialog), "response",
    G_CALLBACK(saving_dialog_cb), (gpointer)get_app_data());

  g_signal_connect(G_OBJECT(app_ui_data->chess_saving_dialog), "key_press_event",
    G_CALLBACK(key_press), (gpointer)get_app_data());

  gtk_widget_show_all(app_ui_data->chess_saving_dialog);
}

gboolean ui_show_reset_game_progress_dialog(AppUIData *app_ui_data)
{
  gboolean answer = FALSE;
  HildonNote *note = HILDON_NOTE(hildon_note_new_confirmation_add_buttons(
        GTK_WINDOW(app_ui_data->app),
        _("game_nc_reset_game_progress"),
        _("game_bd_reset_game_progress_ok"),
        GAME_RESPONSE_OK,
        _("game_bd_reset_game_progress_cancel"),
        GAME_RESPONSE_CANCEL,
        NULL));
  g_signal_connect(G_OBJECT(note), "key_press_event",
    G_CALLBACK(dialog_key_press), NULL);

  answer = gtk_dialog_run(GTK_DIALOG(note));
  gtk_widget_destroy(GTK_WIDGET(note));
  return answer;
}

void ui_set_dimmed_menu_item_callback(AppUIData *app_ui_data)
{
  if (!GTK_WIDGET_IS_SENSITIVE(app_ui_data->game_restart_menu))
	g_signal_connect(G_OBJECT(app_ui_data->game_restart_menu),
		 "insensitive_press",
		 G_CALLBACK(on_insensitive_menu_press),
		 _("game_ib_not_available"));
  if (get_game_type() == gt_indt) {
	  if (app_ui_data->plugin->menu_open_save)
	  {
	  /*g_signal_connect(G_OBJECT(app_ui_data->chess_recent_menu),
			 "insensitive_press",
			 G_CALLBACK(on_insensitive_menu_press),
			 _("game_ib_not_available"));*/
	
		g_signal_connect(G_OBJECT(app_ui_data->game_save_menu),
			 "insensitive_press",
			 G_CALLBACK(on_insensitive_menu_press),
			 _("game_ib_not_available"));
	
		g_signal_connect(G_OBJECT(app_ui_data->game_saveas_menu),
			 "insensitive_press",
			 G_CALLBACK(on_insensitive_menu_press),
			 _("game_ib_not_available"));
		  
}
}
  if (get_game_type() == gt_chess) {
	if (!GTK_WIDGET_IS_SENSITIVE(app_ui_data->chess_recent_menu))
		g_signal_connect(G_OBJECT(app_ui_data->chess_recent_menu),
			 "insensitive_press",
			 G_CALLBACK(on_insensitive_menu_press),
			 _("game_ib_not_available"));
	if (!GTK_WIDGET_IS_SENSITIVE(app_ui_data->game_save_menu))
		g_signal_connect(G_OBJECT(app_ui_data->game_save_menu),
			 "insensitive_press",
			 G_CALLBACK(on_insensitive_menu_press),
			 _("game_ib_not_available"));
	if (!GTK_WIDGET_IS_SENSITIVE(app_ui_data->game_saveas_menu))
		g_signal_connect(G_OBJECT(app_ui_data->game_saveas_menu),
			 "insensitive_press",
			 G_CALLBACK(on_insensitive_menu_press),
			 _("game_ib_not_available"));
  }
}


void ui_show_save_nomem_dialog(AppUIData *app_ui_data)
{
  HildonNote *note = HILDON_NOTE(hildon_note_new_information(
        GTK_WINDOW(app_ui_data->app),
        dgettext("hildon-common-strings","sfil_ni_not_enough_memory")
  	));
  hildon_note_set_button_text(note, dgettext("hildon-common-strings","sfil_ni_not_enough_memory_ok"));
   g_signal_connect(G_OBJECT(note), "key_press_event",
    G_CALLBACK(save_nomem_key_press), app_ui_data);
  g_signal_connect(G_OBJECT(note), "response",
    G_CALLBACK(save_nomem_response), app_ui_data);
 app_ui_data->nomem_dialog=note;
  //gtk_dialog_run(GTK_DIALOG(note));
  gtk_widget_show_all(GTK_WIDGET(note));
  //gtk_widget_destroy(GTK_WIDGET(note));

  hildon_appview_set_title(app_ui_data->main_view, "");
  settings_set_string(SETTINGS_CHESS_SAVE_FILE,"");
}


void ui_hide_save_nomem_dialog(AppUIData *app_ui_data)
{
  if (app_ui_data->nomem_dialog)
  gtk_widget_destroy(GTK_WIDGET(app_ui_data->nomem_dialog));
  app_ui_data->nomem_dialog=NULL;
}


void ui_show_save_nommc_dialog(AppUIData *app_ui_data)
{
  HildonNote *note = HILDON_NOTE(hildon_note_new_information(
        GTK_WINDOW(app_ui_data->app),
        _("ckct_ni_cannot_save_mmc_cover_open")
  	));
  hildon_note_set_button_text(note, _("ckct_bd_cannot_save_mmc_cover_open_ok"));
  gtk_dialog_run(GTK_DIALOG(note));
  gtk_widget_destroy(GTK_WIDGET(note));

  hildon_appview_set_title(app_ui_data->main_view, "");
  settings_set_string(SETTINGS_CHESS_SAVE_FILE,"");
}

void ui_cancel_saving(void) {
  AppData *app_data = get_app_data();
  
  app_data->app_ui_data->chess_save_done = GAME_SAVE_CANCEL;
  
  /* wait chess engine return result after saved */ 	  
  while (app_data->app_ui_data->chess_save_done == GAME_SAVE_CANCEL) {
    while(gtk_events_pending())
      gtk_main_iteration();
    usleep(10000);
  }
  ui_hide_saving_dialog(app_data->app_ui_data);  

  /* Was handled by game_save() */
  if (app_data->app_ui_data->chess_save_done==GAME_SAVE_NONE) {
    return;
  }
  
  ui_repaint(app_data);
  
  /* Delete un-wanted file if file is new */
  if (is_new_file) {
    gchar *filename = settings_get_string(SETTINGS_CHESS_SAVE_FILE);

    hildon_appview_set_title(app_data->app_ui_data->main_view, "");
    settings_set_string(SETTINGS_CHESS_SAVE_FILE,"");   	          
  
    if (filename) {
      gnome_vfs_unlink(filename);
      g_free(filename);
    }
  }
}

void ui_show_load_err(int err_type, AppUIData *app_ui_data, gchar *loadfile)
{ 
  remove_recent_item(app_ui_data, loadfile);
  ui_update_recent_items(app_ui_data); 

  switch (err_type) {
    case GAME_LOAD_FILE_UNSUPPORTED: 
    {
      gchar *filename = gnome_vfs_format_uri_for_display(loadfile);
      gchar *basename = g_path_get_basename(filename);
      gchar *temp = g_strrstr(basename, ".");
      if (temp) *temp = '\0';
      gchar *msg = g_strdup_printf(_("game_ni_unsupported_file%s"), basename);

      hildon_appview_set_title(app_ui_data->main_view, "");  
      show_infoprint(msg);
      
      g_free(msg);
      g_free(basename);
      g_free(filename);
      break;
    }
    case GAME_LOAD_FILE_NOT_FOUND:
    {
      HildonNote *note = HILDON_NOTE(hildon_note_new_information(
        GTK_WINDOW(app_ui_data->app), _("sfil_ni_unable_to_open_file_not_found") ));
      hildon_note_set_button_text(note, _("sfil_ni_unable_to_open_file_not_found_ok"));

      gtk_dialog_run(GTK_DIALOG(note));
      gtk_widget_destroy(GTK_WIDGET(note));
      break;
    }
  }
}
