/**
    @file state_save.h

    Functionality, definitions.

    Copyright (c) 2004, 2005 Nokia Corporation.
	
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
    02111-1307 USA
*/

#ifndef STATE_SAVE_H
#define STATE_SAVE_H

#include "appdata.h"

/**
 Saves the current application state with osso state saving methods.
 The saved variables as mentioned in technocal specification are:
 PreviousFolder the folder last used for saving / loading.
 GameType type of game currently running.
 GameState the state of the game.
 @param data Pointer to the AppData struct.
 @return 1 on success, 0 on failure.
 */
void save_state(gpointer data);

/**
 Reads the application state with osso state saving metods.
 @see save_state for read parameters.
 @param data Pointer to the AppData struct.
 @return 1 on success, 0 on failure.
 */
void read_state(gpointer app_data);

/**
 Clears the state file.

 @param data Pointer to the AppData struct.
*/
void clear_state(gpointer data);

#endif
