/**
    @file startup_highscore.h

    Function definitions for high scores.

    Copyright (c) 2004, 2005 Nokia Corporation.
	
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
    02111-1307 USA
*/

#ifndef STARTUP_HIGHSCORE_H
#define STARTUP_HIGHSCORE_H

#include <glib.h>
#include <libgnomevfs/gnome-vfs.h>

#include "settings.h"

#define HIGHSCORE_SIZE 10
#define HIGHSCORE_COLS 3

struct HighScore {
  gchar* level;
  gchar* time;
  gchar* date;
};

/**
 Read high score file.
 */
GString *highscore_read_file(void);

/**
 Load high scores.
 */
void highscore_load(struct HighScore *score);

/**
 Unload high scores.
 */
void highscore_unload(struct HighScore *score);

#endif

