
#include <glib-object.h>
#include <glib.h>

#include "scwtypes.h"

GType
scw_timestamp_get_type (void)
{
  static GType timestamp_type = 0;

  if (!timestamp_type)
    {
      static const GTypeInfo scw_timestamp_info =
      {
      	0,
      	NULL,		/* base_init */
      	NULL,		/* base_finalize */
      	NULL,
      	NULL,		/* class_finalize */
      	NULL,		/* class_data */
      	0,
      	0,		/* n_preallocs */
      	NULL,
      	NULL,		/* value_table */
      };

      timestamp_type = g_type_register_static (G_TYPE_INT, "ScwTimestamp",
					                                     &scw_timestamp_info, 0);
    }

  return timestamp_type;
}

GType
scw_presence_get_type (void)
{
  static GType presence_type = 0;

  if (!presence_type)
    {
      static const GTypeInfo scw_presence_info =
      {
      	0,
      	NULL,		/* base_init */
      	NULL,		/* base_finalize */
      	NULL,
      	NULL,		/* class_finalize */
      	NULL,		/* class_data */
      	0,
      	0,		/* n_preallocs */
      	NULL,
      	NULL,		/* value_table */
      };

      presence_type = g_type_register_static (G_TYPE_STRING, "ScwPresence",
					                                     &scw_presence_info, 0);
    }

  return presence_type;
}

GType
scw_row_color_get_type (void)
{
  static GType row_color_type = 0;

  if (!row_color_type)
    {
      static const GTypeInfo scw_row_color_info =
      {
      	0,
      	NULL,		/* base_init */
      	NULL,		/* base_finalize */
      	NULL,
      	NULL,		/* class_finalize */
      	NULL,		/* class_data */
      	0,
      	0,		/* n_preallocs */
      	NULL,
      	NULL,		/* value_table */
      };

      row_color_type = g_type_register_static (G_TYPE_STRING, "ScwRowColor",
					                                     &scw_row_color_info, 0);
    }

  return row_color_type;
}

GType
scw_interaction_get_type (void)
{
  static GType etype = 0;
  if (etype == 0) {
    static const GEnumValue values[] = {
      { SCW_INTERACTION_SELECT, "SCW_INTERACTION_SELECT", "select" },
      { SCW_INTERACTION_SMART_SELECT, "SCW_INTERACTION_SMART_SELECT", "smart-select" },
      { SCW_INTERACTION_SMART_PAN, "SCW_INTERACTION_SMART_PAN", "smart-pan" },
      { SCW_INTERACTION_PAN, "SCW_INTERACTION_PAN", "pan" },
      { 0, NULL, NULL }
    };
    etype = g_enum_register_static ("ScwInteraction", values);
  }
  return etype;
}

PangoAttrType
scw_attr_action_get_type (void)
{
  static PangoAttrType action_type = 0;

  if (action_type == 0)
    {
      action_type = pango_attr_type_register ("ScwAttrAction");
    }
  
  return action_type;
}

PangoAttribute *
scw_attr_action_new (const gchar *id)
{
  ScwAttrAction *result;
  static PangoAttrClass klass = {
    0,
    scw_attr_action_copy,
    scw_attr_action_destroy,
    scw_attr_action_compare
  };

  if (!klass.type)
    klass.type = scw_attr_action_get_type ();

  result = g_new (ScwAttrAction, 1);
  result->attr.klass = &klass;

  result->id = g_strdup (id);

  return (PangoAttribute *)result;
}

PangoAttribute *
scw_attr_action_copy (const PangoAttribute *attr)
{
  const ScwAttrAction *action_attr = (const ScwAttrAction *)attr;

  return scw_attr_action_new (action_attr->id);
}

gboolean
scw_attr_action_compare (const PangoAttribute *attr1,
                         const PangoAttribute *attr2)
{
  const ScwAttrAction *action_attr1 = (const ScwAttrAction *)attr1;
  const ScwAttrAction *action_attr2 = (const ScwAttrAction *)attr2;

  if (g_utf8_collate (action_attr1->id, action_attr2->id) == 0)
    {
      return TRUE;
    }
  
  return FALSE;
}

void
scw_attr_action_destroy (PangoAttribute *attr)
{
  ScwAttrAction *action_attr = (ScwAttrAction *)attr;

  if (action_attr->id != NULL)
    {
      g_free (action_attr->id);
      action_attr->id = NULL;
    }

  g_free (attr);
}
