/*
 * drivers/media/video/omap/omap24xxcam-dma.h
 *
 * Copyright (C) 2006 Instituto Nokia de Tecnolodia
 *
 * Author: David Cohen <david.cohen@indt.org.br>
 *
 * This file is licensed under the terms of the GNU General Public License
 * version 2. This program is licensed "as is" without any warranty of any
 * kind, whether express or implied.
 */

u32 camdma_reg_in(const struct omap24xxcam_device *, u32);
u32 camdma_reg_out(const struct omap24xxcam_device *, u32, u32);
u32 camdma_reg_merge(const struct omap24xxcam_device *, u32 offset, u32, u32);
void camdma_init(const struct omap24xxcam_device *);
void omap24xxcam_dma_ack_all(struct omap24xxcam_device *);
unsigned long omap24xxcam_dma_ack_ch(struct omap24xxcam_device *, int);
int omap24xxcam_dma_running(struct omap24xxcam_device *, int);
int omap24xxcam_dma_start(struct omap24xxcam_device *, dma_addr_t,
		unsigned long, dma_callback_t, void *);
void omap24xxcam_dma_abort_ch(struct omap24xxcam_device *, int);
void omap24xxcam_dma_mask_all(struct omap24xxcam_device *);
void omap24xxcam_dma_unmask_irq0(struct omap24xxcam_device *);
void omap24xxcam_dma_exit(struct omap24xxcam_device *);

