/*
 * rtpgstcodecs.h - Headers for RTP gstreamer codec setting
 *
 * Farsight RTP/AVP/SAVP/AVPF Module
 * Copyright (C) 2005,2006 Collabora Ltd.
 * Copyright (C) 2005,2006 Nokia Corporation
 *   @author Rob Taylor <rob.taylor@collabora.co.uk>
 *   @author Philippe Kalaf <philippe.kalaf@collabora.co.uk>
 * Copyright (C) 2005 INdT 
 *   @author Andre Moreira Magalhaes <andre.magalhaes@indt.org.br>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef __FARSIGHT_RTP_GST_CODECS_H__
#define __FARSIGHT_RTP_GST_CODECS_H__

#include <gst/gst.h>

#include "farsight-stream.h"
#include "farsight-codec.h"

#define DIR_SEND 0
#define DIR_RECV 1

G_BEGIN_DECLS

typedef struct _CodecInternal CodecInternal;

struct _CodecInternal
{
  FarsightCodec *codec;
  GstCaps *media_caps;
  GList *send_pipeline_factory;
  GList *receive_pipeline_factory;
  gboolean has_sink;
  gboolean has_src;
  gint send_has_unique;
  gint receive_has_unique;
};

G_CONST_RETURN GList *load_codecs (FarsightMediaType media_type);
void unload_codecs (FarsightMediaType media_type);
void sort_codecs (GList **list_codecs,
    const GArray *codec_preference);
GHashTable *create_pt_caps_hashtable (GList *codecs);
GHashTable *create_dynamic_pt_table (FarsightMediaType media_type, const GList
    *remote_codecs);
void update_local_dynamic_codecs (FarsightMediaType media_type, 
    const GList *remote_codecs);

void codec_internal_destroy (gpointer data);

GstElement *create_codec_bin (FarsightMediaType media_type,
    gint codec_id, gboolean dir, const GList *remote_codecs);

CodecInternal *
lookup_codec_by_pt (FarsightMediaType media_type, gint pt);

CodecInternal *
match_codec (FarsightMediaType media_type, FarsightCodec *codec);

G_END_DECLS

#endif
