#!/bin/sh
# Prints all testcases with data into stdout and does some
# formatting too. Usage: Just execute it from test root directory.

test_cases=`ls -1 | sort -n`;

echo -e "Test data in one document:\n";

for test_case in $test_cases; do
	for stest in `find $test_case -type d -mindepth 1 | sort | grep -v "\.svn"`; do
		echo "### Test ($stest) ###";
		echo -n "Description: ";
		cat $stest/README;
		echo -e "\nData: ";
		cat $stest/data.text;
		echo -e "### End of Test ($stest) ###\n";
	done;
done;

exit 0;
