import re
import os
import time
import signal
import sys
import popen2
from utils import wait_ports, wait_string, sync_string, get_addr

host = get_addr()

def wait(p):
    r = p.poll()
    if r != -1:
        return r
    for i in range(5):
        time.sleep(1)
        r = p.poll()
        if r != -1:
            return r
    print 'killed!'
    os.kill(p.pid, signal.SIGKILL)
    return p.wait()

class executable:
    def __init__(self, cmd, ignore):
        assert isinstance(cmd, list)
        self.p = popen2.Popen3(cmd, capturestderr = True)
        self.stdin = self.p.tochild
        self.stdout = self.p.fromchild
        self.stderr = self.p.childerr
        self.ignore = ignore

    #returns True if completed successfully
    def finish(self):
        r = wait(self.p)
        return r == 0

class simple_exe (executable):
    def __init__(self, exe, ignore):
        cmd = ['./' + exe]
        executable.__init__(self, cmd, ignore)

class mudflap_exe (executable):
    def __init__(self, exe, ignore):
        cmd = ['./' + exe]
        executable.__init__(self, cmd, ignore)

    #returns True if completed successfully
    def finish(self):
        r = wait(self.p)
        data  = self.stderr.read()
        if r != 0:
            print data
            return False
        viols = filter (lambda x: "mudflap violation" in x, data.split('\n'))
        return len(viols) <= self.ignore

class valgrind_exe (executable):
    def __init__(self, exe, ignore):
        suppressions = os.environ['top_srcdir'] + '/tests/regression/suppressions'
        cmd = ['/usr/bin/valgrind', '--suppressions=' + suppressions,
               '--leak-check=full', exe]
        executable.__init__(self, cmd, ignore)

    #returns True if completed successfully
    def finish(self):
        r = wait(self.p)
        data = self.stderr.read()
        if r != 0:
            print data
            return False
        a = re.search('ERROR SUMMARY: *(.*) err.*', data)
        errors = int(a.groups()[0])
        a = re.search('definitely lost: (.*) bytes', data)
        if a:
            a = int(a.groups()[0])
            if a != 0:
                errors += 1
        if errors != 0:
            print data
        return errors == 0

def get_gcda(exe):
    f = open(exe)
    data = f.read()
    f.close()
    a = re.search('/.*\.gcda', data)
    if a == None:
        return None
    return a.group()

def is_coverage(exe):
    t = get_gcda(exe)
    return t != None

def is_mudflap(exe):
    p = popen2.Popen3(['ldd', exe])
    data = p.fromchild.read()
    p.wait()
    return 'libmudflapth' in data

used_ports = {'mini_service'            : [38400],
              'basic_dev_parsing_by_fd' : [38400],
              'igd_dev'                 : [38400],
              'igd_cp'                  : [38400, 39500],
              'igd_dev_parsing'         : [38400],
              'igd_dev_parsing_by_fd'   : [38400],
              'mini_cp'                 : [39500],
              'ip_change'               : [39500],
              'mini_dev'                : [38400],
              'mini_dev_announces'      : [38400, 39500],
              'mini_service2'           : [38400]
              }

def relink_name(exe):
    return '.libs/lt-' + exe

def start(exe, ignore = 0):
    ports = used_ports.get(exe, [])
    exe   = relink_name(exe)
    wait_ports(ports)
    p     = None
    if is_coverage(exe):
        p = simple_exe(exe, ignore)
    elif is_mudflap(exe):
        p = mudflap_exe(exe, ignore)
    else:
        if os.path.exists('/usr/bin/valgrind'):
            p = valgrind_exe(exe, ignore)
        else:
            p = simple_exe(exe, ignore)
    wait_string(p.stdout, sync_string)
    return p

def finish(p):
    p.stdin.write('\n')
    p.stdin.flush()
    r = p.finish()
    if r == True:
        return 0
    else:
        return 1
