#!/usr/bin/env python

################################################
# Simple UDP Multicast Client
# Rosfran Lins Borges (rosfran.borges@indt.org.br)
# multicast_socket_send_udp.py
################################################

import sys, traceback, os, socket, time
from utils import get_addrs
import urllib2
from ssdp_notify_msg import NotifyAliveMessageSession

# default UDP host for SSDP
DEFAULT_UDP_HOST = '239.255.255.250'
# default UDP port for SSDP
DEFAULT_UDP_PORT = '1900'
# default multicast value (equals to 4, according to UPnP DA)
DEFAULT_TTL_VALUE = 4

class UDPSender:
    
    def init_memory(self, host, textport):
        """Sets UDP data connection."""
        self.udpHost = host
        self.udpPort = textport
        self.msgMounted = False
        self.socket_init(self.udpHost, self.udpPort)
                    
    def init_persistent(self, notify_type, host = None):
        self.msgMounted = False
        if self.load_file(notify_type, host) == False:
            print "Error on message identification type = %s\n" % notify_type
            #sys.exit(1)
        self.udpHost = self.notifySession.notifyMsg.get_host()
        self.udpPort = self.notifySession.notifyMsg.get_port()
        #self.location_host = self.udpPort = self.notifySession.notifyMsg.get_location()
        self.socket_init(self.udpHost, self.udpPort)
        
    def socket_init(self, host, textport):
        try:
            self.udpPort = int(textport)
        except ValueError, e:
            try:
                print "Value error %s !!!\n" % e
                self.udpPort = socket.getservbyname(textport, 'udp')
            except socket.error, e:
                print "Couldn't find your port (UDP): %s" % e
                #sys.exit(1)
        try:
            self.udpSock = socket.socket(socket.AF_INET, socket.SOCK_DGRAM)
            # Make the socket multicast-aware, and set TTL (default value is 4 - refer to UPnP DA).
            self.udpSock.setsockopt(socket.IPPROTO_IP, socket.IP_MULTICAST_TTL, DEFAULT_TTL_VALUE)
            # adds host address to a multicast group
            self.mcast_add(self.udpHost)
        except socket.error, e:
            print "Strange error creating socket: %s" % e
            #sys.exit(1)

    def load_file(self, msg_type, host = None):
        """Load configuration files for the NOTIFY messages"""
        self.notifySession = NotifyAliveMessageSession()
        self.notifyMsg = ""
        msg = ""
        #self.notifyMsg.endswith('.msg') || 
        if msg_type == "notify_ssdp_alive":
            if host == None:
                self.notifyMsg = self.notifySession.createNotifyAliveMessage()
            else:
                self.notifyMsg = self.notifySession.createNotifyAliveMessage(host)
            self.isMsgMounted = True
        elif (not msg_type.endswith('.msg') and not msg_type.endswith('.params') ):
            msg_file = msg_type+'.msg'
            params_file = msg_type+'.params'
            self.notifySession = NotifyAliveMessageSession(msg_file, params_file)
            #if ( msg_type == "notify_ssdp_alive_invalid_nt" ):
            self.notifyMsg = self.notifySession.createNotifyAliveMessage(host, msg_file, params_file)            
            self.isMsgMounted = True
        elif (msg_type.endswith('.msg') or msg_type.endswith('.params') ):
            msg = msg_type[0:msg_type.find('.')-1]
            #print "==> msg_type before == %s, after == %s\n" % (msg_type, msg)
            if ( msg_type == "notify_ssdp_alive" ):
                if host == None:
                    self.notifyMsg = self.notifySession.createNotifyAliveMessage()
                else:
                    self.notifyMsg = self.notifySession.createNotifyAliveMessage(host)
                self.isMsgMounted = True
        else:
            self.isMsgMounted = False
        #print "\tMessage contructed = %s.\n" % self.notifyMsg
        return self.isMsgMounted

    def mcast_add(self, mcast_addr):
        """Adds this address to a multicast group"""
        #(trueHostName, aliasesList, self.ifaceList) = socket.gethostbyname_ex(socket.gethostname())
        # current interface list
        self.ifaceList = get_addrs()
        self.ifaceList.remove('127.0.0.1')
        for self.mcastIface in self.ifaceList:
            #print "Multicast Interface = %s (udpHost = %s)\n" % (self.mcastIface, mcast_addr)
            try:
                self.udpSock.setsockopt( socket.IPPROTO_IP, socket.IP_MULTICAST_IF, socket.inet_aton(self.mcastIface) )
                self.udpSock.setsockopt( socket.IPPROTO_IP, socket.IP_ADD_MEMBERSHIP,
                                        socket.inet_aton(mcast_addr) + socket.inet_aton(self.mcastIface) )
            except AttributeError:
                print "System doesn't support adding this socket to a multicast group: mcast_addr = %s, mcast_iface = %s\n" % (mcast_addr, mcastIface)

    def connect_udp(self):
        """Connect UDP (don't use it to multicast!)"""
        try:
            self.udpSock.connect((self.udpHost, self.udpPort))
        except socket.gaierror, e:            
            print "Address-related error connecting to server: %s" % e
            #sys.exit(1)
        except socket.error, e:
            print "Connection error: %s" % e
            #sys.exit(1)

    def send_message(self, msg, arguments):
        """Send UDP Multicast message"""
        content = msg % arguments
        #print "Sending UDP message below:\n %s\n" % content
        try:
            self.udpSock.sendto(content, (self.udpHost, self.udpPort))
        except socket.error, e:
            print "Error sending data: %s" % e
            #sys.exit(1)

    def send_message_from_file(self):
        """
        Send UDP Multicast message
        
        @param host    Sets a new host to the Location header        
        """
        #print "Sending UDP message to host %s, port %s:\n%s\n" % (self.udpHost, self.udpPort, self.notifyMsg)

        try:
            self.udpSock.sendto(self.notifyMsg, (self.udpHost, self.udpPort))
        except socket.error, e:
            print "Error sending data: %s" % e
            #sys.exit(1)

    def close_udp(self):   
        """Close UDP socket"""
        try:
            self.udpSock.close()
        except socket.error, e:
            print "Error closing socket: %s" % e
            #sys.exit(1)
    
    def close_mult_udp(self):
        try:
            self.udpSock.setsockopt( socket.IPPROTO_IP, socket.IP_DROP_MEMBERSHIP, 
                                    socket.inet_aton(self.udpHost) + socket.inet_aton('0.0.0.0'))
            self.close_udp()
        except AttributeError:
            print "System doesn't support dropping this socket to a multicast group: mcast_addr = %s, mcast_iface = %s\n" % (self.udpHost, mcastIface)
