
# need to be changed!

import os

class MSearchResponseMessage:
    def __init__(self):
        """Sets default values """
        self.cacheControl = "1800"
        self.location = "http://172.19.141.70:49152/gatedesc.xml"
        self.nt = "urn:schemas-upnp-org:device:InternetGatewayDevice:1"
    def show(self):
        print "NotifyAliveMessage => cacheControl = %s, location = %s, nt = %s\n" % (self.cacheControl, self.location, self.nt)

class MSearchResponseMessageSession:
    def __init__(self):
        self.notifyMsg = MSearchResponseMessage()

    def getMsgContentFromFile(filename):
        print "Openning message filename = %s\n" % (MSGS_DIR+filename)
        s = ""
        fileContent = []
        if os.path.exists(MSGS_DIR+filename):
            f = open(MSGS_DIR+filename, 'r+')
            fileContent = f.readlines()
            #print "s = %s\n"  % s
        s = "\r\n".join(fileContent)
        s += "\r\n"
        return s
        #print "MSG == %s" % s

    def createMSearchResponseMessage(self, host):
        msgNotifyAlive = self.getMsgContentFromFile(NOTIFY_ALIVE_MSG_FILENAME)
        self.loadNotifyAliveMessageParams()
        print "notifyMsg = %s\n" % self.notifyMsg.show()
        return msgNotifyAlive % (host, self.notifyMsg.cacheControl, self.notifyMsg.location, self.notifyMsg.nt)
    
    def loadMSearchResponseMessageParams(self):
        """Load data from the MSearch message from a file."""
        config = ConfigParser.ConfigParser()
        if os.path.exists(MSGS_DIR+NOTIFY_ALIVE_PARAMS_FILENAME):
            config.read(MSGS_DIR+NOTIFY_ALIVE_PARAMS_FILENAME)
            try:
                cacheControl=config.get("Notify SSDP Alive Params", "CacheControl")
                location=config.get("Notify SSDP Alive Params", "Location")
                nt=config.get("Notify SSDP Alive Params", "NT")
            except:
                raise "ConfigError", "Problems on configuration file (%s) " % NOTIFY_ALIVE_PARAMS_FILENAME
            else:
                self.notifyMsg.cacheControl = cacheControl
                self.notifyMsg.location = location
                self.notifyMsg.nt = nt
        else:
            print "Creating file %s..." % MSGS_DIR+NOTIFY_ALIVE_PARAMS_FILENAME
            self.create()
    
    def create(self):
        self.save()
    
    def save(self):
        """Store data from the SSDP Alive message in a file."""
        config = ConfigParser.ConfigParser()
        config.add_section("Notify SSDP Alive Params")
        config.set("Notify SSDP Alive Params", "CacheControl", self.notifyMsg.cacheControl)
        config.set("Notify SSDP Alive Params", "Location", self.notifyMsg.location)
        config.set("Notify SSDP Alive Params", "NT", self.notifyMsg.nt)
        file = open(MSGS_DIR+NOTIFY_ALIVE_PARAMS_FILENAME, "w")
        config.write(file)
        file.close()
