/* similar to mini_service.c, but also provides an action and a query
   listener */

#include <cybergarage/upnp/cupnp.h>
#include <string.h>
#include <stdio.h>
#include "common.h"

static BOOL actionreceived(CgUpnpAction *action)
{
	char *actionName = cg_upnp_action_getname(action);
	if (strcmp("Say", actionName) == 0) {
		cg_upnp_action_getargumentbyname(action, "");
		cg_upnp_action_getargumentbyname(action, "What");
		cg_upnp_action_getargumentbyname(action, "abc");
		return TRUE;
	}
	return FALSE;
}

static BOOL queryreceived(CgUpnpStateVariable *var) {
	return TRUE;
}

int main( int argc, char* argv[] )
{
	CgUpnpDevice *dev = cg_upnp_device_new();

	const char *top_srcdir = getenv("top_srcdir");
	const char *fname = "/tests/regression/mini_dev.xml";
	int len = strlen(top_srcdir) + strlen(fname) + 1;
	char full_name[len];
	strcpy(full_name, top_srcdir);
	strcat(full_name, fname);
	cg_upnp_device_loaddescriptionfile(dev, full_name);

	CgUpnpService *service = cg_upnp_device_getservicebyexacttype(dev, "urn:schemas-upnp-org:service:timer:1");

	cg_upnp_service_parsedescription(service, SERVICE_DESCRIPTION, strlen(SERVICE_DESCRIPTION));

	cg_upnp_device_setquerylistener(dev, queryreceived);

	cg_upnp_device_setactionlistener(dev, actionreceived);

        cg_upnp_device_setleasetime(dev, 1800);
	cg_upnp_device_start(dev);

	printf(SYNC_STRING);
	fflush(NULL);
	getchar();

	cg_upnp_device_stop(dev);
	cg_upnp_device_delete(dev);

	return(0);
}
