/**
 *
 * 	UPnP IGD simple device implementation (using a UPnP Device file descriptor)
 *
 */

#include <cybergarage/upnp/cupnp.h>
#include <string.h>
#include "common.h"

char *IGD_DEVICE_DESCRIPTION_FILE_NAME = "igddescs/gatedesc.xml";
char *IGD_ICFG_SERVICE_DESCRIPTION_FILE_NAME = "igddescs/gateifcgSCPD.xml";
char *IGD_CONN_SERVICE_DESCRIPTION_FILE_NAME = "igddescs/gateconnSCPD.xml";

/**
 * Action listener for WAN Common Interface Config service 
 * Just see if the action is conformant with any service, in any IGD embedded device
 */
BOOL upnp_igd_common_ifcg_actionreceived(CgUpnpAction *action)
{
	char *actionName;
	CgUpnpService* service;

	actionName = cg_upnp_action_getname(action);
	service = cg_upnp_action_getservice(action);
	if (cg_strcmp(cg_upnp_service_getserviceid(service), "urn:upnp-org:serviceId:WANCommonIFC1") == 0) {
		if (cg_strcmp(actionName,"GetCommonLinkProperties") == 0)
			return TRUE;
		else if (cg_strcmp(actionName,"GetTotalBytesReceived") == 0)
			return TRUE;
		else return FALSE;
	}

	return FALSE;
}

/**
 * upnp_igd_device_with_fd_new
 */
CgUpnpDevice *upnp_igd_device_with_fd_new(char* fileName)
{
	CgUpnpDevice *igdDev = cg_upnp_device_new();

	cg_upnp_device_setdescriptionuri( igdDev, "/igddescs/gatedesc.xml" );

	if (cg_upnp_device_loaddescriptionfile(igdDev, 
			(fileName != NULL) ? fileName : IGD_DEVICE_DESCRIPTION_FILE_NAME) == FALSE) {
		fprintf( stderr, "IGD device description has not a valid path!\n" );
		cg_upnp_device_delete(igdDev);
		return NULL;
	}

	cg_upnp_device_setactionlistener(igdDev, upnp_igd_common_ifcg_actionreceived);
	
	return igdDev;
	
}


int main( int argc, char* argv[] )
{
	CgUpnpDevice *igdDev = NULL;
	char *full_name = NULL;
	int len = 0;

	const char *top_srcdir = getenv("top_srcdir");
	fprintf( stderr, "\ntop_srcdir = %s\n", top_srcdir );
	const char *tests_dir = "/tests/regression/";
	if (top_srcdir != NULL) {
		len = strlen(top_srcdir) + strlen(tests_dir) + strlen(IGD_DEVICE_DESCRIPTION_FILE_NAME) + 1;
		full_name = (char*)malloc(sizeof(char)*len);
		snprintf( full_name, len, "%s%s%s", top_srcdir, tests_dir, IGD_DEVICE_DESCRIPTION_FILE_NAME );
	} else {
		len = strlen(IGD_DEVICE_DESCRIPTION_FILE_NAME) + 1;
		full_name = (char*)malloc(sizeof(char)*len);
		snprintf( full_name, len, "%s", IGD_DEVICE_DESCRIPTION_FILE_NAME );
	}

	igdDev = upnp_igd_device_with_fd_new( full_name );
	free(full_name);
	
	if ( igdDev != NULL ) {
		if ( !cg_upnp_device_start(igdDev) ) {
			fprintf( stderr, "IGD Device couldn't be started!\n" );
		} else {
			fprintf( stderr, "IGD Device started!\n" );
		}
	}
	
	printf(SYNC_STRING);
	fflush(NULL);
	getchar();	

	cg_upnp_device_stop(igdDev);
	cg_upnp_device_delete(igdDev);

	return(0);
}
