/**
 *
 *	UPnP Basic device implementation (using a UPnP Device file descriptor)
 *
 */

#include <cybergarage/upnp/cupnp.h>
#include <string.h>
#include <unistd.h>
#include "common.h"

char *BASIC_DEVICE_DESCRIPTION_FILE_NAME = "descs/basicdev.xml";
char *BASIC_DEVICE_DESCRIPTION_NOUDN_FILE_NAME = "descs/basicdev_noudn.xml";

/**
 * upnp_basic_device_with_fd_new
 */
CgUpnpDevice *upnp_basic_device_with_fd_new(char* fileName)
{
	CgUpnpDevice *basicDev;

	basicDev = cg_upnp_device_new();

	cg_upnp_device_setdescriptionuri( basicDev, "/descs/basicdev.xml" );

	if (cg_upnp_device_loaddescriptionfile(basicDev, 
			(fileName != NULL) ? fileName : BASIC_DEVICE_DESCRIPTION_FILE_NAME) == FALSE) {
		fprintf( stderr, "UPnP Basic device description has not a valid path! (%s)\n", 
			(fileName != NULL) ? fileName : BASIC_DEVICE_DESCRIPTION_FILE_NAME );
		cg_upnp_device_delete(basicDev);
		return NULL;
	}

	return basicDev;

}

int main( int argc, char* argv[] )
{
	CgUpnpDevice *basicDev = NULL;
	char *full_name = NULL;
	int len = 0;

	const char *top_srcdir = getenv("top_srcdir");
	fprintf( stderr, "top_srcdir = %s\n", top_srcdir );
	const char *tests_dir = "/tests/regression/";
	if (top_srcdir != NULL) {
		len = strlen(top_srcdir) + strlen(tests_dir) + strlen(BASIC_DEVICE_DESCRIPTION_FILE_NAME) + 1;
		full_name = (char*)malloc(sizeof(char)*len);
		snprintf( full_name, len, "%s%s%s", top_srcdir, tests_dir, BASIC_DEVICE_DESCRIPTION_FILE_NAME );
	} else {
		len = strlen(BASIC_DEVICE_DESCRIPTION_FILE_NAME) + 1;
		full_name = (char*)malloc(sizeof(char)*len);
		snprintf( full_name, len, "%s", BASIC_DEVICE_DESCRIPTION_FILE_NAME );
	}

	fprintf( stderr, "Full file-name = %s\n", full_name );
							
	basicDev = upnp_basic_device_with_fd_new( full_name );
	
	if ( basicDev != NULL ) {
		if ( !cg_upnp_device_start(basicDev) ) {
			fprintf( stderr, "Basic Device couldn't be started!\n" );
		} else {
			fprintf( stderr, "Basic Device started!\n" );
		}
	}
	
	printf(SYNC_STRING);
	fflush(NULL);
	getchar();	

	cg_upnp_device_stop(basicDev);
	cg_upnp_device_delete(basicDev);

	return(0);
}
