/************************************************************
*
*	CyberLink for C
*
*	Copyright (C) Satoshi Konno 2005
*
*	File: clock_main.c
*
*	Revision:
*       05/11/05
*               - first release.
*
************************************************************/

#include <cybergarage/upnp/cupnp.h>

#include "clock_device.h"

#include <fcntl.h>
#include <argp.h>

#if defined(TENGINE)
#if defined(PROCESS_BASE) /* Process based */
#include <basic.h>
#define MBEG	int main( W ac, TC *av[] )
#define MEND	0
#define DIR	"/SYS/bin/"
#else /* T-Kernel based */
#include <basic.h>
#include <tk/tkernel.h>
#include <sys/pinfo.h>
#define MBEG	ER main( INT ac, UB *av[] )
#define MEND	E_SYS
#define DIR	"/SYS/bin/"
#endif
#endif

#define MAX_DESCR_SIZE 20480
CgUpnpDevice *clockDev;

const char *argp_program_version = "descriptionXML 2";
const char *argp_program_bug_address = "<ms@invalid>";

struct arguments
{
	char *s_description, *description;
	int cache_control;
};

static struct argp_option options[] =
{
	{ "description-xml", 'd', "FILE", 0, "Description XML file" },
	{ "service-description-xml", 's', "FILE", 0, "Service description XML file" },
	{ "cache-control", 'c', "INT", 0, "Cache control value in seconds" },
	{0}
};

static error_t parse_opt(int key, char *arg, struct argp_state *state)
{
	  struct arguments *arguments = state->input; 
	  
	  switch (key) 
	  { 
		  case 'd': 
			  arguments->description = arg;
			  break; 
		  
		  case 's': 
			  arguments->s_description = arg;
			  break; 
		  
		  case 'c': 
			  arguments->cache_control = atoi(arg);
			  break; 
		  
		  default: 
			  return ARGP_ERR_UNKNOWN; 
	  } 
	  
	  return 0;
}

static char args_doc[] = "";
static char doc[] = "descriptionXML -- A program to execute tests against Upnp stack.";

static struct argp argp = {options, parse_opt, args_doc, doc};



////////////////////////////////////////////////////////// 
//  InitApp
////////////////////////////////////////////////////////// 

BOOL InitApp( struct arguments arguments )
{
        int fd;
        char *buf;
        int bytesRead;

        fd = open( arguments.s_description, O_RDONLY );
        if ( fd == -1 ) {
                printf( "Service description file open failed.\n" );
                return FALSE;
        }
        
        buf = (char*) calloc( MAX_DESCR_SIZE, 1 );
        bytesRead = read( fd, buf, MAX_DESCR_SIZE );
        buf[bytesRead] = '\0';
        close( fd );
	clockDev = upnp_clock_device_new( arguments.description, 
                                          "urn:schemas-upnp-org:service:timer:1", 
                                          buf );
        if ( clockDev == NULL ) {
                printf( "upnp_clock_device_new() failed\n" );
                free( buf );
                return FALSE;
        }
        cg_upnp_device_setleasetime( clockDev, arguments.cache_control );
        free( buf );
	return cg_upnp_device_start(clockDev);
}

void ExitApp()
{
	cg_upnp_device_stop(clockDev);
	cg_upnp_device_delete(clockDev);
}

////////////////////////////////////////////////////////// 
//  main
////////////////////////////////////////////////////////// 

#if defined(TENGINE)
MBEG
#else
int main( int argc, char* argv[] )
#endif
{
	struct arguments arguments;

	arguments.description = NULL;
	arguments.s_description = NULL;
	arguments.cache_control = 1800;
	
	argp_parse (&argp, argc, argv, 0, 0, &arguments);

        printf( "Using CACHE-CONTROL value: %d sec\n", arguments.cache_control );

	if (InitApp( arguments ) == FALSE) {
		fprintf(stderr, "Couldn't create this device !!\n");
		exit(0);
	}
				
	int ch = 0;

        printf( "Press Enter to generate an event, q to quit.\n" );

        upnp_clock_device_update(clockDev);

        ch = getchar();
        while ( ch != 'q' ) {
                upnp_clock_device_update(clockDev);
                ch = getchar();
	};

	ExitApp();
	
	return(0);
}
