/**
 * Clinkc-av control point test tool
 *
 *
 * Copyright (c) 2006 Nokia Corporation. All rights reserved.
 *
 * This is licensed under BSD-style license with patent exclusion,
 * see file COPYING.
 */
#ifndef AV_CPTEST_H
#define AV_CPTEST_H

#include <cybergarage/upnp/ccontrolpoint.h>

/**
 * Test case prototype
 *
 * @param cp The Control point
 */
typedef int (*TEST_CASE_FUNCTION)(CgUpnpControlPoint*);
typedef struct _AVCPTestCase
{
	char name[256];
	int result;

	TEST_CASE_FUNCTION func;

} AVCPTestCase;

/**
 * Sub test case prototype
 *
 * @param cp The Control point
 * @param udn The UDN of the device to use for testing
 */
typedef int (*SUB_TEST_CASE_FUNCTION)(CgUpnpControlPoint*, char*);
typedef struct _AVCPSubTestCase
{
	char name[256];
	int result;

	SUB_TEST_CASE_FUNCTION func;
	void* result_data;

} AVCPSubTestCase;

/**
 * Create a control point and start it.
 */
CgUpnpControlPoint* init_upnp_controlpoint(void);

/**
 * Stop a control point and destroy it.
 */
int destroy_upnp_controlpoint(CgUpnpControlPoint* cp);

/**
 * Find a device with a given service
 *
 * @param cp A control point instance
 * @param service_name The name of the service to search for from cp's devices
 *
 * @return A newly-created string containing the UDN of the device that has
 *         the given service or; NULL if a suitable device was not found
 */
char* cp_test_get_device_udn_with_service(CgUpnpControlPoint* cp,
					  char* service_name);

/**
 * Find a test case by its name from an array of test cases
 *
 * @param tc_array The array of test cases
 * @param size Number of test cases in the array
 * @param name The name of the test case to search for
 *
 * @return The index of the test case struct or -1 if it wasn't found
 */
int cp_test_find_test_case(AVCPTestCase* tc_array, int size, char* name);

#endif
