/*
 * UPnP CDS Browser
 *
 * main.c
 *
 * Copyright 2005 Nokia Corporation. All rights reserved.
 *
 * This is licensed under BSD-style license with patent exclusion,
 * see file COPYING.
 */

#include <gtk/gtkmain.h> 
#include <gconf/gconf-client.h>

#include "../interface.h"
#include "../upnp.h"
#include "../settings.h"

extern UPnPBrowserWidgets* widgets;

static gboolean delete_event(GtkWidget *widget, GdkEvent *event, gpointer data)
{
	return FALSE;
}

static void destroy(GtkWidget *widget, gpointer data)
{
    gtk_main_quit ();
}

int main(int argc, char* argv[])
{
	widgets = g_new0(UPnPBrowserWidgets, 1);
	if (widgets == NULL)
	{
		return -1;
	}

	widgets->settings = g_new0(UPnPBrowserSettings, 1);
	if (widgets->settings == NULL)
	{
		return -1;
	}

	/* Initialize the GTK. */
	gtk_init( &argc, &argv );

	/* Initialize GConf */
	gconf_init(argc, argv, NULL);
	
	/* Load settings */
	if (settings_load(widgets->settings) == FALSE)
	{
		fprintf(stderr, "Unable to load settings\n");
	}
	
	widgets->app = NULL;
	widgets->appview = gtk_window_new(GTK_WINDOW_TOPLEVEL);

	g_signal_connect (G_OBJECT (widgets->appview), "delete_event",
			  G_CALLBACK (delete_event), NULL);
    

	g_signal_connect (G_OBJECT (widgets->appview), "destroy",
			  G_CALLBACK (destroy), NULL);

	widgets->toolbar = NULL;

	/* Create the interface widgets */
	create_widgets();

	gtk_window_set_default_size(GTK_WINDOW(widgets->appview), 1000, 600);
        gtk_window_set_title(GTK_WINDOW(widgets->appview), "Nokia UPnP Browser (Prototype)");

	/* Show all widgets */
	/* gtk_widget_show_all(GTK_WIDGET(widgets->app)); */
	gtk_widget_show_all(GTK_WIDGET(widgets->appview));

	/* Initialize and start the control point */
	init_upnp_controlpoint();
	
	/* Search servers if that is wanted */
	if (widgets->settings->updateServers == TRUE)
	{
		update_clicked();
	}
	
	/* Start the main application */
	gtk_main();

	destroy_upnp_controlpoint();
	
	if (settings_save(widgets->settings) == FALSE)
	{
		fprintf(stderr, "Unable to save settings\n");
	}
	
	g_free(widgets->settings);
	g_free(widgets);
	
	/* Exit */
	return 0;
}
