/*
 * UPnP Browser for Maemo
 *
 * helper.h
 *
 * Copyright 2005 Nokia Corporation. All rights reserved.
 *
 * This is licensed under BSD-style license with patent exclusion,
 * see file COPYING.
 */
 
#ifndef BROWSER_H
#define BROWSER_H

#include <gtk/gtk.h>

#define TREE_CELL_HEIGHT (30 + 1)

enum {
	FOLDERMODEL_COLUMN_NAME,
	FOLDERMODEL_COLUMN_CONTAINER,
	FOLDERMODEL_COLUMN_DEVUDN,
	FOLDERMODEL_COLUMN_CLASS,
	FOLDERMODEL_COLUMN_URI,
	FOLDERMODEL_COLUMN_ID,
	FOLDERMODEL_COLUMN_BROWSED,
	FOLDERMODEL_COLUMNS
};

/**
 * Create the device tree model & view
 */
int create_device_view();

/**
 * Create the folder/file list model & view
 */
int create_folder_model_view();

/**
 * Callback for selecting a row in device list.
 */
void device_view_row_selected(GtkTreeSelection *selection,
			      gpointer user_data);

/**
 * Callback for selecting a row in the folder view
 */
void folder_view_row_selected(GtkTreeSelection *selection,
			      gpointer user_data);

/**
 * Callback for expanding a folder in folder view
 */
void folder_view_row_expanded(GtkTreeView *view,
			      GtkTreeIter *iter,
			      GtkTreePath *path,
			      gpointer user_data);

/**
 * Renders right pixbuf according to class of the device.
 */
void render_mimeimage_datafunc(GtkTreeViewColumn *column,
			       GtkCellRenderer *renderer,
			       GtkTreeModel *model,
			       GtkTreeIter *iter,
			       gpointer data);
			       
/**
 * Filter the contents of the given model
 */
gboolean container_filter_func(GtkTreeModel *model,
			       GtkTreeIter *iter,
			       gpointer data);

/**
 * @param path	Path in folder_model.
 * @return if it was updated.
 */
gboolean update_folder_view_to_path(GtkTreePath *path);

/**
 * Helper to get the currently selected content directory item
 *
 * @param uri The URI of the currently selected resource
 * @param node_class The UPnP class of the currently selected resource
 * @param id The object ID of the currently selected resource
 * @param udn The UDN of the server offering the currently selected resource
 * @return TRUE if an item was selected; otherwise FALSE
 */
gboolean get_current_content_item(gchar** name, gchar** uri,
				  gchar** node_class, gchar** id,
				  gchar** udn);

#endif
