#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include <ctype.h>
#include <errno.h>
#include <fcntl.h>
#include <sys/ioctl.h>
#include <sys/wait.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sched.h>
#include <alsa/asoundlib.h>

#include "../sexyal.h"
#include "../md5.h"
#include "../smallc.h"

#include "alsa.h"

 static snd_pcm_t *playback_handle = NULL;

SexyAL_device *SexyALI_ALSA_Open(uint64_t id, SexyAL_format *format, SexyAL_buffering *buffering){
 int err = -1;
 SexyAL_device *device = NULL;
 snd_pcm_hw_params_t *hw_params = NULL;
 snd_pcm_sw_params_t *sw_params = NULL;

 playback_handle = NULL;

 /* Set sample format. */

/*
 if(format->sampformat == SEXYAL_FMT_PCMU8)
  temp=AFMT_U8;
 else if(format->sampformat == SEXYAL_FMT_PCMS8)
  temp=AFMT_S8;
 else if(format->sampformat == SEXYAL_FMT_PCMU16)
  temp=AFMT_U16_LE;
 else 
  temp=AFMT_S16_NE;
*/

 format->byteorder=0;
 format->channels=1;
 format->rate=8192;

 err = snd_pcm_open(&playback_handle, "plughw:0,0", SND_PCM_STREAM_PLAYBACK, 0);
 if(0>err){
 	printf("Unable to open audio device %s: %s\n","plughw:0,0",snd_strerror(err));
	return device;
 }//error opening alsa

 err = snd_pcm_hw_params_malloc(&hw_params);
 if(0>err){
 	printf("Unable to allocate hardware parameter structure: %s\n",snd_strerror(err));
	return device;
 }//error allocating hw params

 err = snd_pcm_hw_params_any(playback_handle, hw_params);
 if(0>err){
 	printf("Unable to initialize hardware parameters: %s\n",snd_strerror(err));
	return device;
 }//error initializing hw params

 err = snd_pcm_hw_params_set_access(playback_handle, hw_params, SND_PCM_ACCESS_RW_INTERLEAVED);
 if(0>err){
 	printf("Unable to set access type: %s\n",snd_strerror(err));
	return device;
 }//error setting access type

 err = snd_pcm_hw_params_set_format(playback_handle, hw_params, SND_PCM_FORMAT_U8);
 if(0>err){
 	printf("Unable to set format: %s\n",snd_strerror(err));
	return device;
 }//error setting format

 err = snd_pcm_hw_params_set_rate_near(playback_handle, hw_params, &(format->rate), 0);
 if(0>err){
 	printf("Unable to set rate: %s\n",snd_strerror(err));
	return device;
 }//error setting rate

 err = snd_pcm_hw_params_set_channels(playback_handle, hw_params, 1);
 if(0>err){
 	printf("Unable to set channels: %s\n",snd_strerror(err));
	return device;
 }//error setting channels

 err = snd_pcm_hw_params(playback_handle, hw_params);
 if(0>err){
 	printf("Unable to apply parameters: %s\n",snd_strerror(err));
	return device;
 }//error applying parameters
 snd_pcm_hw_params_free(hw_params);

 err = snd_pcm_sw_params_malloc(&sw_params);
 if(0<err){
 	printf("Unable to allocate sw param structure: %s\n",snd_strerror(err));
	return device;
 }//can't allocate sw params

 err = snd_pcm_sw_params_current(playback_handle, sw_params);
 if(0>err){
 	printf("Unable to get current sw params: %s\n",snd_strerror(err));
	return device;
 }//can't get current sw params

 err = snd_pcm_sw_params_set_avail_min(playback_handle, sw_params, 4096);
 if(0>err){
 	printf("Unable to set buffer size: %s\n",snd_strerror(err));
	return device;
 }//can't set buffer size

 err = snd_pcm_sw_params_set_start_threshold(playback_handle, sw_params, 0U);
 if(0>err){
 	printf("Unable to set start threshold: %s\n",snd_strerror(err));
	return device;
 }//can't set start size

 err = snd_pcm_sw_params(playback_handle, sw_params);
 if(0>err){
 	printf("Unable to apply software params: %s\n",snd_strerror(err));
	return device;
 }//can't apply sw params
 snd_pcm_sw_params_free(sw_params);

 err = snd_pcm_prepare(playback_handle);
 if(0>err){
 	printf("Unable to prepare audio device %s: %s\n","plughw:0,0",snd_strerror(err));
	return device;
 }//error preparing audio interface

 buffering->fragcount=64;
 buffering->fragsize=64;
 buffering->totalsize=buffering->fragsize*buffering->fragcount;

 device=malloc(sizeof(SexyAL_device));
 sal_memcpy(&device->format,format,sizeof(SexyAL_format));
 sal_memcpy(&device->buffering,buffering,sizeof(SexyAL_buffering));

 return(device);
}//SexyALI_ALSA_Open


int SexyALI_ALSA_Close(SexyAL_device *device){
	snd_pcm_close(playback_handle);
	return 1;
}//SexyALI_ALSA_Close


uint32_t SexyALI_ALSA_RawWrite(SexyAL_device *device, void *data, uint32_t len){
	uint32_t bytes = snd_pcm_writei(playback_handle, data, len);
	return (bytes >= 0)?bytes:0;
}//SexyALI_ALSA_RawWrite


uint32_t SexyALI_ALSA_RawCanWrite(SexyAL_device *device){
	uint32_t frames = snd_pcm_avail_update(playback_handle);
	return (frames>=0)?frames:0;
}//SexyALI_ALSA_RawCanWrite
