#ifdef HAVE_LIBOSSO

#include <stdio.h>

#include "osso.h"
#include "../../driver.h"
#include "dface.h"
#include "main.h"

gboolean make_shutdown_save();


gboolean osso_connect(){
	gboolean rv = TRUE;
	//osso_hw_state_t states_I_care_about = { TRUE, FALSE, FALSE, TRUE };

	osso = osso_initialize("FCEU",FCEU_VERSION, FALSE, NULL);
	if(!osso){
        	FCEUD_Message("Unable to initialize osso\n");
		rv = FALSE;
	}//error initializing osso

	if(OSSO_OK != osso_hw_set_event_cb(osso, NULL, osso_display_state_change_cb, NULL)){
		FCEUD_Message("Unable to register display event callback\n");
		rv = FALSE;
	}//error setting up display event callback
	
	FCEUD_Message("Osso initialized\n");

	return rv;
}//osso_connect


void osso_display_state_change_cb(osso_hw_state_t *state, gpointer data){
	FCEUD_Message("Got osso display state change\n");
	int paused = 0;

	if(!state){
		return;
	}//something's seriously wrong

	if(state->shutdown_ind){
		/* Save state to alternate location and create lockfile*/
		FCEUD_Message("Got shutdown event, autosaving\n");
		make_shutdown_save();
	}//Device is shutting down
	else{ 
		paused = state->system_inactivity_ind;
		FCEU_pause(paused);

		/* Debug */
		if(paused){
			printf("FCEU: Pausing\n");
		}else{
			printf("FCEU: Unpausing\n");
		}
	}//Device just de/reactivated
}//osso_display_state_change_cb


gboolean make_shutdown_save(){
	gboolean rv = TRUE;
	gchar *lockfile = NULL;
	FILE *lock = NULL;

	FCEUI_SelectState(1);
	FCEUI_SaveState(NULL);
	FCEUI_SelectState(0);

	lockfile = g_strdup_printf("%s/%s", GetBaseDirectory(), "shutdown.LCK");

	lock= fopen(lockfile, "w");
	if(lock){
		fclose(lock);
		rv = FALSE;
	}//error creating lockfile

	g_free(lockfile);

	return rv;
}//make_shutdown_save


#endif
