#!/usr/bin/env python2.4
# -*- coding: UTF8 -*-

import gtk
import gtk.gdk
import hildon
import osso

osso_c = osso.Context("maemo_periodic", "1.0", False)


units=['u.m.','g/cm³','K','pm','cm³/mol','J/g mol (@20°C)','kJ/mol','W/m K (@25°C)','A']
corresp=[-1,-1,-1,0,1,2,2,3,3,3,3,4,5,6,6,7,2,-1,6,6,6,6,-1,-1,-1,8,-1,-1,-1,-1,-1]

from listas import *


class MainWindow(hildon.Program):
	def __init__(self):
		hildon.Program.__init__(self)
        
		self.window = hildon.Window()
		self.window.set_default_size(800, 480)
		self.window.connect("destroy", gtk.main_quit)

## Fullscreen signals
		self.window.connect("key-press-event", self.on_key_press)
		self.window.connect("window-state-event", self.on_window_state_change)
		self.window_in_fullscreen = False 

		self.add_window(self.window)
 
## Make menu       
		self.menubar1 = gtk.Menu()
		for child in self.menubar1.get_children():
			child.reparent(menu)
		self.window.set_menu(self.menubar1)
		self.window.show_all()
		self.menubar1.show()

		self.exit = gtk.MenuItem("Exit")
		self.exit.show()
		self.exit.connect("activate", gtk.main_quit)

		self.about = gtk.MenuItem("About")
		self.about.show()
		self.about.connect("activate", self.on_menu_about)

		self.menubar1.append(self.about)
		self.menubar1.append(self.exit)

## Make table

		self.table1 = gtk.Table()
		self.table1.show()
		self.table1.set_row_spacings(0)
		self.table1.set_col_spacings(0)

## Make the periodic table
		
		boton=['']

		for i in range(1,len(nom)):
			self.alignment1 = gtk.Alignment(0.5, 0.5, 1, 1)
			self.alignment1.show()

			self.hbuttonbox1 = gtk.HButtonBox()
			self.hbuttonbox1.set_size_request(35, 20)
			self.hbuttonbox1.show()
			self.hbuttonbox1.set_spacing(0)
			self.hbuttonbox1.set_layout(gtk.BUTTONBOX_DEFAULT_STYLE)

			self.button1 = gtk.Button()
			boton.append(self.button1)
			
			boton[i].set_size_request(35, 20)
			boton[i].connect("clicked", self.on_click)


			self.label1 = gtk.Label()
			self.label1.set_markup("<small>"+sim[i]+"</small>")
			self.button1.add(self.label1)
			#self.button1.modify_bg(gtk.STATE_NORMAL, color6)
			#boton[i].set_label('<small>'+sim[i]+'</small>')
			boton[i].set_name(sim[i])
			boton[i].show()


			self.hbuttonbox1.pack_start(boton[i])

			self.alignment1.add(self.hbuttonbox1)
			if i==1:
				left=0
				top=0
			elif i==2:
				left=17
				top=0
			elif i in range(3,5):
				left=i-3
				top=1
			elif i in range(5,11):
				left=i+7
				top=1
			elif i in range(11,13):
				left=i-11
				top=2
			elif i in range(13,19):
				left=i-1
				top=2
			elif i in range(19,37):
				left=i-19
				top=3
			elif i in range(37,55):
				left=i-37
				top=4
			elif i in range(55,57):
				left=i-55
				top=5
			elif i in range(72,87):
				left=i-69
				top=5
			elif i in range(87,89):
				left=i-87
				top=6
			elif i in range(104,112):
				left=i-101
				top=6
			elif i in range(57,72):
				left=i-55
				top=7
			elif i in range(89,104):
				left=i-87
				top=8
			
			

			right=left+1
			bottom=top+1
			self.table1.attach(self.alignment1, left, right, top, bottom, gtk.EXPAND|gtk.FILL, gtk.EXPAND|gtk.FILL, 0, 0)



## add table to main window

		self.window.add(self.table1)

## Functions for call elements window

	def on_click(self, widget):
		global element
		element = widget.get_name()
		MyDialog()


## Functions for fullscreen
	def on_window_state_change(self, widget, event, *args):           
		if event.new_window_state & gtk.gdk.WINDOW_STATE_FULLSCREEN:
			self.window_in_fullscreen = True
		else:
			self.window_in_fullscreen = False

	def on_key_press(self, widget, event, *args):            
		if event.keyval == gtk.keysyms.F6:
			if self.window_in_fullscreen:
				self.window.unfullscreen ()
			else:
				self.window.fullscreen ()

## Function about menu

	def on_menu_about(self, widget):
		AboutDialog()

## Run graphical interface
	def run(self):
		self.window.show_all()
		gtk.main()

## About Dialog
class AboutDialog:
	def __init__(self):

		dialog = gtk.AboutDialog()
		dialog.set_name("Maemo Periodic")
		dialog.set_version("0.4")
		dialog.set_copyright("Copyleft © 2006")
		dialog.set_website("https://garage.maemo.org/projects/maemo-periodic/")
		dialog.set_authors(["Luis Lorenzo Paris <llorenzo@gmail.com>", "Daniel Martin Yerga <dyerga@gmail.com>"])
		dialog.set_artists(["Logo and icon by Daniel Martín Yerga <dyerga@gmail.com>."])
 		logo = gtk.gdk.pixbuf_new_from_file("/usr/share/maemo-periodic/pixmaps/about.png")
		dialog.set_logo(logo)
		dialog.set_license("This program is released under the GNU General Public License.\nPlease visit http://www.gnu.org/copyleft/gpl.html for details.")

		dialog.run()
		dialog.destroy()

## Window for the elements' properties

class MyDialog(MainWindow):

	def __init__(MainWindow):
		win = hildon.Window()
		win.connect('destroy', gtk.Widget.destroy)
		nelem=sim.index(element)
		win.set_title(nom[nelem])

		swin = gtk.ScrolledWindow()
		swin.set_policy(gtk.POLICY_AUTOMATIC, gtk.POLICY_AUTOMATIC)
		win.add(swin)
		swin.show()


		etiqueta=''

		for i in range(len(titulo)):
			etiqueta+='<b><u>'+titulo[i]+':</u></b>'
			if props[i][nelem] in [' ','-'] or len(props[i][nelem])<1:
				etiqueta+=' N.a.'
			else:
				etiqueta+=' '+props[i][nelem]
				if corresp[i]>=0: 
					etiqueta+=' '+units[corresp[i]]
			etiqueta+='\n'
			

		label = gtk.Label(etiqueta)
		label.set_use_markup(True)
		swin.add_with_viewport(label)
		label.set_justify(gtk.JUSTIFY_CENTER)
		label.show()

		win.show()

## Run app

if __name__ == "__main__":
	app = MainWindow()
	app.run()
