/*
 * Copyright (c) 2004 Jean-Yves Lefort
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of Jean-Yves Lefort nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef _PST_HELPERS_H
#define _PST_HELPERS_H

#include <Python.h>
#define NO_IMPORT_PYGOBJECT
#include <pygobject.h>
#include "streamtuner.h"

typedef struct
{
  PyObject	*object;
  char		*method;
} PSTCallbackInfo;

#define PST_THREADS_ENTER {			\
    PyGILState_STATE _gil_state;		\
    _gil_state = pyg_gil_state_ensure();
#define PST_THREADS_LEAVE			\
    pyg_gil_state_release(_gil_state);		\
}

int		pst_strings_as_gslist     (PyObject	*strings,
					   GSList	**gslist);
PyObject	*pst_strings_from_gslist  (GSList	*gslist);

PyObject	*pst_none                 (void);

PyObject	*pst_string_from_string_or_null	(const char	*str);
PyObject	*pst_string_take_string		(char		*str);
PyObject	*pst_string_take_string_or_null	(char		*str);
int		pst_string_dup_string_or_null	(PyObject	*value,
						 char		**str);

gboolean	pst_categories_sequence_as_gnode   (PyObject	*categories,
						    GNode	**node);
gboolean	pst_streams_sequence_as_glist      (PyObject	*streams,
						    GList	**list);
gboolean	pst_streams_mapping_as_ghashtable  (PyObject	*streams,
						    GHashTable	**hash);

void		pst_set_error             (GError	**err);

int		pst_value_from_pyobject   (GValue	*value,
					   PyObject	*obj);
PyTypeObject	*pst_pygobject_lookup_class (GType	type);

int		pst_convert_widget        (PyObject	*object,
					   GtkWidget	**widget);
GObject		*pst_pygobject_get        (PyObject	*object,
					   GType	type);

#endif /* _PST_HELPERS_H */
