# Copyright (c) 2003-2004 Hyriand. All rights reserved.
#
import gtk
import os
from pynicotine.utils import version
import imagedata

class GenericAboutDialog(gtk.Dialog):
	def __init__(self, parent, title = ""):
		gtk.Dialog.__init__(self, title, parent, gtk.DIALOG_MODAL, (gtk.STOCK_OK, gtk.RESPONSE_OK))
		self.set_resizable(False)
		self.set_position(gtk.WIN_POS_CENTER)
		self.vbox.set_spacing(8)
		self.set_border_width(2)

class AboutDialog(GenericAboutDialog):
	def __init__(self, parent):
		GenericAboutDialog.__init__(self, parent, "About Nicotine")
		img = gtk.Image()
		loader = gtk.gdk.PixbufLoader("png")
		loader.write(imagedata.nicotinen, len(imagedata.nicotinen))
		loader.close()
		pixbuf = loader.get_pixbuf()
		img.set_from_pixbuf(pixbuf)
		label = gtk.Label("""Nicotine %s

Copyright (c) 2003 Hyriand
http://nicotine.thegraveyard.org/
hyriand@thegraveyard.org
Based on code from the PySoulSeek project
Copyright (c) 2001-2003 Alexander Kanavin
Released under the GNU Public License
See MAINTAINERS file for the list of contributors""" % version)
		label.set_justify(gtk.JUSTIFY_CENTER)
		vbox = gtk.VBox()
		vbox.pack_start(img, False, False)
		hbox = gtk.HBox()
		hbox.set_spacing(10)
		hbox.pack_start(vbox, True, True)
		hbox.pack_start(label, True, True)
		self.vbox.pack_start(hbox, True, True)
		self.show_all()

class AboutFiltersDialog():
	def __init__(self, MainWindow):
		
		dlg = gtk.Dialog(title='About search filters', parent=None, flags=gtk.DIALOG_MODAL | gtk.WIN_POS_CENTER)
		dlg.set_border_width(0)
		dlg.set_default_size(500, 300)

		def on_cerrar_clicked(widget):
			dlg.destroy()

		swin = gtk.ScrolledWindow()
		swin.set_policy(gtk.POLICY_AUTOMATIC, gtk.POLICY_AUTOMATIC)
		swin.show()

		label = gtk.Label("""Search filtering

You can use this to refine which results are displayed. The full results from the server are always available if you clear all the search terms.

You can filter by:

Included text: Files are shown if they contain this text. Case is insensitive, but word order is important. 'Spears Brittany' will not show any 'Brittany Spears'

Excluded text: As above, but files will not be displayed if the text matches

Size: Shows results based on size. use > and < to find files larger or smaller. Files exactly the same as this term will always match. Use = to specify an exact match. Use k or m to specify kilo or megabytes. >10M will find files larger than 10 megabytes. <4000k will find files smaller than 4000k.

Bitrate: Find files based on bitrate. Use < and > to find lower or higher. >192 finds 192 and higher, <192 finds 192 or lower. =192 only finds 192. for VBR, the average bitrate is used.

Free slot: Show only those results from users which have at least one upload slot free.

To set the filter, press Enter. This will apply to any existing results, and any more that are returned. To filter in a different way, just set the relevant terms.
You do not need to do another search to apply a different filter.""")

		swin.add_with_viewport(label)
		label.set_justify(gtk.JUSTIFY_LEFT)
		label.set_line_wrap(True)
		label.show()

		hbuttonbox1 = gtk.HButtonBox()
		hbuttonbox1.show()
		hbuttonbox1.set_spacing(0)
		hbuttonbox1.set_border_width(0)
		hbuttonbox1.set_layout(gtk.BUTTONBOX_END)

		button1 = gtk.Button(label="OK", stock=gtk.STOCK_OK)
		button1.show()
		button1.connect("clicked", on_cerrar_clicked)
		hbuttonbox1.pack_start(button1)

		dlg.action_area.pack_start(hbuttonbox1, False, False, 8)
		dlg.vbox.pack_start(swin, True, True, 8)
		
		dlg.show_all()


#class GenericTableDialog(GenericAboutDialog):
#	items = []
#	def __init__(self, parent, title = ""):
#		GenericAboutDialog.__init__(self, parent, title)
#		rows = len(self.items) / 2
#		table = gtk.Table(rows, 2)
#		table.set_col_spacings(5)
#		for i in range(rows):
#			l = gtk.Label(self.items[i*2])
#			l.set_alignment(0.0, 0.5)
#			r = gtk.Label(self.items[i*2+1])
#			r.set_alignment(0.0, 0.5)
#			table.attach(l, 0, 1, i, i+1, xoptions = gtk.FILL|gtk.EXPAND)
#			table.attach(r, 1, 2, i, i+1)
#		self.vbox.pack_start(table)
#		self.show_all()


class AboutRoomsDialog:
	def __init__(self, MainWindow):

		dlg = gtk.Dialog(title='About chat room commands', parent=None, flags=gtk.DIALOG_MODAL | gtk.WIN_POS_CENTER)
		dlg.set_border_width(6)
		dlg.set_default_size(500, 300)

		def on_cerrar_clicked(widget):
			dlg.destroy()

		swin = gtk.ScrolledWindow()
		swin.set_policy(gtk.POLICY_AUTOMATIC, gtk.POLICY_AUTOMATIC)
		swin.show()

		etiqueta = """"/join /j (room)", (Join room 'room')
"/leave /l (room)", (Leave room 'room')
"/part /p (room)", (Leave room 'room')
"/clear /cl", (Clear the chat window)
"/tick /t", (Set your personal ticker)

"/add /ad (user)", (Add user 'user' to your user list)
"/browse /b (user)", (Browse files of user 'user')
"/whois /w (user)", (Request user info for user 'user')
"/ip (user)", (Show IP for user 'user')

"/alias /al (command) + (definition)", (Add a new alias)
"/unalias /un (command), (Remove an alias)

"/ban (user)", (Add user 'user' to your ban list)
"/unban (user)", (Remove user 'user' from your ban list)
"/ignore (user)", (Add user 'user' to your ignore list)
"/unignore (user)", (Remove user 'user' from your ignore list)

"/msg (user) (message)", (Send message 'message' to user 'user')
"/pm (user)", (Open private chat window for user 'user')

"/search /s (query)", (Start a new search for 'query')
"/rsearch /rs (query)", (Search the joined roms for 'query')
"/bsearch /bs (query)", (Search the buddy list for 'query')
"/usearch /us (user) (query)", (Search a user's shares for 'query')

"/rescan", (Rescan shares)
"/away /a", (Toggles your away status)
"/quit /q", (Quit Nicotine)"""

		label = gtk.Label(etiqueta)
		label.set_line_wrap(True)
		swin.add_with_viewport(label)
		label.set_justify(gtk.JUSTIFY_LEFT)
		label.show()

		hbuttonbox1 = gtk.HButtonBox()
		hbuttonbox1.show()
		hbuttonbox1.set_spacing(0)
		hbuttonbox1.set_border_width(0)
		hbuttonbox1.set_layout(gtk.BUTTONBOX_END)

		button1 = gtk.Button(label="OK", stock=gtk.STOCK_OK)
		button1.show()
		button1.connect("clicked", on_cerrar_clicked)
		hbuttonbox1.pack_start(button1)

		dlg.action_area.pack_start(hbuttonbox1, False, False, 8)
		dlg.vbox.pack_start(swin, True, True, 8)
		
		dlg.show_all()


class AboutPrivateDialog:
	def __init__(self, MainWindow):

		dlg = gtk.Dialog(title='About private chat commands', parent=None, flags=gtk.DIALOG_MODAL | gtk.WIN_POS_CENTER)
		dlg.set_border_width(6)
		dlg.set_default_size(500, 300)

		def on_cerrar_clicked(widget):
			dlg.destroy()

		swin = gtk.ScrolledWindow()
		swin.set_policy(gtk.POLICY_AUTOMATIC, gtk.POLICY_AUTOMATIC)
		swin.show()

		etiqueta = """"/close /c", (Close the current private chat)
"/clear /cl", (Clear the chat window)

"/add /ad (user)", (Add user 'user' to your user list)
"/browse /b (user)", (Browse files of user 'user')
"/whois /w (user)", (Request user info for user 'user')
"/ip (user)", (Show IP for user 'user')

"/alias /al (command) + (definition)", (Add a new alias)
"/unalias /un (command)", (Remove an alias)

"/ban (user)", (Add user 'user' to your ban list)
"/unban (user)", (Remove user 'user' from your ban list)
"/ignore (user)", (Add user 'user' to your ignore list)
"/unignore (user)", (Remove user 'user' from your ignore list)

"/search /s (query)", (Start a new search for 'query')
"/rsearch /rs (query)", (Search the joined roms for 'query')
"/bsearch /bs (query")", (Search the buddy list for 'query'),
"/usearch /us (query)", (Search a user's shares for 'query')

"/rescan", (Rescan shares)
"/away /a", (Toggles your away status)
"/quit /q", (Quit Nicotine)"""

		label = gtk.Label(etiqueta)
		label.set_line_wrap(True)
		swin.add_with_viewport(label)
		label.set_justify(gtk.JUSTIFY_LEFT)
		label.show()

		hbuttonbox1 = gtk.HButtonBox()
		hbuttonbox1.show()
		hbuttonbox1.set_spacing(0)
		hbuttonbox1.set_border_width(0)
		hbuttonbox1.set_layout(gtk.BUTTONBOX_END)

		button1 = gtk.Button(label="OK", stock=gtk.STOCK_OK)
		button1.show()
		button1.connect("clicked", on_cerrar_clicked)
		hbuttonbox1.pack_start(button1)

		dlg.action_area.pack_start(hbuttonbox1, False, False, 8)
		dlg.vbox.pack_start(swin, True, True, 8)
		
		dlg.show_all()
