#include "libidea.h"
#include <glib/gprintf.h>
#include <glib.h>
#include <libosso.h>

#include <stdio.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/wait.h>


#define BASE_ICON "/usr/share/pixmaps/idea/"
#define BG_ICON BASE_ICON"bg.png"
/*
enum {
	COL_DISPLAY_NAME,
	COL_PIXBUF,
	NUM_COLS
};
static GtkListStore *store = NULL;
static GdkPixbuf *desk;
*/
static gboolean trans(GtkWidget *widget, int n);
static gboolean detrans(GtkWidget *widget, int v1);
static gboolean theeventcatcher (GtkWidget *widget, GdkEventCrossing *event);
	

static gchar *desk_icon[] = { "/usr/share/pixmaps/idea/terminal.png", "/usr/share/pixmaps/idea/file-manager.png", "/usr/share/pixmaps/idea/browser.png", "/usr/share/pixmaps/idea/email.png", "/usr/share/pixmaps/idea/gaim.png", NULL };
static gchar *desk_trans_icon[] = { "/usr/share/pixmaps/idea/terminal_trans.png", "/usr/share/pixmaps/idea/file-manager_trans.png", "/usr/share/pixmaps/idea/browser_trans.png", "/usr/share/pixmaps/idea/email_trans.png", "/usr/share/pixmaps/idea/gaim_trans.png", NULL };
static gchar *desk_elem[] = { "<span weight=\"bold\" foreground='#FFFFFF'>Xterm</span>", "<span weight=\"bold\" foreground='#FFFFFF'>File Manager</span>","<span weight=\"bold\" foreground='#FFFFFF'>Web</span>", "<span weight=\"bold\" foreground='#FFFFFF'>Email</span>", "<span weight=\"bold\" foreground='#FFFFFF'>IM</span>", NULL };
static gchar *office_elem[] = { "<span weight=\"bold\" foreground='#FFFFFF'>Control Panel</span>", "<span weight=\"bold\" foreground='#FFFFFF'>Application Manager</span>", NULL };
static gchar *office_icon[] = { "/usr/share/pixmaps/idea/cp.png", "/usr/share/pixmaps/idea/pack.png", NULL };
static gchar *office_trans_icon[] = { "/usr/share/pixmaps/idea/cp_trans.png" , "/usr/share/pixmaps/idea/pack_trans.png", NULL };


static GtkWidget *ibox[5];
static GtkWidget *button[5];
static GtkWidget *main_box;
static GMainLoop *loop;
FILE *f;

/*
static void fill_store(GtkListStore *this_store)
{
	GError *error = NULL;
	gtk_list_store_clear (this_store);

	gchar *desk_elem[] = { "Xterm", "File Manager","Web", "Email", "I&M", NULL };*/
/*browser.png  email.png  file-manager.png  terminal.png*//*
	gchar *desk_icon[] = { "/usr/share/pixmaps/idea/terminal.png", "/usr/share/pixmaps/idea/file-manager.png", "/usr/share/pixmaps/idea/browser.png", "/usr/share/pixmaps/idea/email.png", "/usr/share/pixmaps/idea/gaim.png", NULL };
	GtkTreeIter iter;*/
/*	desk = gdk_pixbuf_new_from_file(STD_ICON, &error);*//*
	if ( error ) {
		fprintf(f,"error loading file => %s",error->message);
	}
	int i;
	for(i=0; desk_elem[i] != NULL ; i++)
	{
		desk = gdk_pixbuf_new_from_file(desk_icon[i],&error);
		if ( error ) {
			fprintf(f,"error loading file => %s",error->message);
			exit(0);
		}
		gtk_list_store_append(this_store,&iter);
		gtk_list_store_set(this_store,&iter,COL_DISPLAY_NAME,desk_elem[i],COL_PIXBUF, desk, -1);
	}
}

static GtkListStore * create_store(void)
{
	GtkListStore *store;
	store = gtk_list_store_new (NUM_COLS, G_TYPE_STRING, GDK_TYPE_PIXBUF, G_TYPE_BOOLEAN);
	gtk_tree_sortable_set_sort_column_id (GTK_TREE_SORTABLE (store), GTK_TREE_SORTABLE_DEFAULT_SORT_COLUMN_ID, GTK_SORT_ASCENDING);

	return store;
}
*/

static gboolean
openit(int value)
{
	f = fopen("/tmp/loggerhome","w");
	fprintf (f, "uo puokku  ca semu con value => %d",value);

	osso_context_t *context;
	osso_return_t ret;
	gchar *elem;
	gchar default_dbus_dotpath[64]; /* = "com.nokia.";*/
	gchar default_dbus_path[64]; /* = "/com/nokia/";*/

	default_dbus_dotpath[0] = '\0';
	default_dbus_path[0] = '\0';

	loop = g_main_loop_new(NULL,1);
	context = osso_initialize("start_prg","0.1",0,
				  g_main_loop_get_context(loop));

	if ( context == NULL ) {
		fprintf(f,"context is NULL!!!\n");
		fclose(f);
		return FALSE;
	}

	switch(value) {
		case 0 : elem = "xterm\0";
			 break;
		case 1 : elem = "osso_filemanager\0";
			 break;
		case 2 : elem = "osso_browser\0";
			 break;
		case 3 : elem = "osso_email\0";
			 break;
		case 4 : elem = "osso_voip_ui\0";
			 break;
		default : elem = NULL;
			  break;
	}

	/*g_strlcat (gchar *dest, const gchar *src, gsize dest_size);*/
	g_strlcat(default_dbus_dotpath,"com.nokia.\0",sizeof(default_dbus_dotpath));
	g_strlcat(default_dbus_path,"/com/nokia/\0",sizeof(default_dbus_path));
	g_strlcat(default_dbus_dotpath,elem,sizeof(default_dbus_dotpath));
	g_strlcat(default_dbus_path,elem,sizeof(default_dbus_path));

	fprintf(f,"loading dotpath => %s\n",default_dbus_dotpath);
	fprintf(f,"loading dbuspath => %s\n",default_dbus_path);



	ret = osso_rpc_async_run(context,
				 default_dbus_dotpath, /*"com.nokia.xterm",*/
				 default_dbus_path, /*"/com/nokia/xterm",*/
				 default_dbus_dotpath, /*"com.nokia.xterm",*/
				 "start_app", NULL, NULL,
				 DBUS_TYPE_STRING,
				 "this is the start_app parameter",
				 DBUS_TYPE_INVALID);

	if ( ret != OSSO_OK ) {
		fprintf(f,"returned a not osso_ok!\n");
		fclose(f);
		return FALSE;
	}

	fprintf(f,"all seems ok, closing fucked l00p\n");
	fclose(f);
	osso_deinitialize(context);
/*	g_main_loop_quit(loop);
	g_main_loop_unref(loop);*/
	

	/*trans(0);
	char *cmd[1];
	switch(value) {
		case 0 : cmd[0] = "/usr/bin/osso-xterm";
			 break;
		case 1 : cmd[0] = "/usr/bin/ossofilemanager";
			 break;
		case 2 : cmd[0] = "/usr/bin/browser";
			 break;
		case 3 : cmd[0] = "/usr/bin/ossoemail";
			 break;
		case 4 : cmd[0] = "/usr/bin/osso-voip-ui";
			 break;
		default : cmd[0] = NULL;
			  break;
	}       
	cmd[1] = NULL;
	if ( cmd[0] == NULL ) { 
		return FALSE;
	}       
	if ( fork() == 0 ) {
		execv(cmd[0],cmd);
	}
	detrans(0);
	gtk_button_released(GTK_BUTTON(button[value]));*/
	
	return TRUE;
}


static void
window_destroy (GtkWidget* widget, gpointer data)
{
  gtk_main_quit ();
}

static void
button_clicked (GtkButton* button, gpointer data)
{
  gtk_widget_destroy (GTK_WIDGET (data));
}

GtkWindow *
idea_new (void)
{
  GtkWidget *window, *vbox, *label, *button;

  window = gtk_window_new (GTK_WINDOW_TOPLEVEL);

  gtk_container_set_border_width (GTK_CONTAINER (window), 20);
    
  gtk_window_set_title (GTK_WINDOW (window), "Idea World!");

  g_signal_connect (G_OBJECT (window), "destroy",
		    G_CALLBACK (window_destroy), NULL);

  vbox = gtk_vbox_new (FALSE, 10);
  label = gtk_label_new ("Idea World!");
  button = gtk_button_new_with_label("Close");

  g_signal_connect (G_OBJECT (button), "clicked",
		    G_CALLBACK (button_clicked), window);
    
  gtk_box_pack_start (GTK_BOX(vbox), label, FALSE, FALSE, 0);
  gtk_box_pack_start (GTK_BOX(vbox), button, FALSE, FALSE, 0);
  
  gtk_container_add (GTK_CONTAINER (window), vbox);
  
  gtk_widget_show_all (window);

  return GTK_WINDOW (window);
}

GtkDialog *
idea_dialog_new ()
{
  GtkWidget *dialog;

  dialog = gtk_dialog_new_with_buttons ("Idea World",
					NULL,
					GTK_DIALOG_DESTROY_WITH_PARENT |
					GTK_DIALOG_NO_SEPARATOR,
					"Close",
					GTK_RESPONSE_OK,
					NULL);
  gtk_container_add (GTK_CONTAINER (GTK_DIALOG (dialog)->vbox),
		     gtk_label_new ("Idea World!"));
  gtk_widget_show_all (dialog);

  return GTK_DIALOG (dialog);
}

static gboolean
button_press_callback (GtkWidget *event_box, GdkEventButton *event, gpointer data)
{
	f = fopen("/tmp/loggerhome","w");
	fprintf (f, "callback box click coordinates %f,%f",event->x, event->y);
	fclose(f);
	return FALSE;
}

static gboolean 
detrans(GtkWidget *widget, int v1)
{
	GdkPixbuf *icon;
	GtkWidget *icon_image;
	GtkWidget *label;

	f = fopen("/tmp/loggerhome","w");
	fprintf(f, "detransing with v1=%d\n",v1);
	fclose(f);

	gtk_widget_destroy(GTK_WIDGET(ibox[v1]));
	gtk_widget_destroy(GTK_WIDGET(button[v1]));
	button[v1] = gtk_button_new();
	ibox[v1] = gtk_vbox_new(FALSE,0);
	gtk_button_set_relief(GTK_BUTTON(button[v1]),GTK_RELIEF_NONE);
	gtk_button_set_focus_on_click(GTK_BUTTON(button[v1]),FALSE);
	label = gtk_label_new(NULL);
	gtk_label_set_markup(GTK_LABEL(label),desk_elem[v1]);
	gtk_label_set_justify(GTK_LABEL(label),GTK_JUSTIFY_CENTER);
	icon = gdk_pixbuf_new_from_file_at_size(desk_icon[v1],48,48,NULL);
	icon_image = gtk_image_new_from_pixbuf(icon);
	gtk_box_pack_start(GTK_BOX(ibox[v1]), icon_image, FALSE, FALSE, 0);
	gtk_box_pack_start(GTK_BOX(ibox[v1]), label, FALSE, FALSE, 0);
	gtk_container_add(GTK_CONTAINER(button[v1]), ibox[v1]);
	g_signal_connect(button[v1],"pressed",G_CALLBACK(trans), (gpointer) v1);
	g_signal_connect(button[v1],"released",G_CALLBACK(detrans), (gpointer) v1);
/*	gtk_signal_connect(GTK_OBJECT(button[0]), "leave", GTK_SIGNAL_FUNC(trans), (gpointer) v1);
	gtk_signal_connect(GTK_OBJECT(button[0]), "enter", GTK_SIGNAL_FUNC(detrans), (gpointer) v1);
	gtk_signal_connect(GTK_OBJECT(button[0]), "clicked", GTK_SIGNAL_FUNC(trans), (gpointer) v1);
	gtk_signal_connect(GTK_OBJECT(button[0]), "released", GTK_SIGNAL_FUNC(detrans), (gpointer) v1);
	gtk_signal_connect(GTK_OBJECT(button[0]), "pressed", GTK_SIGNAL_FUNC(openit), (gpointer) v1);
	gtk_signal_connect(GTK_OBJECT(button[0]), "released", GTK_SIGNAL_FUNC(openit), (gpointer) v1);*/
	g_signal_connect(button[v1], "enter", G_CALLBACK(theeventcatcher), NULL);
	gtk_table_attach_defaults(GTK_TABLE(main_box), button[v1], v1 , v1 + 1, 0, 1 );
	gtk_widget_show_all(GTK_WIDGET(main_box));
	openit(v1);
	return TRUE;
										
}
static gboolean
trans(GtkWidget *widget,int n)
{
	 f = fopen("/tmp/loggerhome","w");
	 fprintf (f, "transparentig mm...with n=%d\n",n);
	 fclose(f);
	/* if ( n == 0 ) {*/
		GdkPixbuf *icon;
		GtkWidget *icon_image;
		GtkWidget *label;

		gtk_widget_destroy(GTK_WIDGET(ibox[n]));
		gtk_widget_destroy(GTK_WIDGET(button[n]));
		button[n] = gtk_button_new();
		ibox[n] = gtk_vbox_new(FALSE,0);
		gtk_button_set_relief(GTK_BUTTON(button[n]),GTK_RELIEF_NONE);
		gtk_button_set_focus_on_click(GTK_BUTTON(button[n]),FALSE);
		/* xterm trans */
		label = gtk_label_new(NULL);
		gtk_label_set_markup(GTK_LABEL(label),desk_elem[n]);
		gtk_label_set_justify(GTK_LABEL(label),GTK_JUSTIFY_CENTER);
		icon = gdk_pixbuf_new_from_file_at_size(desk_trans_icon[n],48,48,NULL);
		icon_image = gtk_image_new_from_pixbuf(icon);
		gtk_box_pack_start(GTK_BOX(ibox[n]), icon_image, FALSE, FALSE, 0);
		gtk_box_pack_start(GTK_BOX(ibox[n]), label, FALSE, FALSE, 0);
		gtk_container_add(GTK_CONTAINER(button[n]), ibox[n]);
		g_signal_connect(button[n],"pressed",G_CALLBACK(trans), (gpointer) n);
		g_signal_connect(button[n],"released",G_CALLBACK(detrans), (gpointer) n);
/*		gtk_signal_connect(GTK_OBJECT(button[0]), "leave", GTK_SIGNAL_FUNC(trans), (gpointer) n);
		gtk_signal_connect(GTK_OBJECT(button[0]), "enter", GTK_SIGNAL_FUNC(detrans), (gpointer) n);
		gtk_signal_connect(GTK_OBJECT(button[0]), "released", GTK_SIGNAL_FUNC(trans), (gpointer) n);
		gtk_signal_connect(GTK_OBJECT(button[0]), "enter", GTK_SIGNAL_FUNC(detrans), (gpointer) n);
		gtk_signal_connect(GTK_OBJECT(button[0]), "pressed", GTK_SIGNAL_FUNC(openit), (gpointer) n);
		gtk_signal_connect(GTK_OBJECT(button[0]), "released", GTK_SIGNAL_FUNC(openit), (gpointer) n);*/
		g_signal_connect(button[n], "enter", G_CALLBACK(theeventcatcher), NULL);
		gtk_table_attach_defaults(GTK_TABLE(main_box), button[n], n, n + 1, 0, 1 );
		gtk_widget_show_all(GTK_WIDGET(main_box));
		return TRUE;
		/*
		int i;
		gtk_box_pack_start(GTK_BOX(main_box), button[n], FALSE, FALSE, 0);
		for(i=0; i < 5; i++ ) {
			fprintf(f,"\npackgin it i=%d",i);
			gtk_box_pack_start(GTK_BOX(main_box), button[i], FALSE, FALSE, 0);
		}*/
/*		gtk_widget_show(GTK_WIDGET(box));*/
/*
		return TRUE;
	}
	return TRUE;*/
}


static gboolean 
theeventcatcher (GtkWidget *widget, GdkEventCrossing *event)
{
	GtkButton *button;
	GtkWidget *event_widget;

	/*gtk_widget_modify_bg(GTK_WIDGET(l0),GTK_STATE_NORMAL,&((GdkColor) { 0, 0x0000, 0x0000, 0xffff } ));*/
	button = GTK_BUTTON (widget);
	event_widget = gtk_get_event_widget ((GdkEvent*) event);
	button->in_button = FALSE;
	gtk_button_leave (button);
	return FALSE;
}
/*static void closed(const gchar *interface, const gchar *method,osso_rpc_t *retval, gpointer data)
{
	FILE *f;
	f = fopen("/tmp/loggerhome","w");
	fprintf (f, "gloop closed on interface %s", interface);
	fclose(f);
	g_main_loop_quit(loop);
	return TRUE;
}
*/

void
idea_dialog_show ()
{
  GtkWidget *dialog = GTK_WIDGET(idea_dialog_new ());
  gtk_dialog_run (GTK_DIALOG(dialog));
  gtk_widget_destroy (dialog);
}

GtkWidget *
idea_button_new (int padding)
{
	f = fopen("/tmp/loggerhome","w");
	
	GdkPixbuf *icon;
	GtkWidget *icon_image;
	GtkWidget *app_table;
	GtkWidget *sys_table;
/*	GtkWidget *ibox[5];*/
/*	GtkWidget *button[5];*/
	GtkWidget *label[5];
/*	GtkWidget *main_box;*/
	int i;
	
	fprintf (f, "here ok! with padding %d",padding);
	fclose(f);

	main_box = gtk_table_new(2,1,FALSE); /* gtk_hbox_new(FALSE,5);*/
	app_table = gtk_table_new(1,5,FALSE);
	gtk_table_set_homogeneous(GTK_TABLE(main_box), FALSE);
	gtk_table_set_row_spacings(GTK_TABLE(main_box),5);
	gtk_table_set_col_spacings(GTK_TABLE(app_table),1);
	for(i=0; desk_elem[i] != NULL;i++) {
		button[i] = gtk_button_new();
		gtk_button_set_relief(GTK_BUTTON(button[i]),GTK_RELIEF_NONE);
		gtk_button_set_focus_on_click(GTK_BUTTON(button[i]),FALSE);
/*		gtk_button_set_use_stock(GTK_BUTTON(button[i]),FALSE);*/
		ibox[i] = gtk_vbox_new(FALSE,0);
		icon = gdk_pixbuf_new_from_file_at_size(desk_icon[i],48,48,NULL);
		icon_image = gtk_image_new_from_pixbuf(icon);
		label[i] = gtk_label_new(NULL);
		gtk_label_set_markup(GTK_LABEL(label[i]),desk_elem[i]);
		gtk_label_set_justify(GTK_LABEL(label[i]),GTK_JUSTIFY_CENTER);
		gtk_box_pack_start(GTK_BOX(ibox[i]), icon_image, FALSE, FALSE, 0);
		gtk_box_pack_start(GTK_BOX(ibox[i]), label[i], FALSE, FALSE, 0);
		gtk_container_add(GTK_CONTAINER(button[i]), ibox[i]);
		g_signal_connect(button[i],"pressed",G_CALLBACK(trans), (gpointer) i);
		g_signal_connect(button[i],"released",G_CALLBACK(detrans), (gpointer) i);
/*		gtk_signal_connect(GTK_OBJECT(button[i]), "leave", GTK_SIGNAL_FUNC(trans), (gpointer) i);
		gtk_signal_connect(GTK_OBJECT(button[i]), "enter", GTK_SIGNAL_FUNC(detrans), (gpointer) i);
		gtk_signal_connect(GTK_OBJECT(button[i]), "clicked", GTK_SIGNAL_FUNC(trans), (gpointer) i);
		gtk_signal_connect(GTK_OBJECT(button[i]), "released", GTK_SIGNAL_FUNC(detrans), (gpointer) i);*/
		g_signal_connect(button[i], "enter", G_CALLBACK(theeventcatcher), NULL);
		gtk_table_attach_defaults(GTK_TABLE(app_table), button[i], i, i + 1, 0, 1 );
/*	        fprintf(f,"added item with label=%s icon=%s\n",desk_elem[i],desk_icon[i]);	
											   
		gtk_box_pack_start(GTK_BOX(main_box), button[i], FALSE, FALSE, 0);
		gtk_container_add(GTK_CONTAINER(main_box) , button[i]);*/
	}
	gtk_table_attach_defaults(GTK_TABLE(main_box), app_table, 0,1,0,1);
	sys_table = gtk_table_new(1,5,FALSE);
	gtk_table_set_col_spacings(GTK_TABLE(sys_table),1);
	for ( i=0; office_elem[i] != NULL; i++) {
		button[i] = gtk_button_new();
		gtk_button_set_relief(GTK_BUTTON(button[i]),GTK_RELIEF_NONE);
		gtk_button_set_focus_on_click(GTK_BUTTON(button[i]),FALSE);
		ibox[i] = gtk_vbox_new(FALSE,0);
		icon = gdk_pixbuf_new_from_file_at_size(office_icon[i],48,48,NULL);
		icon_image = gtk_image_new_from_pixbuf(icon);
		label[i] = gtk_label_new(NULL);
		gtk_label_set_markup(GTK_LABEL(label[i]),office_elem[i]);
		gtk_label_set_justify(GTK_LABEL(label[i]),GTK_JUSTIFY_CENTER);
		gtk_box_pack_start(GTK_BOX(ibox[i]), icon_image, FALSE, FALSE, 0);
		gtk_box_pack_start(GTK_BOX(ibox[i]), label[i], FALSE, FALSE, 0);
		gtk_container_add(GTK_CONTAINER(button[i]), ibox[i]);
		g_signal_connect(button[i],"pressed",G_CALLBACK(trans), (gpointer) i);
		g_signal_connect(button[i],"released",G_CALLBACK(detrans), (gpointer) i);
		g_signal_connect(button[i], "enter", G_CALLBACK(theeventcatcher), NULL);
		gtk_table_attach_defaults(GTK_TABLE(sys_table), button[i], i, i + 1, 0, 1 );
	}
	gtk_table_attach_defaults(GTK_TABLE(main_box), sys_table, 0,1,1,2);
		
  	gtk_widget_show_all (main_box);


      	return main_box;
}
