#include <stdio.h>
#include <string.h>
#include <libxml/encoding.h>
#include <libxml/xmlwriter.h>
#include <gtk/gtk.h>

#define MY_ENCODING "UTF-8"

void
check_rc(int v)
{
	FILE *f = fopen("/tmp/checkrc","a+");
	if ( v < 0 ) {
		fprintf(f,"testXmlwriterFilename: Error at xmlTextWriterStartDocument\n");
		fclose(f);
		return;
	}
}
		

void
XmlWriteInfo(const char *uri,
		gint *size, 
		gchar *nname[],
		gint i_rows,
		gint *ticon,
		gchar *color,
		gchar *iname[],
		gint *cell_spacing, 
		gint *row_spacing,
		gchar *weight, 
		gchar *style,
		gchar *fsize,
		gint *visible,
		gchar *app[])
{

	int rc;
	xmlTextWriterPtr writer;
	xmlChar *tmp;
	FILE *f = fopen("/tmp/XMLWRITERLOG","a+");

	writer = xmlNewTextWriterFilename(uri, 0);
	if ( writer == NULL ) {
		fprintf(f,"testXmlwriterFilename: Error creating the xml writer\n");
		fclose(f);
		return;
	}

	rc = xmlTextWriterStartDocument(writer, NULL, MY_ENCODING, NULL);
	check_rc(rc);

	rc = xmlTextWriterStartElement(writer, BAD_CAST "idea");
	check_rc(rc);
	
	rc = xmlTextWriterStartElement(writer, BAD_CAST "icon");
	check_rc(rc);

	rc = xmlTextWriterWriteFormatElement(writer, BAD_CAST "size","%d", size);
	check_rc(rc);

	gint i;
	for(i=0;i<ticon;i++) {
		rc = xmlTextWriterWriteFormatElement(writer, BAD_CAST "icon_name","%s", nname[i]);
		check_rc(rc);
	}
	/*for(i=0;i<ticon;i++) {
		rc = xmlTextWriterWriteFormatElement(writer, BAD_CAST "trans_name","%s",tname[i]);
		check_rc(rc);
	}*/

	rc = xmlTextWriterEndElement(writer);
	check_rc(rc);
	/*end icon */
	/*start table */
	rc = xmlTextWriterStartElement(writer, BAD_CAST "table");
	check_rc(rc);
	
	rc = xmlTextWriterWriteFormatElement(writer, BAD_CAST "tot_icon","%d",ticon);
	check_rc(rc);

	rc = xmlTextWriterWriteFormatElement(writer, BAD_CAST "icon_row","%d",i_rows);
	check_rc(rc);
	
	rc = xmlTextWriterWriteFormatElement(writer, BAD_CAST "cell_spacing","%d",cell_spacing);
	check_rc(rc);
	
	rc = xmlTextWriterWriteFormatElement(writer, BAD_CAST "row_spacing","%d",row_spacing);
	check_rc(rc);
	
	rc = xmlTextWriterEndElement(writer);
	/*end table*/
	/*start label */
	rc = xmlTextWriterStartElement(writer, BAD_CAST "label");
	check_rc(rc);
	
	rc = xmlTextWriterWriteFormatElement(writer, BAD_CAST "visible", "%d", visible);
	check_rc(rc);
	
	rc = xmlTextWriterWriteFormatElement(writer, BAD_CAST "weight", "%s", weight);
	check_rc(rc);
	
	rc = xmlTextWriterWriteFormatElement(writer, BAD_CAST "style", "%s", style);
	check_rc(rc);
	
	rc = xmlTextWriterWriteFormatElement(writer, BAD_CAST "fsize","%s",fsize);
	check_rc(rc);
	
	rc = xmlTextWriterWriteFormatElement(writer, BAD_CAST "color","%s",color);
	check_rc(rc);

	for(i=0;i<ticon;i++) {
		rc = xmlTextWriterWriteFormatElement(writer, BAD_CAST "name","%s", iname[i]);
		check_rc(rc);
	}
	rc = xmlTextWriterEndElement(writer);
	/*end label*/
	/*start application*/
	rc = xmlTextWriterStartElement(writer, BAD_CAST "application");
	check_rc(rc);
	
	for(i=0;i<ticon;i++) {
		rc = xmlTextWriterWriteFormatElement(writer, BAD_CAST "app","%s", app[i]);
		check_rc(rc);
	}
	rc = xmlTextWriterEndElement(writer);
	/*end application*/
	

	rc = xmlTextWriterEndDocument(writer);
	/*end all*/

	xmlFreeTextWriter(writer);
}
