/*
 *
 * control panel applet for idea.
 *
 */

#include <hildon-cp-plugin/hildon-cp-plugin-interface.h>
#include <hildon-widgets/hildon-program.h>
#include <hildon-widgets/hildon-file-chooser-dialog.h>
#include <hildon-widgets/hildon-font-selection-dialog.h>
#include <libosso.h>
#include <stdio.h>
#include <dirent.h>
#include <string.h>
#include <gtk/gtk.h>

#include "libidea.h"


static GtkWidget *size_icon_combo;
static GtkWidget *tot_icon_spin;
static GtkWidget *spin1;
static GtkWidget *spin2;
static GtkWidget *spin3;
static GtkWidget *button[MAX_ICON];
static GtkWidget *ientry[MAX_ICON];
static GtkWidget *ivbox[MAX_ICON];
static GtkWidget *icon_hbox;
static gint icon_size = 48; /*by default */
static GdkPixbuf *icon[MAX_ICON];
static GtkWidget *icon_image[MAX_ICON];
static gchar *icon_buff[MAX_ICON];
static GtkWidget *chdialog;
static gchar *font_size[] = { "xx-small", "x-small", "small", "medium", "large","x-large","xx-large",NULL }; 
static GtkWidget *bcheck;
static GtkWidget *icheck;
static GtkWidget *ccbox;
static GtkWidget *buttonC;
static GtkWidget *vbutt;

static GtkTreeModel *model;
static GtkTreeView *treeview;
static GtkCellRenderer *renderer;
static GtkTreeViewColumn *column;
static GtkWidget *sw;
static GtkWidget *table;
		

static gint save_row;
static gchar *save_label[MAX_ICON];
static gchar *save_img[MAX_ICON];

static gboolean icon_url(GtkWidget *widget, int i);
void parseDoc(char *docname);
GtkWidget*  hildon_color_button_new_with_color (const GdkColor *color);


enum
{
	COL_POS,
	COL_ICON,
	COL_PROG,
	COL_DEFAULT_ICON,
	NUM_COLS
};

static GtkTreeModel *
create_model (void)
{
	FILE *f = fopen("/tmp/model","a+");
	fprintf(f,"creating modell ... \n");
	gint i = 0;
	GtkListStore *store;
	GtkTreeIter iter;
	
	store = gtk_list_store_new(NUM_COLS,
				   G_TYPE_INT,
				   G_TYPE_STRING,
				   G_TYPE_STRING,
				   G_TYPE_BOOLEAN);
	for(i=0;i<ticon;i++) {
		gtk_list_store_append(store,&iter);
		fprintf(f,"adding at %d iname=%s,app=%s\n",i,iname[i],app[i]);
		gtk_list_store_set(store,&iter, COL_POS, i, COL_ICON, iname[i], COL_PROG, app[i], COL_DEFAULT_ICON, FALSE, -1);
	}
	fclose(f);
	return GTK_TREE_MODEL(store);
}

static gboolean
build_d_button()
{
	gint i;
	guint val;
	val = get_icon_num();
	FILE *f = fopen("/tmp/build_d_button_","a+");
	fprintf(f,"val is => %d and i_rows => %d ant ticon =>%d \n",val,i_rows,gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(tot_icon_spin)));
	if ( icon_hbox ) { gtk_widget_destroy(GTK_WIDGET(icon_hbox)); }
	icon_hbox = gtk_vbox_new(FALSE,val);
	gint tot_rows = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(tot_icon_spin)) / i_rows;
	int checkpoint = i_rows;
	int y=0;
	if ( (ticon%i_rows) != 0 ) tot_rows++;
	//GtkWidget *tvbox[tot_rows+1];
	GtkWidget *thbox[tot_rows+1];
	//main_box = gtk_vbox_new(FALSE,val);
	fprintf(f,"write on tot_rows=%d and checkpoint=%d\n",tot_rows,checkpoint);
	for(i=0;i<tot_rows+1;i++)
	{
		thbox[i] = gtk_hbox_new(FALSE,val);
		for(;y<checkpoint&&y<val;y++) {
			ivbox[y] = gtk_vbox_new(FALSE,val);
			ientry[y] = gtk_entry_new();
			if ( icon_buff[y] != NULL ) {
				button[y] = gtk_button_new();
				icon[y] = gdk_pixbuf_new_from_file_at_size(icon_buff[y],icon_size,icon_size,NULL);
				icon_image[y] = gtk_image_new_from_pixbuf(icon[y]);
				gtk_container_add(GTK_CONTAINER(button[y]),icon_image[y]);
			} else {
				button[y] = gtk_button_new(); //_with_label("Click to set an icon.");
				icon[y] = gdk_pixbuf_new_from_file_at_size(nname[y],size,size,NULL);
				icon_image[y] = gtk_image_new_from_pixbuf(icon[y]);
				gtk_container_add(GTK_CONTAINER(button[y]), icon_image[y]);
				gtk_entry_set_text(GTK_ENTRY(ientry[y]),iname[y]);
			}
			gtk_widget_set_usize(GTK_WIDGET(button[y]),65,65);
			gtk_widget_set_usize(GTK_WIDGET(ientry[y]),65,30);
			/* on click load icon!*/
			g_signal_connect(button[y], "clicked", G_CALLBACK(icon_url), (gpointer) y);
			gtk_box_pack_start(GTK_BOX(ivbox[y]), button[y], FALSE, FALSE, 0);
			gtk_box_pack_start(GTK_BOX(ivbox[y]), ientry[y], FALSE, FALSE, 0);
			fprintf(f,"adding on tvbox[%d], ivobx[%d]\n",i,y);
			gtk_box_pack_start(GTK_BOX(thbox[i]), ivbox[y], FALSE, FALSE, 0);
		}
		checkpoint=checkpoint + i_rows;
		fprintf(f,"saving on hbox tvbox[%d]\n",i);
		gtk_box_pack_start(GTK_BOX(icon_hbox), thbox[i], FALSE, FALSE, 0);
			/*
			gtk_box_pack_start(GTK_BOX(ivbox[i]), button[i], FALSE, FALSE, 0);
			gtk_box_pack_start(GTK_BOX(ivbox[i]), ientry[i], FALSE, FALSE, 0);
			gtk_box_pack_start(GTK_BOX(hbox), ivbox[i], FALSE, FALSE, 0);
		} else {
			gtk_box_pack_start(GTK_BOX(ivbox[i-i_rows]), button[i], FALSE, FALSE, 0);
			gtk_box_pack_start(GTK_BOX(ivbox[i-i_rows]), ientry[i], FALSE, FALSE, 0);
			gtk_box_pack_start(GTK_BOX(hbox), ivbox[i-i_rows], FALSE, FALSE, 0);
		}*/
			
		
	}
	fclose(f);	

	return TRUE;
}


static gboolean
icon_url(GtkWidget *widget, int i)
{
	GtkWidget *dialog;
	gchar *filename = NULL;
	gint response;

	dialog = hildon_file_chooser_dialog_new(GTK_WINDOW(widget), GTK_FILE_CHOOSER_ACTION_OPEN);

	gtk_widget_show_all(GTK_WIDGET(dialog));

	response = gtk_dialog_run(GTK_DIALOG(dialog));
	if (  response == GTK_RESPONSE_OK ) {
		filename = gtk_file_chooser_get_filename(GTK_FILE_CHOOSER(dialog));
	} else if ( response == GTK_RESPONSE_CANCEL ) {
		gtk_widget_destroy(GTK_WIDGET(dialog));
		return FALSE;
	}
	if ( filename != NULL ) {
		FILE *f;
		f = fopen("/tmp/loggercp","w");
		switch ( gtk_combo_box_get_active(GTK_COMBO_BOX(size_icon_combo)) ) {
			case 0 : icon_size = 16;
				 break;
			case 1 : icon_size = 24;
				 break;
			case 2 : icon_size = 32;
				 break;
			case 3 : icon_size = 48;
				 break;
			case 4 : icon_size = 64;
				 break;
		}
		icon_buff[i] = filename;
		fprintf(f,"IMage is=%s w=%d and h=%d number=%d\n",filename,icon_size,icon_size,i);
		fclose(f);
	} else {
		gtk_widget_destroy(GTK_WIDGET(dialog));
		return FALSE;
	}

	build_d_button();
	gtk_widget_destroy(GTK_WIDGET(dialog));
	
	return TRUE;
}

static gint
get_icon_num()
{
	return gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(tot_icon_spin));
}

static gboolean
update_size()
{
	switch ( gtk_combo_box_get_active(GTK_COMBO_BOX(size_icon_combo)) ) {
		case 0 : icon_size = 16;
			 break;
		case 1 : icon_size = 24;
			 break;
		case 2 : icon_size = 32;
			 break;
		case 3 : icon_size = 48;
			 break;
		case 4 : icon_size = 64;
			 break;
		default : icon_size = 48;
			break;
	}
	return TRUE;
}

static gboolean
choose_app(GtkWidget *widget)
{
	GtkWidget *dialog;
	GtkTreeIter iter;
	GtkTreeModel *model;
	GtkTreeSelection *selection;
	GList *list,*node;
	GtkWidget *hbox;
	GtkWidget *label;
	GtkWidget *label0;
	GtkWidget *label1;
	GtkWidget *v_box;
	GtkWidget *combo;
	GtkWidget *check0;
	gint response;
	GDir *d;
	
	gchar composed_string[4096];
	gchar save_l[64];
	gchar save_p[255];
	gint savepos;
	gboolean save_def_icon;
	FILE *f = fopen("/tmp/BAU","a+");
	model = gtk_tree_view_get_model(treeview);
	fprintf(f,"model not fail :)\n");
	
	
	selection = gtk_tree_view_get_selection (treeview);
	list = gtk_tree_selection_get_selected_rows(selection,&model);
	for (node = list; node; node = g_list_next(node)) 
	{
		gint *pos;
		gchar *i,*p;
		gboolean *def_icon;
		GtkTreeIter iter;
		GtkTreePath *path = node->data;
		gtk_tree_model_get_iter(model, &iter, path);
		gtk_tree_model_get(model,
				   &iter, 
				   0, &pos,
				   1, &i,
				   2, &p,
				   3, &def_icon,
				   -1);
		if ( i != NULL ) {
			g_snprintf(save_l,64,"%s",i);
			g_snprintf(composed_string,4096,"Choose the application to associate to the icon <b>%s</b>",i);
			g_snprintf(save_p,255,"%s",p);
			savepos = pos;
			save_def_icon = def_icon;
		}
		fprintf (f,"The row containing the iname '%s' and pname '%s' has been double-clicked.\n", i,p);	
	
		g_free(i);
		g_free(p);
		gtk_tree_path_free(path);
	}
	
	g_list_free(list);
	g_list_free(node);
	
	dialog = gtk_dialog_new();
	gtk_dialog_add_buttons(GTK_DIALOG(dialog),
				GTK_STOCK_OK,
				GTK_RESPONSE_OK,
				GTK_STOCK_CANCEL,
				GTK_RESPONSE_CANCEL,
				NULL);
	gtk_window_set_title(GTK_WINDOW(dialog), "Icon Association");
	v_box = gtk_vbox_new(TRUE,5);
	hbox = gtk_hbox_new(TRUE,2);
	label = gtk_label_new(NULL);
	gtk_label_set_markup(GTK_LABEL(label),composed_string);
	
	gtk_box_pack_start(GTK_BOX(hbox), label, FALSE,FALSE, 0);
	gtk_box_pack_start(GTK_BOX(v_box), hbox, FALSE,FALSE, 0);
	
	hbox = gtk_hbox_new(TRUE,5);
	label = gtk_label_new("Number");
	label0 = gtk_label_new("Program Name");
	label1 = gtk_label_new("Use default Icon");
	gtk_box_pack_start(GTK_BOX(hbox), label, FALSE,FALSE, 0);
	gtk_box_pack_start(GTK_BOX(hbox), label0, FALSE,FALSE, 0);
	gtk_box_pack_start(GTK_BOX(hbox), label1, FALSE,FALSE, 0);
	gtk_box_pack_start(GTK_BOX(v_box), hbox, FALSE,FALSE, 0);
	
	hbox = gtk_hbox_new(TRUE,5);
	
	char tmp[64];
	g_snprintf(tmp,64,"Number : <b>%d</b>",savepos);
	label = gtk_label_new(NULL);
	gtk_label_set_markup(GTK_LABEL(label),tmp);
	
	combo = gtk_combo_box_new_text();
	gtk_combo_box_append_text(GTK_COMBO_BOX(combo),save_p);
	gtk_combo_box_set_active(GTK_COMBO_BOX(combo),0);
	d = g_dir_open("/usr/share/applications/hildon/",0,NULL);
	if ( d ) {
		const gchar *file;
		while (( file = g_dir_read_name(d)) ) {
			char *str;
			str = strtok(file,".");
			fprintf(f,"save => %s\n",str);
			gtk_combo_box_append_text(GTK_COMBO_BOX(combo),str);
		}
	}
	
	check0 = gtk_check_button_new ();
	if ( save_def_icon ) {
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check0), TRUE);
	}
	gtk_box_pack_start(GTK_BOX(hbox), label, FALSE,FALSE, 0);
	gtk_box_pack_start(GTK_BOX(hbox), combo, FALSE,FALSE, 0);
	gtk_box_pack_start(GTK_BOX(hbox), check0, FALSE,FALSE, 0);
	gtk_box_pack_start(GTK_BOX(v_box), hbox, FALSE,FALSE, 0);
	
	gtk_container_add(GTK_CONTAINER(GTK_DIALOG(dialog)->vbox), v_box);
	
	gtk_widget_show_all(GTK_WIDGET(dialog));
	response = gtk_dialog_run(GTK_DIALOG(dialog));
	if ( response == GTK_RESPONSE_OK ) {
//		fprintf(f,"program name =>%s\n",save_file_elem_at[gtk_combo_box_get_active(GTK_COMBO_BOX(combo))]);
		fprintf(f,"getted elem at %d labelname =>%s new prog at => %s default icons %d\n",savepos,save_l,gtk_combo_box_get_active_text (GTK_COMBO_BOX(combo)),gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(check0)));
		app[savepos] = gtk_combo_box_get_active_text(GTK_COMBO_BOX(combo));
		if ( gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(check0)) ) {
			fprintf(f,"default icon on\n");
			gchar file_tmp[128];
			gchar ic[64];
			char read_buffer[4096];
			g_snprintf(file_tmp,128,"/usr/share/applications/hildon/%s.desktop",gtk_combo_box_get_active_text(GTK_COMBO_BOX(combo)));
			fprintf(f,"file is => %s\n",file_tmp);
			FILE *fi = fopen(file_tmp,"r");
			while(fgets(read_buffer,4096,fi) != NULL ) {
					if ( strncmp(read_buffer,"Icon=", 5) == 0 ) {
						g_snprintf(ic,sizeof(ic),"%s",read_buffer + 5);
						fprintf(f,"saved icon is => %s\n",ic);
					}
			}
			fclose(fi);
			GtkIconTheme *git;
			gboolean res;
			char *c;
			c = strstr(ic,"\n");
			while (c != NULL ) {
				c[0] = ' ';
				c = strstr(++c,"\n");
			}
			const gchar *the_icon;
			the_icon = g_strchomp(ic);
			res = gtk_icon_theme_has_icon(gtk_icon_theme_new(),the_icon);
			if ( res ) {
				nname[savepos] = g_strdup(the_icon);
				fprintf(f,"%s checked!\n",ic);
			} else {
				fprintf(f,"%s not ;(\n",ic);
			}
		} else {
			fprintf(f,"not default icon\n");
		}
		XmlWriteInfo("/home/user/.idea/idea.xml",
				icon_size,
				nname,  
				i_rows,
				ticon,
				color,
				iname,
				cell_spacing,
				row_spacing,
				weight,
				style,
				fsize,
				visible,
				app);
		refresh_value(NULL);
	}
	gtk_widget_destroy(GTK_WIDGET(dialog));

	fclose(f);

	
	return TRUE;
}

static gboolean
save_icons_settings()
{
	/* save icons settings 
	* like , size,url,entry etc.. */
	FILE *f = fopen("/tmp/IWRITEIT","a+");
	update_size();
	save_row = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(tot_icon_spin));
	fprintf(f,"scrivo size=>%d\nicon size=%d\n",gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(tot_icon_spin)),icon_size);
	fprintf(f,"exaclty => \nROWS=%d\tLABEL[0]=%s\tIMG[0]=%s\n",save_row,save_label[0],save_img[0]);
	fprintf(f,"now see=>%s",gtk_entry_get_text(GTK_ENTRY(ientry[0])));
	if ( save_label[0] == NULL && save_img[0] == NULL ) {
		XmlWriteInfo("/home/user/.idea/idea.xml",
			icon_size,
			nname,
			i_rows,
			gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(tot_icon_spin)),
			color,
			iname,
			cell_spacing,
			row_spacing,
			weight,
			style,
			fsize,
			visible,
			app);
	} else {
		XmlWriteInfo("/home/user/.idea/idea.xml",
			icon_size,
			save_img,
			i_rows,
			gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(tot_icon_spin)),
			color,
			save_label,
			cell_spacing,
			row_spacing,
			weight,
			style,
			fsize,
			visible,
			app);
	}
		
	
	fclose(f);
	return TRUE;
}

static gboolean
save_table_settings()
{
	FILE *f = fopen("/tmp/tablesettings","a+");
	i_rows = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(spin1));
	row_spacing = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(spin2));
	cell_spacing = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(spin3));
	fprintf(f,"saving : i_rows=%d\tr_s=%d\tc_s=%d\n",gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(spin1)),gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(spin2)),gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(spin3)));
	fclose(f);
	/*5 8 9 13 */
	XmlWriteInfo("/home/user/.idea/idea.xml",
			size,
			nname,
			i_rows,
			ticon,
			color,
			iname,
			cell_spacing,
			row_spacing,//gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(spin2)),
			weight,
			style,
			fsize,
			visible,
			app);
	return TRUE;
	
}

static gboolean 
set_icon()
{
	gint val;
	gint response;
	GtkWidget *swindow;

	val = get_icon_num();

	chdialog = gtk_dialog_new();
	gtk_window_set_title(GTK_WINDOW(chdialog), "Set ICON");
	gtk_dialog_add_buttons(GTK_DIALOG(chdialog),
				GTK_STOCK_OK, GTK_RESPONSE_OK,
				GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL,
				NULL);
	
	gtk_widget_set_usize(GTK_WIDGET(chdialog), 250,250);

	build_d_button();
	
	swindow = gtk_scrolled_window_new(NULL,NULL);
	gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(swindow), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);

	gtk_scrolled_window_add_with_viewport(GTK_SCROLLED_WINDOW(swindow), icon_hbox);

	gtk_container_add(GTK_CONTAINER(GTK_DIALOG(chdialog)->vbox), swindow);

	gtk_widget_show_all(chdialog);

	response = gtk_dialog_run(GTK_DIALOG(chdialog));
	if ( response == GTK_RESPONSE_OK ) {
		FILE *f = fopen("/tmp/SET","a+");
		gint i;
		for(i=0;i<get_icon_num();i++) {
			save_label[i] = g_strdup(gtk_entry_get_text(GTK_ENTRY(ientry[i])));
			if ( icon_buff[i] == NULL ) {
				save_img[i] = nname[i];
			} else {
				save_img[i] = icon_buff[i];
			}
			fprintf(f,"entry at %d is %s image is %s\n",i,save_label[i],save_img[i]);
		}
		fclose(f);

		gtk_widget_destroy(GTK_WIDGET(chdialog));
		return TRUE;
	} else {
		gtk_widget_destroy(GTK_WIDGET(chdialog));
		return TRUE;
	}
	gtk_widget_destroy(GTK_WIDGET(chdialog));
	
	return TRUE;
}



static gboolean
save_label_settings()
{
	/* here we save 
	 * @bold,italic,color,size
	 *
	 */
	gint vis;
	FILE *f = fopen("/tmp/LABINFO","a+");
	if ( gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(bcheck)) ) {
		weight = "bold";
		fprintf(f,"bold on\n");
	} else { 
		weight = "normal";
		fprintf(f,"bold off\n");
	}

	if ( gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(icheck)) ) {
		style = "italic";
		fprintf(f,"italic on\n");
	} else { 
		style = "normal";
		fprintf(f,"italic off\n");
	}

	if ( gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(vbutt)) ) {
		vis = 1;
	} else  { vis = 0; }

	if ( font_size[gtk_combo_box_get_active(GTK_COMBO_BOX(ccbox))] == NULL ) 
		fsize = "medium";
	else {
		fsize = font_size[gtk_combo_box_get_active(GTK_COMBO_BOX(ccbox))];
	}
	GdkColor *ncolor;
	gchar *color_ex;

	g_object_get( GTK_OBJECT(buttonC), "color", &ncolor );
	color_ex = g_strdup_printf("#%02x%02x%02x", ncolor->red >> 8, ncolor->green >> 8, ncolor->blue >> 8);
	fprintf(f,"color is => %s\n",color_ex);
	fprintf(f,"font sizE => %s\n",font_size[gtk_combo_box_get_active(GTK_COMBO_BOX(ccbox))]);
	fclose(f);	
	/*parsize it to xml */
	XmlWriteInfo("/home/user/.idea/idea.xml",
			size,
			nname,
			i_rows,
			ticon,
			color_ex,
			iname,
			cell_spacing,
			row_spacing,
			weight,
			style,
			fsize,
			vis,
			app);
	
	g_free(color_ex);

	return TRUE;
}

static gboolean
build_entry_list()
{
	FILE *f = fopen("/tmp/logbuild","a+");
	fprintf(f,"we are in build\n");
	fclose(f);
	
	sw = gtk_scrolled_window_new(NULL,NULL);
	gtk_scrolled_window_set_shadow_type (GTK_SCROLLED_WINDOW (sw),
					   GTK_SHADOW_ETCHED_IN);
	gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (sw),
				      GTK_POLICY_NEVER,
				      GTK_POLICY_AUTOMATIC);
	
	model = create_model();
	
	treeview = gtk_tree_view_new_with_model(model);
	gtk_tree_view_set_rules_hint(GTK_TREE_VIEW(treeview), TRUE);
	
	g_object_unref(model);
	
	renderer = gtk_cell_renderer_text_new ();
	column = gtk_tree_view_column_new_with_attributes ("Icon Name",
						     renderer,
						     "text",
						     COL_ICON,
						     NULL);
	gtk_tree_view_column_set_sort_column_id (column, COL_ICON);
	gtk_tree_view_append_column (GTK_TREE_VIEW(treeview), column);

	/* column for pname */
	renderer = gtk_cell_renderer_text_new ();
	column = gtk_tree_view_column_new_with_attributes ("Program Name",
						     renderer,
						     "text",
						     COL_PROG,
						     NULL);
	gtk_tree_view_column_set_sort_column_id (column, COL_PROG);
	gtk_tree_view_append_column (GTK_TREE_VIEW(treeview), column);
	
	gtk_widget_show_all(GTK_WIDGET(treeview));
	
	g_signal_connect (treeview, "row-activated", G_CALLBACK (choose_app), NULL);
	
	gtk_container_add(GTK_CONTAINER(sw),treeview);
	
	gtk_widget_show_all(GTK_WIDGET(sw));

	gtk_table_attach_defaults(GTK_TABLE(table), sw, 0,1,1,2);

	return TRUE;
}

static gboolean
refresh_value(GtkWidget *widget)
{
	FILE *f = fopen("/tmp/refresh","a+");
	fprintf(f,"refresh!\n");
	gtk_widget_destroy(GTK_WIDGET(treeview));
	fclose(f);
	parseDoc("/home/user/.idea/idea.xml");
	build_entry_list();
	
	return TRUE;
}

static gboolean 
ba(GtkWidget *widget, GtkTreeSelection   *s)
{
	FILE *f = fopen("/tmp/TOWS","a+");
	fprintf(f,"here\n");
	gint r;
	r = gtk_tree_selection_count_selected_rows(s);
	fprintf(f,"ROES => %d\n",r);
	fclose(f);
	return TRUE;
}

osso_return_t execute(osso_context_t *osso,gpointer data, gboolean user_activated)
{
	GtkWidget *dialog;
	GtkWidget *vbox;
	GtkWidget *mbox0;
	GtkWidget *mbox1;
	GtkWidget *label;
	GtkWidget *label0;
	GtkWidget *ibox;
	GtkWidget *tbox;
	GtkWidget *abox;
	GtkWidget *lbox;
	GtkWidget *label1;
	GtkWidget *buttonS;
	GtkWidget *notebook;
	GtkWidget *icon_frame;
	GtkWidget *table_frame;
	GtkWidget *app_frame;
	GtkWidget *label_frame;
	GtkWidget *mbox;
	GtkWidget *mbox2;
	GtkWidget *button0;
	gint response;
	gint i;
	GtkTreeSelection *sel;

	parseDoc("/home/user/.idea/idea.xml");


	dialog = gtk_dialog_new(); 
	
	gtk_window_set_title(GTK_WINDOW(dialog), "IDEA Customizing Applet");
	gtk_window_set_resizable (GTK_WINDOW (dialog), FALSE);
	gtk_widget_set_usize(GTK_WIDGET(dialog), 540,350);

	gtk_dialog_add_buttons(GTK_DIALOG(dialog),
				GTK_STOCK_OK, GTK_RESPONSE_OK,
				NULL);
				
	notebook = gtk_notebook_new();
	icon_frame = gtk_frame_new("Icon Setting");
	table_frame = gtk_frame_new("Table Setting");
	app_frame = gtk_frame_new("Application Setting");
	label_frame = gtk_frame_new("Label Setting");
	
	mbox = gtk_vbox_new(FALSE,2);
	ibox = gtk_hbox_new(FALSE,2);
	label0 = gtk_label_new("ICON DIMENSION");
	size_icon_combo = gtk_combo_box_new_text();
	gtk_combo_box_append_text(GTK_COMBO_BOX(size_icon_combo),"16");
	gtk_combo_box_append_text(GTK_COMBO_BOX(size_icon_combo),"24");
	gtk_combo_box_append_text(GTK_COMBO_BOX(size_icon_combo),"32");
	gtk_combo_box_append_text(GTK_COMBO_BOX(size_icon_combo),"48");
	gtk_combo_box_append_text(GTK_COMBO_BOX(size_icon_combo),"64");
	char s[3];
	g_snprintf(s,3,"%d",size);
	gtk_combo_box_append_text(GTK_COMBO_BOX(size_icon_combo),s);
	gtk_combo_box_set_active(GTK_COMBO_BOX(size_icon_combo),5);
	//g_signal_connect(combo0, "changed", G_CALLBACK(update_size), NULL);
	gtk_box_pack_start(GTK_BOX(ibox), label0, FALSE, FALSE, 0);
	gtk_box_pack_start(GTK_BOX(ibox), size_icon_combo, FALSE, FALSE, 0);
	gtk_box_pack_start(GTK_BOX(mbox), ibox, FALSE, FALSE, 0);

	ibox = gtk_hbox_new(FALSE,3);
	label0 = gtk_label_new("TOT ICON");
	tot_icon_spin = gtk_spin_button_new_with_range(0,64,1);
	gtk_spin_button_set_value(GTK_SPIN_BUTTON(tot_icon_spin), ticon);
	button0 = gtk_button_new_with_label("SET!");
	g_signal_connect(button0, "clicked", G_CALLBACK(set_icon), NULL);
	gtk_box_pack_start(GTK_BOX(ibox), label0, FALSE, FALSE, 0);
	gtk_box_pack_start(GTK_BOX(ibox), tot_icon_spin, FALSE, FALSE, 0);
	gtk_box_pack_start(GTK_BOX(ibox), button0, FALSE, FALSE, 0);
	gtk_box_pack_start(GTK_BOX(mbox), ibox, FALSE, FALSE, 0);

	ibox = gtk_hbox_new(FALSE,2);

	buttonS = gtk_button_new_from_stock(GTK_STOCK_APPLY); //("SAVE");
	gtk_box_pack_start(GTK_BOX(ibox), buttonS, TRUE,TRUE, 0);
	gtk_box_pack_start(GTK_BOX(mbox), ibox, FALSE, FALSE, 0);
	g_signal_connect(buttonS,"clicked",G_CALLBACK(save_icons_settings), NULL);
				
	gtk_container_add (GTK_CONTAINER (icon_frame), mbox);
	label1 = gtk_label_new("ICON SETTING");
	gtk_notebook_append_page (GTK_NOTEBOOK (notebook), icon_frame, label1);

	mbox2 = gtk_vbox_new(FALSE,2);
	lbox = gtk_hbox_new(TRUE,2);
	label0 = gtk_label_new ("Bold");
	
	bcheck = gtk_check_button_new ();
	if ( (!strcmp(weight,"bold")) ) { 
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(bcheck),TRUE);
	}
	gtk_box_pack_start(GTK_BOX(lbox), label0, FALSE,FALSE,0);
	gtk_box_pack_start(GTK_BOX(lbox), bcheck, FALSE,FALSE,0);
	gtk_box_pack_start(GTK_BOX(mbox2), lbox, FALSE, FALSE, 0);
	
	lbox = gtk_hbox_new(TRUE,2);
	label0 = gtk_label_new ("Italic");
	icheck = gtk_check_button_new ();
	if ( (!strcmp(style,"italic")) ) {
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(icheck), TRUE);
	}
	
	gtk_box_pack_start(GTK_BOX(lbox), label0, FALSE,FALSE,0);
	gtk_box_pack_start(GTK_BOX(lbox), icheck, FALSE,FALSE,0);
	gtk_box_pack_start(GTK_BOX(mbox2), lbox, FALSE, FALSE, 0);

	lbox = gtk_hbox_new(TRUE,2);
	label0 = gtk_label_new ("Color");
	GdkColor fg;
	gdk_color_parse(color, &fg);
	buttonC = hildon_color_button_new_with_color(&fg);
	gtk_box_pack_start(GTK_BOX(lbox), label0, FALSE,FALSE,0);
	gtk_box_pack_start(GTK_BOX(lbox), buttonC, FALSE,FALSE,0);
	gtk_box_pack_start(GTK_BOX(mbox2), lbox, FALSE, FALSE, 0);
	
	lbox = gtk_hbox_new(TRUE,2);
	
	label0 = gtk_label_new ("Font Size");
	ccbox = gtk_combo_box_new_text();
	for(i=0;font_size[i]!=NULL;i++) {
		gtk_combo_box_append_text(GTK_COMBO_BOX(ccbox), font_size[i]);
	}
	gtk_combo_box_append_text(GTK_COMBO_BOX(ccbox), fsize);
	gtk_combo_box_set_active(GTK_COMBO_BOX(ccbox),i);
	gtk_box_pack_start(GTK_BOX(lbox), label0, FALSE,FALSE,0);
	gtk_box_pack_start(GTK_BOX(lbox), ccbox, FALSE,FALSE,0);
	gtk_box_pack_start(GTK_BOX(mbox2), lbox, FALSE, FALSE, 0);

	lbox = gtk_hbox_new(TRUE,2);
	label0 = gtk_label_new("Visibilty");
	vbutt = gtk_check_button_new ();
	if ( visible == 1 ) {
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(vbutt), TRUE);
	}
	gtk_box_pack_start(GTK_BOX(lbox), label0, FALSE,FALSE,0);
	gtk_box_pack_start(GTK_BOX(lbox), vbutt, FALSE,FALSE,0);
	gtk_box_pack_start(GTK_BOX(mbox2), lbox, FALSE, FALSE, 0);

	lbox = gtk_hbox_new(TRUE,2);
	buttonS = gtk_button_new_from_stock(GTK_STOCK_APPLY); //gtk_button_new_with_label("SAVE");
	gtk_box_pack_start(GTK_BOX(lbox), buttonS, TRUE, TRUE, 0);
	gtk_box_pack_start(GTK_BOX(mbox2), lbox, FALSE, FALSE, 0);
	g_signal_connect(buttonS,"clicked",G_CALLBACK(save_label_settings), NULL);
				

	
	gtk_container_add(GTK_CONTAINER(label_frame), mbox2);
	label1 = gtk_label_new("LABEL SETTING");
	gtk_notebook_append_page (GTK_NOTEBOOK(notebook), label_frame, label1);
	
	
	mbox0 = gtk_vbox_new(FALSE,2);
	tbox = gtk_hbox_new(TRUE,2);
	label0 = gtk_label_new ("ICON PER ROWS");
	spin1 = gtk_spin_button_new_with_range(1,9,1);
	gtk_spin_button_set_value(GTK_SPIN_BUTTON(spin1),i_rows);
	gtk_box_pack_start(GTK_BOX(tbox), label0, FALSE, FALSE, 0);
	gtk_box_pack_start(GTK_BOX(tbox), spin1, FALSE, FALSE, 0);
	gtk_box_pack_start(GTK_BOX(mbox0), tbox, FALSE, FALSE, 0);

	tbox = gtk_hbox_new(TRUE,2);
	label0 = gtk_label_new("ROWS SPACING");
	spin2 = gtk_spin_button_new_with_range(0,99,1);
	gtk_spin_button_set_value(GTK_SPIN_BUTTON(spin2), row_spacing);
	gtk_box_pack_start(GTK_BOX(tbox), label0, FALSE, FALSE, 0);
	gtk_box_pack_start(GTK_BOX(tbox), spin2, FALSE, FALSE, 0);
	gtk_box_pack_start(GTK_BOX(mbox0), tbox, FALSE, FALSE, 0);

	tbox = gtk_hbox_new(TRUE,2);
	label0 = gtk_label_new("COLS SPACING");
	spin3 = gtk_spin_button_new_with_range(0,99,1);
	gtk_spin_button_set_value(GTK_SPIN_BUTTON(spin3), cell_spacing);
	gtk_box_pack_start(GTK_BOX(tbox), label0, FALSE, FALSE, 0);
	gtk_box_pack_start(GTK_BOX(tbox), spin3, FALSE, FALSE, 0);
	gtk_box_pack_start(GTK_BOX(mbox0), tbox, FALSE, FALSE, 0);

	tbox = gtk_hbox_new(TRUE,2);	
	buttonS = gtk_button_new_from_stock(GTK_STOCK_APPLY); //gtk_button_new_with_label("SAVE");
	gtk_box_pack_start(GTK_BOX(tbox), buttonS, TRUE, TRUE, 0);
	gtk_box_pack_start(GTK_BOX(mbox0), tbox, FALSE, FALSE, 0);

	g_signal_connect(buttonS,"clicked",G_CALLBACK(save_table_settings),NULL);
	
	gtk_container_add (GTK_CONTAINER (table_frame), mbox0);
	label1 = gtk_label_new("TABLE SETTING");
	gtk_notebook_append_page (GTK_NOTEBOOK (notebook), table_frame, label1);
	
	
	label0 = gtk_label_new("Double-Click on a row to change the association");

	table = gtk_table_new(3,1,FALSE);
	gtk_table_attach_defaults(GTK_TABLE(table), label0, 0,1,0,1);
	
	build_entry_list();
	
	button0 = gtk_button_new_from_stock(GTK_STOCK_REFRESH); //gtk_button_new_with_label("SAVE");
	gtk_widget_set_usize(GTK_WIDGET(button0), 500, 5);
	g_signal_connect(button0,"clicked",G_CALLBACK(refresh_value), NULL);
	gtk_table_attach_defaults(GTK_TABLE(table), button0, 0,1,2,3);
			
	
	gtk_container_add (GTK_CONTAINER (app_frame), table);
	label1 = gtk_label_new("APP SETTING");
	gtk_notebook_append_page (GTK_NOTEBOOK (notebook), app_frame, label1);

	gtk_notebook_set_page (GTK_NOTEBOOK(notebook), 1);
	
	gtk_container_add(GTK_CONTAINER(GTK_DIALOG(dialog)->vbox), notebook);
	
	
	gtk_widget_show_all(GTK_WIDGET(dialog));
	gtk_dialog_run(GTK_DIALOG(dialog));

	gtk_widget_destroy(GTK_WIDGET(dialog));
	
	return OSSO_OK;
}

osso_return_t save_state(osso_context_t *osso, gpointer data)
{
	/*save state*/
	return OSSO_OK;
}
