#include <stdio.h>
#include <string.h>
#include <gtk/gtk.h>
#include <libxml/xmlreader.h>
#include <libxml/xpath.h>
#include <libxml/xpathInternals.h>

#include "libidea.h"

void
parseElem (xmlDocPtr doc, xmlNodePtr cur, gchar *what) 
{
	gint* value=g_new(int,1);
	xmlChar *key;
	cur = cur->xmlChildrenNode;
	int count = 0;
	while ( cur != NULL ) {
		if ((!xmlStrcmp(cur->name,(const xmlChar *)what))) {
			/***FIXME use xmlFree() by g_strdup **/
			key = xmlNodeListGetString(doc,cur->xmlChildrenNode,1);
			if ( (!strcmp(what,"size")) ) {
				*value = xmlXPathCastStringToNumber((const xmlChar *)key);
				size = *value;
			} else if ( (!strcmp(what,"icon_name")) ) {
				nname[count] = g_strdup((gchar *)key);
				xmlFree(key);
			} 
			/* table tag */
			else if ( (!strcmp(what,"icon_row")) ) {
				*value = xmlXPathCastStringToNumber((const xmlChar *)key);
				i_rows = *value;
			} else if ( (!strcmp(what,"tot_icon")) ) {
				*value = xmlXPathCastStringToNumber((const xmlChar *)key);
				ticon = *value;
			} else if ( (!strcmp(what,"cell_spacing")) ) {
				*value = xmlXPathCastStringToNumber((const xmlChar *)key);
				cell_spacing = *value;
			} else if ( (!strcmp(what,"row_spacing")) ) {
				*value = xmlXPathCastStringToNumber((const xmlChar *)key);
				row_spacing = *value;
			}/* end table tag */
			/* label tag */
			else if ( (!strcmp(what,"color")) ) {
				color = g_strdup((gchar *)key);
				xmlFree(key);
			} else if ( (!strcmp(what,"visible")) ) {
				*value = xmlXPathCastStringToNumber((const xmlChar *)key);
				visible = *value;
			}
			else if ( (!strcmp(what,"name")) ) {
				iname[count] = g_strdup((gchar *)key);
				xmlFree(key);
			} else if ( (!strcmp(what,"weight")) ) {
				weight = g_strdup((gchar *)key);
				xmlFree(key);
			} else if ( (!strcmp(what,"style")) ) {
				style = g_strdup((gchar *)key);
				xmlFree(key);
			} else if ( (!strcmp(what,"fsize")) ) {
				fsize = g_strdup((gchar *)key);
				xmlFree(key);
			}/* end label tag */
			/* application tag */
			else if ( (!strcmp(what,"app")) ) {
				app[count] = g_strdup((gchar *)key);
				xmlFree(key);
			}
			count++;
		}
		cur = cur->next;
	}
	if ( (!strcmp(what,"name")) ) {
	/*	really needed ???? */
		iname[count] = NULL;
	}
	return;
}

void
parseDoc(char *docname) {
	xmlDocPtr doc;
	xmlNodePtr cur;

	doc = xmlParseFile(docname);

	if ( doc == NULL ) {
		return;
	}

	cur = xmlDocGetRootElement(doc);

	if ( cur == NULL ) {
		xmlFreeDoc(doc);
		return;
	}

	if (xmlStrcmp(cur->name,(const xmlChar *)"idea")) {
		xmlFreeDoc(doc);
		return;
	}

	cur = cur->xmlChildrenNode;
	while (cur!=NULL) {
		if ( (!xmlStrcmp(cur->name,(const xmlChar *)"icon"))) {
			parseElem (doc, cur, "size"); //icon size 16,24,32,48,64
			parseElem (doc, cur, "icon_name"); //name of the (normale) icon at place 'url'
		} else if ( (!xmlStrcmp(cur->name,(const xmlChar *)"table"))) {
			parseElem (doc, cur, "icon_row");
			parseElem (doc, cur, "tot_icon");
			parseElem (doc, cur, "cell_spacing");
			parseElem (doc, cur, "row_spacing");
		} else if ( (!xmlStrcmp(cur->name,(const xmlChar *)"label"))) {
			parseElem (doc, cur, "visible");
			parseElem (doc, cur, "color");
			parseElem (doc, cur, "name");
			parseElem (doc, cur, "weight");
			parseElem (doc, cur, "style");
			parseElem (doc, cur, "fsize");
		} else if ( (!xmlStrcmp(cur->name,(const xmlChar *)"application")) ) {
			parseElem (doc, cur, "app");
		}
		cur = cur->next;
	}

	xmlFreeDoc(doc);

	return;
}

