#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <stdio.h>

#include <glib.h>
#include <gtk/gtk.h>
#include <libosso.h>

#include <hildon-home-plugin/hildon-home-plugin-interface.h>

#include "libidea.h"

#define APPNAME "idea"
#define VERSION "1.0"

void *
hildon_home_applet_lib_initialize (void *state_data, 
				   int *state_size,
				   GtkWidget **applet_return)
{
  GtkWidget *button;

  osso_context_t *osso;

  osso = osso_initialize(APPNAME, VERSION, FALSE, NULL);
  if(!osso) {
	  g_debug("Error initializing the osso idea applet!");
	  return NULL;
  }

  button = idea_new ();
  
  (*applet_return) = button;

  return (void*)osso;
}

int
hildon_home_applet_lib_save_state (void *raw_data,
				   void **state_data, 
				   int *state_size)
{
  *state_data = NULL;
  *state_size = 0;
  return 0;
}

void
hildon_home_applet_lib_background (void *raw_data)
{
	/* what to do here ? */
}

void
hildon_home_applet_lib_foreground (void *raw_data)
{
	/*maybe to use for autoreloading */
}

void
hildon_home_applet_lib_deinitialize (void *raw_data)
{
	osso_context_t *osso;
	osso = (osso_context_t*)raw_data;

	osso_deinitialize(osso);
	
	
	
}

GtkWidget *
hildon_home_applet_lib_settings (void *applet_data,
				 GtkWindow *parent)
{
  return NULL;
}
