#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <stdio.h>

#include <glib.h>
#include <gtk/gtk.h>
#include <libosso.h>

#include <hildon-home-plugin/hildon-home-plugin-interface.h>

#include "libidea.h"

#define APPNAME "idea"
#define VERSION "1.0"

void *
hildon_home_applet_lib_initialize (void *state_data, 
				   int *state_size,
				   GtkWidget **applet_return)
{
  GtkWidget *button;
  FILE *ff;

  ff = fopen("/tmp/loggerhome","a+");

  fprintf (ff, "idea initialize %p %d\n",
	   state_data, *state_size);

  osso_context_t *osso;

  osso = osso_initialize(APPNAME, VERSION, FALSE, NULL);
  if(!osso) {
	  fprintf(ff,"not osso!\n");
	  g_debug("Error initializing the osso idea applet!");
	  return NULL;
  }

  button = idea_new ();
  fprintf(ff,"idea builded\n");
  fclose(ff);
/*  g_signal_connect (button, "clicked",
		    G_CALLBACK (idea_dialog_show),
		    NULL);
*/
  (*applet_return) = button;

  return (void*)osso;
}

int
hildon_home_applet_lib_save_state (void *raw_data,
				   void **state_data, 
				   int *state_size)
{

	FILE *f;
	f = fopen("/tmp/loggerhome","a+");
	  
  fprintf (f, "idea save_state\n");

  *state_data = NULL;
  *state_size = 0;
  fclose(f);
  return 0;
}

void
hildon_home_applet_lib_background (void *raw_data)
{
	FILE *f;
	f = fopen("/tmp/loggerhome","a+");
	  
  fprintf (f, "idea background\n");
  fclose(f);
}

void
hildon_home_applet_lib_foreground (void *raw_data)
{
  fprintf (stderr, "idea foreground\n");
}

void
hildon_home_applet_lib_deinitialize (void *raw_data)
{
	fprintf (stderr, "idea deinitialize\n");
	osso_context_t *osso;
	osso = (osso_context_t*)raw_data;

	osso_deinitialize(osso);
}

GtkWidget *
hildon_home_applet_lib_settings (void *applet_data,
				 GtkWindow *parent)
{
	FILE *f;
	  f = fopen("/tmp/loggerhome","a+");
	  
  fprintf (f, "idea settings\n");
  fclose(f);
  return NULL;
}
