#! /usr/bin/python
# - coding: utf-8 -*-

# Copyright (c) 2007-2008 Rnato Chencarek. All rights reserved.
#
# Author: Renato Chencarek <renato.chencarek@gmail.com>
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED,
# THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
# PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR
# CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
# EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
# PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
# PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
# LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
# NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
# SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


import md5, os, sys, random
import optparse

from Queue import Queue
from threading import Thread
from threading import currentThread

import ecore, ecore.evas, edje, evas

import cPickle, shutil

try:
    canola_data = cPickle.load(open(os.path.expanduser('~/.canola/prefs/settings')))
except Exception, e:
    print "Settings Error! Run Canola to fix this."
    print e
    sys.exit()


try:
    from sqlite3 import dbapi2 as sqlite
except ImportError:
    from pysqlite2 import dbapi2 as sqlite

is_done = False
ui_updates = Queue()
rfd, wfd = os.pipe()

def process_input(parser):

    parser.add_option("-W", "--width", dest="width", default="150",
                      action="store", help="thumb width [%default]")
    parser.add_option("-H", "--height", dest="height", default="90",
                      action="store", help="thumb height [%default]")
    parser.add_option("-t", "--time", dest="time", default="random",
                      action="store", help="time in seconds [%default]")
    parser.add_option("-o", "--output", dest="destdir", default=canola_data["video_thumb_path"],
                      action="store", metavar="CANOLA_COVERS_DIR",
                      help="specify canola's video thumbs location [%default]")
    parser.add_option("-d", "--database", dest="db", default=os.path.expanduser('~/.canola/canola.db'),
                      action="store", metavar="CANOLA_DATABASE",
                      help="specify canola's database location [%default]")
    parser.add_option("", "--x11", dest="x11",
                      action="store_true",
                      help="use x11 engine")
    parser.add_option("-e", "--edje", dest="edj", default="/usr/share/canola-tuning/pb.edj",
                      action="store", metavar="THEME_LOCATION",
                      help="theme location [%default]")
    parser.add_option("-n", "--no-ui", dest="no_ui",
                      action="store_true",
                      help="no User Interface")
    parser.add_option("-s", "--skip", dest="skip",
                      action="store_true",
                      help="skip already generated thumbnails")


    return parser.parse_args()

def cb_done(*a):
    global is_done
    if is_done:
        ecore.main_loop_quit()

def load_edje(edj):
    if ecore.evas.engine_type_supported_get("software_x11_16") and \
    '--x11' not in sys.argv:
        cls = ecore.evas.SoftwareX11_16
    else:
        cls = ecore.evas.SoftwareX11

    ee = cls(w=720, h=420)
    ee.title = "Generating Video Thumbnails"
    ee.name_class = ("VideoThumb", "VideoThumb")
    ee.evas.font_hinting_set(evas.EVAS_FONT_HINTING_AUTO)
    canvas = ee.evas

    bg = canvas.Rectangle(color=(255, 255, 255, 255), size=canvas.size)
    bg.show()

    pb = edje.Edje(canvas, file=edj, group="progressbar")
    pb.signal_callback_add("action,clicked", "done", cb_done)

    ee.data["pb"] = pb

    def resize_cb(ee):
        h = ee.data["pb"].size_min_get()[1]
        ee.data["pb"].geometry_set(10, (ee.evas.size[1] - h) / 2, ee.evas.size[0] - 20, h)

    resize_cb(ee)
    ee.callback_resize = resize_cb

    pb.part_drag_value_set("knob", 0, 0)
    pb.part_text_set("label", "Loading")

    pb.show()
    ee.show()

    return ee, pb

def process_videos(args, options, set_text, set_pos):
    global is_done

    width   = options.width
    height  = options.height
    destdir = options.destdir
    time    = options.time

    if time == "random":
        time = random.randint(60, 120)

    i = 2
    j = 1

    if not os.path.exists(destdir):
        os.makedirs(destdir)

    for f in args:
        set_text(str(f))

        filename = md5.new(f)
        filename = filename.hexdigest()
        filename = os.path.join(destdir, filename + ".jpg")

        if os.path.exists(filename) and options.skip:
            set_pos(float(j) / float(len(args)))
            j += 1
            continue
        else:
            print "Not Skip", filename, options.skip

        cmd = 'mplayer -idx -really-quiet -zoom -ss %s -nosound -vo jpeg:outdir=%s -vf scale=%s:%s -frames 2 "%s"' % (time, destdir, width, height, f)
        os.system(cmd)

        set_pos(float(j) / float(len(args)))

        j += 1

        if not os.path.exists("%s/%08d.jpg" % (destdir, i)):
            print "\nMPlayer error! Thumb NOT generated!", f, "\n"
            continue

        os.system("mv %s %s" % ("%s/%08d.jpg" % (destdir, i), filename))
        os.system("rm %s/%08d.jpg" % (destdir, i - 1))

        print "\nThumb generated!\n%s -> %s\n" % (f, filename)

    set_pos(1)
    set_text("Done")
    is_done = True

def move_default_thumb_location(src, dest):
    try:
        shutil.copytree(src, dest)
        shutil.rmtree(src)
    except Exception, e:
        print "Cannot move default thumb location from %s to %s" % (src, dest)
        print e
        sys.exit(-1)

    try:
        canola_data["video_thumb_path"] = dest
        cPickle.dump(canola_data,
                     open(os.path.expanduser('~/.canola/prefs/settings'), "wb"),
                     cPickle.HIGHEST_PROTOCOL)
    except Exception, e:
        print "Cannot set Canola settings"
        print e
        sys.exit(-1)


if __name__ == "__main__":
    parser = optparse.OptionParser("usage: python videothumb.py [options] <video files>")
    options, vargs = process_input(parser)

    database = options.db
    ui = not options.no_ui

    options.destdir = options.destdir.strip('"').strip("'")
    if options.destdir != canola_data["video_thumb_path"]:
        move_default_thumb_location(canola_data["video_thumb_path"],
                                    options.destdir)

    if not len(vargs) and not database:
        parser.error("missing video file")

    if database and not len(vargs):
        try:
            con = sqlite.connect(database)
            cur = con.cursor()
            cur.execute("SELECT DISTINCT files.path FROM videos,files WHERE files.id = videos.id")
            vargs = [a[0] for a in cur.fetchall()]
            con.close()
        except Exception, e:
            print "Database Error! Run Canola to fix this."
            print e
            sys.exit()


    if ui:
        ee, pb = load_edje(options.edj)
        pb.part_drag_value_set("knob", 0, 0)
        pb.part_text_set("label", "Processing Videos")

    def set_text(text):
        if ui:
            ui_updates.put(text)
            os.write(wfd, "0")

    def set_pos(pos):
        if ui:
            ui_updates.put(pos)
            os.write(wfd, "1")

    def update_ui(fd_handler, bar):
        tag = os.read(fd_handler.fd, 1)
        val = ui_updates.get()

        if tag == "0":
            bar.part_text_set("label", val)
        elif tag == "1":
            bar.part_drag_value_set("knob", val, 0)
        else:
            return False

        return True

    if os.path.exists("/usr/bin/mplayer"):
        thumbnailer = Thread(target=process_videos, args=(vargs, options, set_text, set_pos))
        thumbnailer.setDaemon(True)
        thumbnailer.start()
    else:
        if ui:
            pb.part_text_set("label", 'To generate video thumbs you have to install the "Evil" MPlayer')

    if ui:
        ecore.fd_handler_add(rfd, ecore.ECORE_FD_READ, update_ui, pb)
        ecore.main_loop_begin()
        del ee
    else:
        thumbnailer.join()
