/* X-Chat
 * Copyright (C) 1998 Peter Zelezny.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

#define GTK_DISABLE_DEPRECATED

#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include "fe-gtk.h"

#include <gtk/gtkentry.h>
#include <gtk/gtkhbox.h>
#include <gtk/gtkvbox.h>
#include <gtk/gtklabel.h>
#include <gtk/gtkstock.h>
#include <gtk/gtkhbbox.h>
#include <gtk/gtkhseparator.h>
#include <gtk/gtkvseparator.h>
#include <gtk/gtkradiobutton.h>
#include <gtk/gtktogglebutton.h>
#include <gtk/gtkwidget.h>

#include "../common/xchat.h"
#include "../common/fe.h"
#include "../common/util.h"
#include "../common/xchatc.h"
#include "gtkutil.h"
#include "xtext.h"
#include "maingui.h"

#include <hildon/hildon-find-toolbar.h>
#include <hildon/hildon-window.h>

static textentry *last;	/* our last search pos */
static int case_match = 0;
static int search_backward = 0;
static gchar *stext = NULL;
static gboolean visible = FALSE;


static void
search_search (session * sess, const gchar *text)
{
	if (!is_session (sess))
	{
		fe_message (_("The window you opened this Search "
						"for doesn't exist anymore."), FE_MSG_ERROR);
		return;
	}

	last = gtk_xtext_search (GTK_XTEXT (sess->gui->xtext), text,
									 last, case_match, search_backward);
	if (!last)
		fe_message (_("Search hit end, not found."), FE_MSG_ERROR);
}

static void
search_find_cb (GtkWidget * button, session * sess)
{
	g_object_get (G_OBJECT(button), "prefix", &stext, NULL);
	search_search (sess, stext);
}

static void
search_close_cb (GtkWidget * button, gpointer user_data)
{
	if (stext != NULL)
	{
		if (stext) g_free(stext);
		stext = NULL;
	}
	gtk_widget_hide (button);
	visible = FALSE;
}

static void
search_entry_cb (GtkWidget * entry, session * sess)
{
	search_search (sess, gtk_entry_get_text (GTK_ENTRY (entry)));
}

static void
search_caseign_cb (GtkToggleButton * but, session * sess)
{
	case_match = (but->active)? 1: 0;
}

static void
search_dirbwd_cb (GtkToggleButton * but, session * sess)
{
	search_backward = (but->active)? 1: 0;
}

void
search_open (session * sess)
{
	static GtkWidget *win = NULL;

	if (visible)
	{
		search_close_cb(win, NULL);
		return;
	}

	last = NULL;
	if (win == NULL)
	{
		win = hildon_find_toolbar_new (_("Find:"));
		g_signal_connect(win, "close", G_CALLBACK(search_close_cb), NULL);
		g_signal_connect(win, "search", G_CALLBACK(search_find_cb), sess);

		hildon_window_add_toolbar(HILDON_WINDOW(parent_window), GTK_TOOLBAR(win));
	}
	gtk_widget_show_all (win);
	visible = TRUE;
	hildon_find_toolbar_highlight_entry (HILDON_FIND_TOOLBAR(win), TRUE);
}
