#!/usr/bin/python2.5
import conic
import gtk, hildon
import gobject
from gnome import gconf
import logging, sys

from wifi_assistant.daemon.daemon import Daemon
from wifi_assistant.daemon.launcher import Launcher
from wifi_assistant.settings.application_settings import ApplicationSettings
from wifi_assistant.settings.network_settings import NetworkSettings

if __name__ == "__main__":
    logging.basicConfig(level=logging.DEBUG, stream=sys.__stdout__)
    
    gconf_client = gconf.client_get_default()
    gconf_root_dir = '/apps/maemo/wifi_assistant'
    network_settings = NetworkSettings(gconf_client, gconf_root_dir)
    application_settings = ApplicationSettings(gconf_client, gconf_root_dir)
    launcher = Launcher()
    gtk_window = gtk.Window()
    d = Daemon(launcher, application_settings, network_settings, gtk_window)
 
    d.start()
    d.stop()
