/*
 *
 *  Copyright (c) 2010 Christoph Keller <gri@nospam@not-censored.com>
 *
 *  This file is part of Web2SMS.
 *
 *  Web2SMS is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Web2SMS is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Web2SMS. If not, see <http://www.gnu.org/licenses/>
 *
 */

#ifndef __web2sms_orangeCH_hpp__
#define __web2sms_orangeCH_hpp__

// Local includes
#include "../providerinterface.hpp"

// Global includes
#include <QtCore/QObject>

// Forward declarations
class orangeCHPrivate;

//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////

class orangeCH : public ProviderInterface
{
  Q_OBJECT
  Q_INTERFACES(ProviderInterface)

public:
  orangeCH(QObject* parent = 0);
  ~orangeCH();

  // ProviderInterface overrides
  void loadSettings(const QByteArray& data);
  QByteArray saveSettings() const;

  bool showAccountSettingsDialog(QWidget* parent);

  bool isLoggedIn() const;

  CallbackType login();
  CallbackType logout();

  void sendMessage(const Message& message);

  void updateBalance();

  QList<MessageType> messageTypes() const;

private:
  orangeCHPrivate* d;
  friend class orangeCHPrivate;
};

//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////

#endif // __web2sms_orangeCH_hpp__
