/*
 * TurnOver - try to turn over all the chess pieces
 * Copyright (C) 2010 Xizhi Zhu
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */


#include "settingdialog.h"

#include <QtGui/QHBoxLayout>
#include <QtGui/QLabel>
#include <QtGui/QVBoxLayout>


SettingDialog::SettingDialog(QWidget *parent)
    : QDialog(parent, Qt::Dialog)
{
    QVBoxLayout *layout = new QVBoxLayout(this);
    layout->setAlignment(Qt::AlignCenter);

    layout->addWidget(new QLabel("Columns (2-9):"));
    columnEdit = new QLineEdit;
    columnEdit->setInputMask("D");
    layout->addWidget(columnEdit);

    layout->addWidget(new QLabel("Rows (2-9):"));
    rowEdit = new QLineEdit;
    rowEdit->setInputMask("D");
    layout->addWidget(rowEdit);

    QHBoxLayout *buttomLayout = new QHBoxLayout;
    layout->addLayout(buttomLayout);
    okButton = new QPushButton("OK");
    connect(okButton, SIGNAL(clicked()), SLOT(changeSetting()));
    buttomLayout->addWidget(okButton);
    cancelButton = new QPushButton("Cancel");
    connect(cancelButton, SIGNAL(clicked()), SLOT(close()));
    buttomLayout->addWidget(cancelButton);
}

void SettingDialog::show(int column, int row)
{
    this->column = column;
    this->row = row;

    columnEdit->setText(QString::number(column));
    rowEdit->setText(QString::number(row));

    QDialog::show();
}

void SettingDialog::changeSetting()
{
    column = columnEdit->text().toInt();
    row = rowEdit->text().toInt();

    emit settingChanged(column, row);

    QDialog::close();
}
