# -*- coding: utf-8 -*-
from PyQt4.QtGui import QCheckBox, QDialog, QLineEdit, QGridLayout, QLabel, \
    QPushButton
from PyQt4.Qt import Qt

class LoginDialog(QDialog):
    @classmethod
    def getCredentials(self, *args, **kwargs):
        d = LoginDialog(*args, **kwargs)
        s = None
        retval = d.exec_()
        if retval:
            return str(d.username.text()), str(d.password.text()), \
                d.remember_password.isChecked(), True
        else:
            return None, None, None, False

    def __init__(self, server=None, username=None, password=None, remember=False, parent=None):
        QDialog.__init__(self, parent)
        self.setWindowTitle("Logging in to %s" % server)
        self.resize(300,0)
        self.username = QLineEdit()
        self.username.setInputMethodHints(Qt.ImhNoAutoUppercase|Qt.ImhNoPredictiveText)
        self.password = QLineEdit()
        self.password.setEchoMode(QLineEdit.Password)
        self.remember_password = QCheckBox("Remember password")
        self.log_in = QPushButton("Log in")
        self.log_in.clicked.connect(self.accept)

        if username:
            self.username.setText(username)
        if password:
            self.password.setText(password)
        if remember:
            self.remember_password.setChecked(True)


        layout = QGridLayout()
        layout.addWidget(QLabel("Username"), 0, 0)
        layout.addWidget(self.username, 0, 1)
        layout.addWidget(QLabel("Password"), 1, 0)
        layout.addWidget(self.password, 1, 1)
        layout.addWidget(self.remember_password, 2, 0, 1, 0)
        layout.addWidget(self.log_in, 3, 0, 1, 0)

        self.setLayout(layout)
