# -*- coding: utf-8 -*-
import shutil
import os

from PyQt4.QtCore import QModelIndex, QString, Qt, pyqtSignal, QSize, QTimer, QThread, \
    QAbstractItemModel
from PyQt4.QtGui import QSortFilterProxyModel, QTableView, QAbstractItemView, \
    QToolBar, QIcon, QPlainTextEdit, QHBoxLayout, QFileDialog, QMessageBox, \
    QWidget, QProgressDialog, QActionGroup
  
from common import CustomWindow, IconCache
from files.model import LocalFileModel

class StringView(CustomWindow):
    """
    String editor
    
    TODO: This file needs *a lot* restructuring
    """
    def updateModel(self):
        self.source_index = self.proxy_model.mapToSource(self.index)
        entry = self.model.data(self.source_index, Qt.UserRole)
        
        # Undo handling:
        if getattr(entry, "original", None) == None:
            entry.original = entry.msgstr
            
            
        #modified = getattr(entry, "original", entry.msgstr) != entry.msgstr
        #self.actionRevert.setEnabled(modified)
            
        # Update widgets:
        self.source_string.setPlainText(entry.msgid)
        self.translated_string.setPlainText(entry.msgstr)
        
        # Flagging:
        if entry.translated():
            self.actionSetTranslated.setChecked(True)
        elif entry.fuzzy():
            self.actionSetFuzzy.setChecked(True)
        else:
            self.actionSetUntranslated.setChecked(True)

    def __init__(self, proxy_string_list_model, index, parent=None):
        CustomWindow.__init__(self, parent, title=u"String", busy=False)
        self.index = index
        self.proxy_model = proxy_string_list_model
        self.model = self.proxy_model.sourceModel()

        self.source_string = QPlainTextEdit()
        self.source_string.setReadOnly(True)
        self.translated_string = QPlainTextEdit()
        self.translated_string.verticalScrollBar().valueChanged.connect(
            self.syncScrollBar)


        layout = QHBoxLayout(self.centralWidget())
        layout.addWidget(self.source_string)
        layout.addWidget(self.translated_string)

        toolbar = QToolBar(self)

        # Previous string button
        self.actionPrev = toolbar.addAction(
            IconCache.get("hildon/general_back.png"),
            self.tr("Previous string"),
            self.previous)

        # Next string button
        self.actionNext = toolbar.addAction(
            IconCache.get("hildon/general_forward.png"),
            self.tr("Next string"),
            self.next)
            
        toolbar.addSeparator()
        
        # Revert to original
        self.actionRevert = toolbar.addAction( 
            IconCache.get("hildon/general_undo.png"),
            self.tr("Revert to original"),
            self.revert)

        # Copy source button
        self.actionCopySource = toolbar.addAction(
            IconCache.get("hildon/general_notes.png"),
            self.tr("Copy source string"),
            self.copysource)

        # Auto translate button
        if self.model.file_model.lang_code:
            self.actionAutoTranslate = toolbar.addAction(
                IconCache.get("hildon/browser_search.png"),
                self.tr("Auto-translate"),
                self.autotranslate)
            
        toolbar.addSeparator()

        # Set string to translated
        self.actionSetTranslated = toolbar.addAction(
            IconCache.getGreenFlag(),
            self.tr("Set string status to <i>translated</i>"),
            self.setTranslated)

        # Set string to fuzzy
        self.actionSetFuzzy = toolbar.addAction(
            IconCache.getBlueFlag(),
            self.tr("Set string status to <i>fuzzy</i>"),
            self.setFuzzy)

        # Set string to untranslated
        self.actionSetUntranslated = toolbar.addAction(
            IconCache.getRedFlag(),
            self.tr("Set string status to <i>untranslated</i>"),
            self.setUntranslated)
        
            
        # Status group
        group = QActionGroup(self)
        for i in self.actionSetTranslated, self.actionSetFuzzy, \
            self.actionSetUntranslated:
                i.setCheckable(True)
                group.addAction(i)
        
        self.updateModel()
        self.addToolBar(toolbar)
        self.translated_string.setFocus()

    def setTranslated(self):
        self.saveCurrentString()
        entry = self.model.data(self.source_index, Qt.UserRole)
        if entry.fuzzy():
            entry.flags.remove('fuzzy')
        if entry.translated():
            self.actionSetTranslated.setChecked(True)
        else:
            self.actionSetUntranslated.setChecked(True)
      
    def setFuzzy(self):
        self.saveCurrentString()
        entry = self.model.data(self.source_index, Qt.UserRole)
        if not entry.fuzzy():
            entry.flags.append('fuzzy')
        if entry.fuzzy() and entry.msgstr != "":
            self.actionSetFuzzy.setChecked(True)
        else:
            self.actionSetUntranslated.setChecked(True)

    def setUntranslated(self):
        # Are you sure?
        self.saveCurrentString()
        entry = self.model.data(self.source_index, Qt.UserRole)
        if entry.fuzzy():
            entry.flags.remove('fuzzy')
        entry.msgstr = u""
        self.translated_string.setPlainText(u"")
        self.actionSetUntranslated.setChecked(True)


    def next(self):
        # TODO: Better validation
        self.saveCurrentString()
        col, row, parent = self.index.column(), self.index.row(), \
            self.index.parent()
        row+=1
        if row>=self.proxy_model.rowCount(self.index):
            row = 0
        self.index = self.proxy_model.index(row,col,parent)
        self.updateModel()

    def previous(self):
        self.saveCurrentString()
        col, row, parent = self.index.column(), self.index.row(), \
            self.index.parent()
        row-=1
        if row < 0:
            row = self.proxy_model.rowCount(self.index)-1
        self.index = self.proxy_model.index(row,col,parent)
        self.updateModel()

    def syncScrollBar(self, val):
        """
        Synchronize source string text edit box with translation string
        """
        a = self.translated_string.verticalScrollBar()
        b = self.source_string.verticalScrollBar()
        try:
            b.setValue( -10 + val * 1.05 * b.maximum() / a.maximum())
        except ZeroDivisionError:
            b.setValue(0)

    def autotranslate(self):
        self.model.autotranslate(self.source_index)
        entry = self.model.data(self.source_index, Qt.UserRole)
        self.translated_string.setPlainText(entry.msgstr)
        self.setFuzzy()
        
    def revert(self):
        entry = self.model.data(self.source_index, Qt.UserRole)
        if getattr(entry, "original", entry.msgstr) != entry.msgstr:
            entry.msgstr = entry.original
        self.updateModel()

    def copysource(self):
        self.model.copysource(self.source_index)
        entry = self.model.data(self.source_index, Qt.UserRole)
        self.translated_string.setPlainText(entry.msgstr)
        self.setFuzzy()
        
    def saveCurrentString(self):
        self.model.data(self.source_index, Qt.UserRole).msgstr = \
            u"%s" % self.translated_string.toPlainText()


    def closeEvent(self, event):        
        self.saveCurrentString()
        event.accept()
