/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.pkcs;

import java.math.BigInteger;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERSequence;

public final class RSAPrivateKeyStructure
extends ASN1Encodable {
    private int version = 0;
    private BigInteger modulus;
    private BigInteger publicExponent;
    private BigInteger privateExponent;
    private BigInteger prime1;
    private BigInteger prime2;
    private BigInteger exponent1;
    private BigInteger exponent2;
    private BigInteger coefficient;
    private ASN1Sequence otherPrimeInfos = null;

    public RSAPrivateKeyStructure(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4, BigInteger bigInteger5, BigInteger bigInteger6, BigInteger bigInteger7, BigInteger bigInteger8) {
        this.modulus = bigInteger;
        this.publicExponent = bigInteger2;
        this.privateExponent = bigInteger3;
        this.prime1 = bigInteger4;
        this.prime2 = bigInteger5;
        this.exponent1 = bigInteger6;
        this.exponent2 = bigInteger7;
        this.coefficient = bigInteger8;
    }

    @Override
    public final DERObject toASN1Object() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(new DERInteger(this.version));
        RSAPrivateKeyStructure rSAPrivateKeyStructure = this;
        aSN1EncodableVector.add(new DERInteger(rSAPrivateKeyStructure.modulus));
        rSAPrivateKeyStructure = this;
        aSN1EncodableVector.add(new DERInteger(rSAPrivateKeyStructure.publicExponent));
        rSAPrivateKeyStructure = this;
        aSN1EncodableVector.add(new DERInteger(rSAPrivateKeyStructure.privateExponent));
        rSAPrivateKeyStructure = this;
        aSN1EncodableVector.add(new DERInteger(rSAPrivateKeyStructure.prime1));
        rSAPrivateKeyStructure = this;
        aSN1EncodableVector.add(new DERInteger(rSAPrivateKeyStructure.prime2));
        rSAPrivateKeyStructure = this;
        aSN1EncodableVector.add(new DERInteger(rSAPrivateKeyStructure.exponent1));
        rSAPrivateKeyStructure = this;
        aSN1EncodableVector.add(new DERInteger(rSAPrivateKeyStructure.exponent2));
        rSAPrivateKeyStructure = this;
        aSN1EncodableVector.add(new DERInteger(rSAPrivateKeyStructure.coefficient));
        if (this.otherPrimeInfos != null) {
            aSN1EncodableVector.add(this.otherPrimeInfos);
        }
        return new DERSequence(aSN1EncodableVector);
    }
}

