/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DEROutputStream;

public final class DERGeneralizedTime
extends ASN1Object {
    private String time;

    public DERGeneralizedTime(String string) {
        this.time = string;
        try {
            this.getDate();
            return;
        }
        catch (ParseException parseException) {
            throw new IllegalArgumentException("invalid date string: " + parseException.getMessage());
        }
    }

    DERGeneralizedTime(byte[] byArray) {
        char[] cArray = new char[byArray.length];
        for (int i = 0; i != cArray.length; ++i) {
            cArray[i] = (char)(byArray[i] & 0xFF);
        }
        this.time = new String(cArray);
    }

    public final String getTime() {
        if (this.time.charAt(this.time.length() - 1) == 'Z') {
            return this.time.substring(0, this.time.length() - 1) + "GMT+00:00";
        }
        int n = this.time.length() - 5;
        char c = this.time.charAt(n);
        if (c == '-' || c == '+') {
            return this.time.substring(0, n) + "GMT" + this.time.substring(n, n + 3) + ":" + this.time.substring(n + 3);
        }
        n = this.time.length() - 3;
        c = this.time.charAt(n);
        if (c == '-' || c == '+') {
            return this.time.substring(0, n) + "GMT" + this.time.substring(n) + ":00";
        }
        return this.time + this.calculateGMTOffset();
    }

    private String calculateGMTOffset() {
        String string = "+";
        TimeZone timeZone = TimeZone.getDefault();
        int n = timeZone.getRawOffset();
        if (n < 0) {
            string = "-";
            n = -n;
        }
        int n2 = n / 3600000;
        n = (n - n2 * 60 * 60 * 1000) / 60000;
        try {
            if (timeZone.useDaylightTime() && timeZone.inDaylightTime(this.getDate())) {
                n2 += string.equals("+") ? 1 : -1;
            }
        }
        catch (ParseException parseException) {}
        return "GMT" + string + DERGeneralizedTime.convert(n2) + ":" + DERGeneralizedTime.convert(n);
    }

    private static String convert(int n) {
        if (n < 10) {
            return "0" + n;
        }
        return Integer.toString(n);
    }

    public final Date getDate() throws ParseException {
        SimpleDateFormat simpleDateFormat;
        String string = this.time;
        if (this.time.endsWith("Z")) {
            simpleDateFormat = this.hasFractionalSeconds() ? new SimpleDateFormat("yyyyMMddHHmmss.SSS'Z'") : new SimpleDateFormat("yyyyMMddHHmmss'Z'");
            simpleDateFormat.setTimeZone(new SimpleTimeZone(0, "Z"));
        } else if (this.time.indexOf(45) > 0 || this.time.indexOf(43) > 0) {
            string = this.getTime();
            simpleDateFormat = this.hasFractionalSeconds() ? new SimpleDateFormat("yyyyMMddHHmmss.SSSz") : new SimpleDateFormat("yyyyMMddHHmmssz");
            simpleDateFormat.setTimeZone(new SimpleTimeZone(0, "Z"));
        } else {
            simpleDateFormat = this.hasFractionalSeconds() ? new SimpleDateFormat("yyyyMMddHHmmss.SSS") : new SimpleDateFormat("yyyyMMddHHmmss");
            simpleDateFormat.setTimeZone(new SimpleTimeZone(0, TimeZone.getDefault().getID()));
        }
        if (this.hasFractionalSeconds()) {
            char c;
            int n;
            String string2 = string.substring(14);
            for (n = 1; n < string2.length() && '0' <= (c = string2.charAt(n)) && c <= '9'; ++n) {
            }
            if (n - 1 > 3) {
                string2 = string2.substring(0, 4) + string2.substring(n);
                string = string.substring(0, 14) + string2;
            }
        }
        return simpleDateFormat.parse(string);
    }

    private boolean hasFractionalSeconds() {
        return this.time.indexOf(46) == 14;
    }

    @Override
    final void encode(DEROutputStream object) throws IOException {
        DEROutputStream dEROutputStream = object;
        object = this;
        char[] cArray = ((DERGeneralizedTime)object).time.toCharArray();
        object = cArray;
        byte[] byArray = new byte[cArray.length];
        for (int i = 0; i != ((Object)object).length; ++i) {
            byArray[i] = (byte)object[i];
        }
        dEROutputStream.writeEncoded(24, byArray);
    }

    @Override
    final boolean asn1Equals(DERObject dERObject) {
        if (!(dERObject instanceof DERGeneralizedTime)) {
            return false;
        }
        return this.time.equals(((DERGeneralizedTime)dERObject).time);
    }

    @Override
    public final int hashCode() {
        return this.time.hashCode();
    }
}

