#ifndef STOPWATCH_H
#define STOPWATCH_H

/*
  TimerJinni - A general timing application
  Copyright (C) 2009  Tim Teulings

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <Lum/Model/Action.h>

#include <Lum/OS/Font.h>

#include <Lum/Object.h>

class StopWatch : public Lum::Control
{
private:
  Lum::OS::FontRef      minFont;
  Lum::OS::FontRef      font;
  std::wstring          text;
  Lum::Model::ActionRef clickAction;
  Lum::Model::ActionRef blinkTimer;
  Lum::OS::ColorRef     alarmColor;
  bool                  alarm;
  bool                  showInvert;
  size_t                minDigitWidth;
  size_t                minColonWidth;
  size_t                minPointWidth;
  size_t                digitWidth;
  size_t                colonWidth;
  size_t                pointWidth;

private:
  Lum::OS::Font* FindFont(size_t& digitWidth,
                          size_t& colonWidth,
                          size_t& pointWidth);

public:
  StopWatch();

  Lum::Model::Action* GetClickAction() const;

  void SetText(const std::wstring& text);
  void SetAlarm(bool alarm);

  void CalcSize();

  void Layout();
  void Draw(int x, int y, size_t w, size_t h);

  bool HandleMouseEvent(const Lum::OS::MouseEvent& event);

  void Resync(Lum::Base::Model* model, const Lum::Base::ResyncMsg& msg);
};

#endif
