/*
** Copyright (c) 2009  Kimmo 'Rainy' Pekkola
**
** This program is free software: you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation, either version 3 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program.  If not, see http://www.gnu.org/licenses.
*/

#include "debugtext.h"
#include "rotator.h"
#include <QPainter>
#include <QDebug>
#include <QGraphicsSceneMouseEvent>
#include <QFontMetrics>

static CDebugText* c_pInstance = NULL;

//-----------------------------------------------------------------------------
/**
** Returns the instance to the debug text. Creates the instance when this
** is called the first time.
*/
CDebugText* CDebugText::instance()
{
    if (c_pInstance == NULL)
    {
        c_pInstance = new CDebugText();
    }
    return c_pInstance;
}

//-----------------------------------------------------------------------------
/**
** The constructor.
*/
CDebugText::CDebugText() : QGraphicsItem()
{
}

//-----------------------------------------------------------------------------
/**
** The destructor.
*/
CDebugText::~CDebugText()
{
}

//-----------------------------------------------------------------------------
/**
** Sets a new value for the text. If the text isn't known yet it is added
** to the debug string.
*/
void CDebugText::setText(QString strText, QString strValue)
{ 
    m_DebugValues[strText] = strValue; 
    update(); 

    //qDebug() << QTime::currentTime().toString("HH:mm:ss.zzz") << createText();
}

//-----------------------------------------------------------------------------
/**
** Returns the bounding rectangle of the item.
**
** \return The bounding rectangle.
*/
QRectF CDebugText::boundingRect() const
{
    QFont font;
    QFontMetrics metrics(font);
    QRectF r = metrics.boundingRect(createText());
    return QRectF(0, 0, r.width(), r.height());
}

//-----------------------------------------------------------------------------
/**
** Paints the text to the widget.
**
** \param pPainter Pointer to the painter object.
** \param pOption The paint options.
** \param pWidget The target widget.
**
*/
void CDebugText::paint(QPainter* pPainter, const QStyleOptionGraphicsItem* pOption, QWidget* pWidget)
{
    QRectF r = boundingRect();
    pPainter->setPen(QColor(0, 0, 0));
    pPainter->drawText(r, createText());
    r.adjust(-1, -1, 0, 0);
    pPainter->setPen(QColor(255, 255, 255));
    pPainter->drawText(r, createText());
}

//-----------------------------------------------------------------------------
/**
** Creates the debug text by concatenating all the values from the map together.
**
** \return The created debug text.
*/
QString CDebugText::createText() const
{
    QString strResult;
    QList<QString> keys = m_DebugValues.keys();
    foreach (QString key, keys)
    {
        if (!strResult.isEmpty())
        {
            strResult += " - ";
        }
        strResult += key + ": " + m_DebugValues[key];
    }
    return strResult;
}

// EOF
