#!/usr/bin/env python
# -*- coding: utf-8 -*-
# Convenience imports
from PyQt4.QtCore import *
from PyQt4.QtGui import *

import sys

# This is a decorator class
class WinUi:
  # With only one function to decorate a window
  def setupUi(self, parent):
    self.centralwidget=QWidget(parent)
    parent.setCentralWidget(self.centralwidget)

    # A horizontal layout
    self.layout=QVBoxLayout(self.centralwidget)
   
    # With three items
    #self.label2=QLabel("This app will help you to save files that you have opened in n900 web browser. For example please open youtube.com, hit play on any video and wait until red line cover whole timeline (under video). Then hit location where you want to store this movie", self.centralwidget)
    self.label=QLabel("Choose location to copy MicroB temp files:", self.centralwidget)
    self.butmmc=QPushButton(self.centralwidget)
    self.butphone=QPushButton(self.centralwidget)
    self.butchoose=QPushButton(self.centralwidget)
    l=self.layout

    # Add them to the layout
    #l.addWidget(self.label2)
    l.addWidget(self.label)
    l.addWidget(self.butmmc)
    l.addWidget(self.butphone)
    l.addWidget(self.butchoose)
    # Set the label of the button
    self.butmmc.setText("Memory Card (Videos)")
    self.butphone.setText("Phone Memory (Videos)")
    self.butchoose.setText("Choose...")
class Win(QMainWindow):
  def __init__(self):
    QMainWindow.__init__(self)
    QMessageBox.information(self, "Welcome!", "This app will help you to save files that you have opened in n900 web browser. For example please open youtube.com, hit play on any video and wait until red line cover whole timeline (under video). Then hit location where you want to store this movie.", "Ok")
    # Setup the UI using the decorator class
    self.ui=WinUi()
    self.ui.setupUi(self)
    self.setWindowTitle('Tempy 0.1a by Artur Czyzewski')
    # Connect the mouse "clicked" event to a function
    self.ui.butmmc.clicked.connect(self.clickmmc)
    self.ui.butphone.clicked.connect(self.clickphone)
    self.ui.butchoose.clicked.connect(self.clickchoose)
  def clickmmc(self):
    self.click('/media/mmc1/Videos/')
  def clickphone(self):
    self.click('/home/user/MyDocs/.videos/')
  def clickchoose(self):
    # input dialog with dir choose
#    fdirdialog = QFileDialog(self);
#    fdirdialog.setFileMode(QFileDialog.DirectoryOnly)
    fdir = QFileDialog.getExistingDirectory(self, "Open df", "", QFileDialog.ShowDirsOnly | QFileDialog.DontResolveSymlinks)
    #if fdirdialog.exec_():
      #fdir = str(fdirdialog.selectedFiles().first())
      #self.click(fdir)
    self.click(fdir+'/')
  def click(self, place):
    import os
    foundone = 0
    for root, dirs, files in os.walk('/home/user/MyDocs/tmp'):
      for file in files:
        foundone = 1
        QMessageBox.information(self, "Flash temp file has been found", "Name: %s " % files[0])
        fname = QInputDialog.getText(self, 'Enter filename', 'Please enter video file name (without "."):')
        if fname[0]=="":
          filechk=QFile.copy('/home/user/MyDocs/tmp/'+files[0],place+files[0])
        else:
          filechk=QFile.copy('/home/user/MyDocs/tmp/'+files[0],place+fname[0]+'.flv')
        if filechk==0:
          QMessageBox.critical(self, "Error", "File already exist or other error.")
        else:
          QMessageBox.information(self, "Success", "File copied to "+place)
    if foundone==0:
      QMessageBox.information(self, "Nothing found, sorry", "Cannot find any files in temp folder.")
# Standard things
# Create an application then create a window.
# Show the window and run the main loop
app=QApplication(sys.argv)
win=Win()
win.show()
app.exec_()