/*
 * Copyright (c) 2010 David Galindo <nowheremanmail@gmail.com>
 */

#ifndef EWALLET_H
#define EWALLET_H



#include <QtGui>
#include <QDebug>

#include "DatabaseManager.h"
#include "DetailedWindow.h"
#include "OptionsDialog.h"
#include "AntiTheftOptionsDialog.h"
#include "RenameGroupDialog.h"
#include "DetailedWindow.h"
#include "LoginDialog.h"
#include "EditTemplates.h"
#include "ListOfCards.h"

extern DatabaseManager * dbManager;

//class MyLoadImageThread: public QThread {
//	Q_OBJECT
//
//	signals:
//		void loadImageFor (int index);
//	public:
//		int size;
//
//		void run() {
//			qDebug () << "loading images START";
//			for (int i = 0; i < size; i++) {
//				qDebug () << "loading image " << i;
//				emit loadImageFor(i);
//			}
//			qDebug () << "loading images FINISH";
//		}
//};

class eWallet: public QMainWindow
{
	Q_OBJECT

public:

	eWallet (QWidget * parent = 0);
	eWallet (QString * group, eWallet *_parent, QWidget *parent = 0);
	~eWallet ();

	static void preProcessImage (QImage * image);

	bool _updateTarget(Target* t);
	bool _updateTargetPicture(Target* target);
	bool _updateTargetPictureBack(Target* target);
	bool _insertTarget(Target* target);
	bool __insertTarget(Target* target);
	
	QList<Target*> * types;
	//QList<QList<TargetField*>*> * fieldsByType;

	void showN ();
	void hideN ();

public slots:
	Q_SCRIPTABLE void listenInactivity(QString s);
	bool deleteTarget(Target * t);
	void deleteDB ();

private:
//	class MyDelegate;

	//QPointer<MyLoadImageThread> threadLoad;

//	QAbstractItemDelegate * originalDelegate;
//	QAbstractItemDelegate * newDelegate;

	void initTemplates ();

	bool openDataBase (const QString & pas);
	void showList (bool interactive);
	void keyPressEvent(QKeyEvent*);
	void createMenu();
	//void showGroups(bool reset);
	void showInfo(bool reset);
	//void showTargets(bool reset, const QString * filter);

	void loadTypesAndFields ();
	void _loadTypesAndFields (QList<Target*> * types); //, QList<QList<TargetField*>*> * fieldsByType);

	//void filterBy (const QString & s);
	//QPixmap getImage (Target * f);

	bool isAskPassword;
	bool isChangingPassword;

    void reallyChangePassword (const QString & newPassword);

private slots:
	void viewGroup(QString * _target);

	void finalPassword (const QString pas);
	void finalChangePassword (const QString pas);
	void finalUnlock (const QString pas);

	void orientationChanged(int);
    void walletDestroyed(QObject* obj = 0);
    void windowDestroyed(QObject* obj = 0);
    void windowDestroyedExtra(QObject* obj = 0);
    void windowDestroyedEdit(QObject* obj = 0);
    void windowDestroyedTemplates(QObject* obj = 0);

    void editTemplates();

    void changePassword ();

	void _editTarget();
    void _sort ();
//    void _newLikeTarget ();
//    void _duplicateTarget ();

    void newLikeTarget (Target * );
    void duplicateTarget (Target * );
	void newTarget();
	void editTarget(Target * t);
	void viewTarget(Target * t);

//	void _editcTarget();
////	void _clickBack();
//	void _deletecTarget();
//	void _viewcTarget();
	void lockWallet ();
//	void _cancelSearch ();
//	void _hideSearch ();
	void about ();
	void options ();
	void optionsAntiTheft ();
	void import();
	void exportData();
	void exportXml();
	void importXml();
	void mergeDB();
	//void textChanged (const QString &);
	//void contextMenuEvent (QContextMenuEvent * event);
	void renameGroup (QString n);
	bool deleteGroup (QString n);

	void createDatabase ();
	void migrateDatabase (int from, int to);

private:
	QSettings settings;
	QPointer<OptionsDialog> optionsDlg;
	QPointer<AntiTheftOptionsDialog> optionsAntiThefDlg;

	void askPassword ();
	void askAgainPassword ();
	void closeEvent(QCloseEvent *event);
	bool isFirst;
	bool isUnLockMode;
//	QVBoxLayout * vboxlayout;
	int times;
//	QListWidget* fnListWidget;
//	QList<Target *> list;
//	QList<QString> grouplist;

//	QHBoxLayout * inputWidget;
//	QPushButton * cancelSearch;
//	QPushButton * hideSearch;
//	QLineEdit * searchField;
	//QPushButton * backButton;

	QPointer<EditTemplates> templatesWindow;
	QPointer<LoginDialog> loginDialogDlg;
	QPointer<DetailWindow> detailWindow;
	QPointer<DetailWindow> detailWindowEdit;
	QPointer<eWallet> extraWindow;
	QPointer<ListOfCards> centralWidget;

	QWidget * centerwidget;
	QVBoxLayout * centerlayout;

	QPointer <QMessageBox> messageBox;
	bool opendb;
	bool initdb;
	//bool ascSort;
	int isShowGroups;
//	QString currentFilter;
	QString * currentGroup;

	QString tempPass;
};


#endif // EWALLET_H
