#ifndef REVERSIITEM_H
#define REVERSIITEM_H

#include <QGraphicsPixmapItem>
#include <QPixmap>

#include "reversidefs.h"

class QGraphicsScene;

class ReversiItem;

class PixmapsFactory
{
public:
    PixmapsFactory();
    ~PixmapsFactory();
private:
    QPixmap *chipPixmaps_[13];

    friend class ReversiItem;
}; //class PixmapsFactory

class ReversiItem : public QGraphicsPixmapItem
{
public:
    ReversiItem(QGraphicsScene *scene, PixmapsFactory *pixmapsFactory);
    static void initPixmaps();
    void setColor(int c);
    int width() const {return pixmap().width();}
    int height() const {return pixmap().height();}
private:
    PixmapsFactory *pixmapsFactory_;
};

#endif // REVERSIITEM_H
