#include <QHBoxLayout>
#include <QVBoxLayout>
#include <QGridLayout>
#include <QLabel>
#include <QFont>
#include <QChar>

#include "pixmaps/WhiteCell.xpm"
#include "pixmaps/BlackCell.xpm"

#include "infopanel.h"
#include "reversigame.h"

InfoPanel::InfoPanel(const ReversiGame &reversiGame, QWidget *parent) :
    QWidget(parent),
    reversiGame_(reversiGame)
{
    QGridLayout *layout = new QGridLayout(this);

    QLabel *lb = new QLabel(this);
    lb->setPixmap(WhiteCell_xpm);
    layout->addWidget(lb, 0, 0);
    lbWhite = new QLabel("02", this);
    QFont fn = lbWhite->font();
    fn.setFixedPitch(true);
    lbWhite->setFont(fn);
    layout->addWidget(lbWhite, 0, 1);

    lb = new QLabel(this);
    lb->setPixmap(BlackCell_xpm);
    layout->addWidget(lb, 0, 2);
    lbBlack = new QLabel("02", this);
    fn = lbBlack->font();
    fn.setFixedPitch(true);
    lbBlack->setFont(fn);
    layout->addWidget(lbBlack, 0, 3);

    lbTurnMsg = new QLabel(tr("Black turn"), this);
    lbTurnMsg->setAlignment(Qt::AlignCenter);
    fn = lbTurnMsg->font();
    fn.setFixedPitch(true);
    lbTurnMsg->setFont(fn);
    layout->addWidget(lbTurnMsg, 1, 0, 1, 4);

    setLayout(layout);

    connect(&reversiGame_, SIGNAL(updateInfo()), this, SLOT(slotStepComplete()) );
    connect(&reversiGame_, SIGNAL(newGame(int)), this, SLOT(slotStepComplete()) );
}

void InfoPanel::setInfo()
{
    static const char *players[] = {QT_TR_NOOP("White"), QT_TR_NOOP("Black")};
    QString turnInfo;
    QString s;
    QChar ch0('0');
    turnInfo = QString(tr("%1 turn")).arg(tr(players[reversiGame_.currentPlayer()]));
    lbTurnMsg->setText(turnInfo);
    lbTurnMsg->update();

    s = QString("%1").arg(int(reversiGame_.score(White)), 2, 10, ch0);
    lbWhite->setText(s);
    lbWhite->update();
    s = QString("%1").arg(int(reversiGame_.score(Black)), 2, 10, ch0);
    lbBlack->setText(s);
    lbBlack->update();
}

void InfoPanel::slotStepComplete()
{
    setInfo();
}
