#include <QSettings>

#include "score.h"

Score::Score()
{
    /*
    for (unsigned i = 0; i < NUM_AI_LEVELS; ++i)
        for (unsigned j = 0; j < 3; ++j)
            score_[i][j] = 0;
     */
    QSettings settings;
    settings.beginReadArray("score");
    for (unsigned i = 0; i < NUM_AI_LEVELS; ++i)
    {
        settings.setArrayIndex(i);
        score_[i][0] = settings.value("win", 0).toUInt();
        score_[i][1] = settings.value("loss", 0).toUInt();
        score_[i][2] = settings.value("draw", 0).toUInt();
    }
}

Score::~Score()
{
    QSettings settings;
    settings.beginWriteArray("score", NUM_AI_LEVELS);
    for (unsigned i = 0; i < NUM_AI_LEVELS; ++i)
    {
        settings.setArrayIndex(i);
        settings.setValue("win", score_[i][0]);
        settings.setValue("loss", score_[i][1]);
        settings.setValue("draw", score_[i][2]);
    }
}
