#include <QByteArray>
#include <QtNetwork/QTcpSocket>

#include "protocol.h"

const char *PROTOCOL_VERSION = "v1";

void writeP2PData(QTcpSocket *socket, const QString &data)
{
    //send data to net
    QByteArray block;
    QDataStream out(&block, QIODevice::WriteOnly);
    out.setVersion(QDataStream::Qt_4_0);
    //out << (quint16)0;
    out << (quint8)0;
    out << data;
    out.device()->seek(0);
    //out << (quint16)(block.size() - sizeof(quint16));
    out << (quint8)(block.size() - sizeof(quint8));
    socket->write(block);
}

QString readP2PData(QTcpSocket *socket)
{
    //static quint16 blockSize = 0;
    static quint8 blockSize = 0;
    QString data;
    QDataStream in(socket);
    in.setVersion(QDataStream::Qt_4_0);

    if (blockSize == 0)
    {
        //if (socket->bytesAvailable() < (int)sizeof(quint16))
        if (socket->bytesAvailable() < (int)sizeof(quint8))
            return data;

         in >> blockSize;
    }
    if (socket->bytesAvailable() < blockSize)
        return data;
    in >> data;
    blockSize = 0;
    return data;
}
