#include <QLabel>
#include <QPushButton>
#include <QVBoxLayout>
#include <QHBoxLayout>
#include <QComboBox>
#include <QByteArray>


#include <QtNetwork/QTcpServer>
#include <QtNetwork/QTcpSocket>
#include <QtNetwork/QHostAddress>
#include <QtNetwork/QNetworkInterface>

#include "serverdialog.h"
#include "reversidefs.h"
#include "protocol.h"

ServerDialog::ServerDialog(QTcpServer *gameServer, QTcpSocket **gameConnection, bool isConnected, QWidget *parent) :
    QDialog(parent),
    gameServer_(gameServer),
    gameConnection_(gameConnection)
{
    QVBoxLayout *topLayout = new QVBoxLayout(this);
    QLabel *lb = new QLabel(tr("Waiting white player (client)"), this);
    topLayout->addWidget(lb);
    lb = new QLabel(tr("The server is running on:"), this);
    topLayout->addWidget(lb);

    QHBoxLayout *serverLayout = new QHBoxLayout;
    lb = new QLabel(tr("IP:"), this);
    serverLayout->addWidget(lb);
    cbAddresses_ = new QComboBox(this);
    QHostAddress serverAddr;
    serverAddr = gameServer_->serverAddress();
    int addrInd = -1;

    QList<QHostAddress> ipAddressesList = QNetworkInterface::allAddresses();
    for (int i = 0, j = 0; i < ipAddressesList.size(); ++i)
        if (ipAddressesList.at(i) != QHostAddress::LocalHost && ipAddressesList.at(i).toIPv4Address())
        {
            cbAddresses_->addItem(ipAddressesList.at(i).toString());
            if (serverAddr == ipAddressesList.at(i))
                addrInd = j;
            ++j;
        }
    if (addrInd != -1)
        cbAddresses_->setCurrentIndex(addrInd);

    serverLayout->addWidget(cbAddresses_);
    lb = new QLabel(tr("Port:"), this);
    serverLayout->addWidget(lb);
    lbPort_ = new QLabel(tr("0"), this);
    serverLayout->addWidget(lbPort_);
    topLayout->addItem(serverLayout);

    if (gameServer_->isListening())
    {
        QString port("%1");
        lbPort_->setText(port.arg(gameServer_->serverPort()));
    }

    QHBoxLayout *buttonLayout = new QHBoxLayout;
    buttonLayout->addStretch(1);
    btNewGame_ = new QPushButton(tr("&New game"), this);
    btNewGame_->setAutoDefault(true);
    btNewGame_->setEnabled(isConnected);
    buttonLayout->addWidget(btNewGame_);
    QPushButton *btCancel = new QPushButton(tr("&Cancel"), this);
    buttonLayout->addWidget(btCancel);
    topLayout->addItem(buttonLayout);

    connect(btCancel, SIGNAL(pressed()), SLOT(reject()));
    connect(btNewGame_, SIGNAL(pressed()), SLOT(accept()));
    connect(cbAddresses_, SIGNAL(currentIndexChanged(QString)), SLOT(slotAddressChanged(QString)));
    connect(gameServer_, SIGNAL(newConnection()), SLOT(slotNewConnection()));
}

void ServerDialog::slotNewConnection()
{
    *gameConnection_ = gameServer_->nextPendingConnection();
    connect(*gameConnection_, SIGNAL(disconnected()), *gameConnection_, SLOT(deleteLater()));
    btNewGame_->setEnabled(true);
}

void ServerDialog::slotAddressChanged(const QString & address)
{
    if (gameServer_->isListening())
    {
        gameServer_->close();
        btNewGame_->setEnabled(false);
    }
    gameServer_->listen(QHostAddress(address));
    QString port("%1");
    lbPort_->setText(port.arg(gameServer_->serverPort()));
}//slotAddressChanged
