import QtQuick 1.0
import "../../shared" 1.0

Rectangle {
    id: s; width: 620; height: 600; color: "lightsteelblue"
    property string text: "<b>The</b> <i>quick</i> <u>brown</u> <o>fox</o> <big>jumps</big> <small>over</small> <tt>the</tt> <s>lazy</s> <em>dog</em>."

    Column {
        spacing: 6
        TestText {
            text: s.text
        }
        TestText {
            text: s.text; font.pixelSize: 18
        }
        TestText {
            text: s.text; font.pointSize: 18
        }
        TestText {
            text: s.text; color: "red"; smooth: true
        }
        TestText {
            text: s.text; font.capitalization: "AllUppercase"
        }
        TestText {
            text: s.text; font.underline: true
        }
        TestText {
            text: s.text; font.overline: true; smooth: true
        }
        TestText {
            text: s.text; font.strikeout: true
        }
        TestText {
            text: s.text; font.underline: true; font.overline: true; font.strikeout: true
        }
        TestText {
            text: s.text; font.letterSpacing: 2
        }
        TestText {
            text: s.text; font.underline: true; font.letterSpacing: 2; font.capitalization: "AllUppercase"; color: "blue"
        }
        TestText {
            text: s.text; font.overline: true; font.wordSpacing: 25; font.capitalization: "Capitalize"; color: "green"
        }
        TestText {
            text: s.text; font.pixelSize: 18; style: Text.Outline; styleColor: "white"
        }
        TestText {
            text: s.text; font.pixelSize: 18; style: Text.Sunken; styleColor: "gray"
        }
        TestText {
            text: s.text; font.pixelSize: 18; style: Text.Raised; styleColor: "yellow"
        }
        TestText {
            text: s.text; horizontalAlignment: Text.AlignLeft; width: s.width
        }
        TestText {
            text: s.text; horizontalAlignment: Text.AlignHCenter; verticalAlignment: Text.AlignVCenter; width: s.width; height: 20
        }
        TestText {
            text: s.text; horizontalAlignment: Text.AlignRight; verticalAlignment: Text.AlignBottom; width: s.width; height: 20
        }
        Row{
            height: childrenRect.height;
            spacing: 4
            TestText {
                text: s.text + " thisisaverylongstringwithnospaces"; width: 150; wrapMode: Text.WrapAnywhere
            }
            TestText {
                text: s.text + " thisisaverylongstringwithnospaces"; width: 150; wrapMode: Text.Wrap
            }
            TestText {
                text: s.text; font.pixelSize: 18; style: Text.Outline; styleColor: "white"; wrapMode: Text.WordWrap; width: 200
            }
        }
    }
}
