//HelpViewer.h: Header file for the HelpViewer class. This dialog class embeds an QWebView (QtWebKit) for displaying dynamic online help content.
#ifndef HELPVIEWER_H
#define HELPVIEWER_H

#include <QtGui/QDialog>
#include <QtGui/QVBoxLayout>
#include <QtWebKit/QWebView>
#include <QtCore/QUrl>

class HelpViewer: public QDialog
{
    Q_OBJECT

public:

    HelpViewer(QWidget* pParent = 0);
    ~HelpViewer();

    void setContent(const QString& url); //Set the URL of help content to be displayed

private:

    QWebView* m_pWebView; //Main web view instance for displaying actual online help content

    QVBoxLayout m_MainLayout; //Main dialog layout manager instance

private slots:

    void OnContentLoadStarted(); //notification that web page load has been initiated
    void OnContentLoadFinished(bool ok); //notification that web content has completetly loaded (ok param is true on success)

};

#endif // HELPVIEWER_H
