#include "mainwindow.h"
#include "ui_mainwindow.h"

#include "about.h"
#include "help.h"
#include "instructions.h"
#include "terms.h"

#include <QtCore/QCoreApplication>
#include <QDesktopServices>
#include <QShortcut>
#include <QUrl>
#include <QFileInfo>


MainWindow::MainWindow(QWidget *parent):
    QMainWindow(parent), ui(new Ui::MainWindow),
      about(0),
      help(0),
      instructions(0),
      terms(0)

{
    ui->setupUi(this);

    this->setWindowTitle("Qnotted");
    this->setAttribute(Qt::WA_Maemo5StackedWindow);

    ui->pushButtonBend->setText(tr("Bends"));
    ui->pushButtonEnd->setText(tr("End Loops"));
    ui->pushButtonHitch->setText(tr("Hitches"));
    ui->pushButtonMid->setText(tr("Mid Loops"));
    ui->pushButtonStop->setText(tr("Stoppers"));
    ui->pushButtonLash->setText(tr("Lashings"));

    ui->actionAbout->setText(tr("About"));
    ui->actionHelp->setText(tr("Help"));
    ui->actionReadme->setText(tr("Disclaimer"));
    ui->actionTerms->setText(tr("Knot Terminology"));

    about = new About(this);
    help = new Help(this);
    instructions = new Instructions(this);
    terms = new Terminology(this);

    // For Connecting Keyboard Buttons
      connectSignals();

}

MainWindow::~MainWindow()
{
    if (about) delete (about);
    if (help) delete (help);
    if (instructions) delete (instructions);
    if (terms) delete (terms);

    delete ui;
}

void MainWindow::setOrientation(ScreenOrientation orientation)
{
#if defined(Q_OS_SYMBIAN)
    // If the version of Qt on the device is < 4.7.2, that attribute won't work
    if (orientation != ScreenOrientationAuto) {
        const QStringList v = QString::fromAscii(qVersion()).split(QLatin1Char('.'));
        if (v.count() == 3 && (v.at(0).toInt() << 16 | v.at(1).toInt() << 8 | v.at(2).toInt()) < 0x040702) {
            qWarning("Screen orientation locking only supported with Qt 4.7.2 and above");
            return;
        }
    }
#endif // Q_OS_SYMBIAN

    Qt::WidgetAttribute attribute;
    switch (orientation) {
#if QT_VERSION < 0x040702
    // Qt < 4.7.2 does not yet have the Qt::WA_*Orientation attributes
    case ScreenOrientationLockPortrait:
        attribute = static_cast<Qt::WidgetAttribute>(128);
        break;
    case ScreenOrientationLockLandscape:
        attribute = static_cast<Qt::WidgetAttribute>(129);
        break;
    default:
    case ScreenOrientationAuto:
        attribute = static_cast<Qt::WidgetAttribute>(130);
        break;
#else // QT_VERSION < 0x040702
    case ScreenOrientationLockPortrait:
        attribute = Qt::WA_LockPortraitOrientation;
        break;
    case ScreenOrientationLockLandscape:
        attribute = Qt::WA_LockLandscapeOrientation;
        break;
    default:
    case ScreenOrientationAuto:
        attribute = Qt::WA_AutoOrientation;
        break;
#endif // QT_VERSION < 0x040702
    };
    setAttribute(attribute, true);
}

void MainWindow::showExpanded()
{
#if defined(Q_OS_SYMBIAN) || defined(Q_WS_SIMULATOR)
    showFullScreen();
#elif defined(Q_WS_MAEMO_5)
    showMaximized();
#else
    show();
#endif
}

// Keyboard Button Signals - remember to include QShortcut
void MainWindow::connectSignals()
{

// Keyboard Key Signals
  connect(new QShortcut(QKeySequence(Qt::Key_Q), this), SIGNAL(activated()), this, SLOT(on_pushButtonBend_pressed()));
  connect(new QShortcut(QKeySequence(Qt::Key_W), this), SIGNAL(activated()), this, SLOT(on_pushButtonEnd_pressed()));
  connect(new QShortcut(QKeySequence(Qt::Key_E), this), SIGNAL(activated()), this, SLOT(on_pushButtonHitch_pressed()));
  connect(new QShortcut(QKeySequence(Qt::Key_R), this), SIGNAL(activated()), this, SLOT(on_pushButtonMid_pressed()));
  connect(new QShortcut(QKeySequence(Qt::Key_T), this), SIGNAL(activated()), this, SLOT(on_pushButtonStop_pressed()));
  connect(new QShortcut(QKeySequence(Qt::Key_Y), this), SIGNAL(activated()), this, SLOT(on_pushButtonLash_pressed()));
}

// End of Keyboard Signals

//Menu

void MainWindow::on_actionAbout_triggered()
{

    about->show();
}

void MainWindow::on_actionHelp_triggered()
{
    help->show();
}

void MainWindow::on_actionTerms_triggered()
{
    terms->show();
}

void MainWindow::on_actionReadme_triggered()
{
    instructions->show();
}

//Buttons

void MainWindow::on_pushButtonBend_pressed()
{
    Wbend *wbend = new Wbend(this);
    wbend->show();
}

void MainWindow::on_pushButtonEnd_pressed()
{
    Wend *wend = new Wend(this);
    wend->show();
}

void MainWindow::on_pushButtonHitch_pressed()
{
    Whitch *whitch = new Whitch(this);
    whitch->show();
}

void MainWindow::on_pushButtonMid_pressed()
{
    Wmid *wmid = new Wmid(this);
    wmid->show();
}

void MainWindow::on_pushButtonStop_pressed()
{
    Wstop *wstop = new Wstop(this);
    wstop->show();
}

void MainWindow::on_pushButtonLash_pressed()
{
    Wlash *wlash = new Wlash(this);
    wlash->show();
}
